/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryProjectStructureElement
extends ProjectStructureElement {
    private final Library a;

    public LibraryProjectStructureElement(@NotNull StructureConfigurableContext structureConfigurableContext, @NotNull Library library) {
        if (structureConfigurableContext == null) {
            LibraryProjectStructureElement.b(0);
        }
        if (library == null) {
            LibraryProjectStructureElement.b(1);
        }
        super(structureConfigurableContext);
        this.a = library;
    }

    public Library getLibrary() {
        return this.a;
    }

    @Override
    public void check(ProjectStructureProblemsHolder projectStructureProblemsHolder) {
        if (((LibraryEx)this.a).isDisposed()) {
            return;
        }
        LibraryEx libraryEx = (LibraryEx)this.myContext.getLibraryModel(this.a);
        if (libraryEx == null || libraryEx.isDisposed()) {
            return;
        }
        this.a(projectStructureProblemsHolder, libraryEx, OrderRootType.CLASSES, "classes", ProjectStructureProblemType.error("library-invalid-classes-path"));
        String string = libraryEx.getName();
        if (string == null || !string.startsWith("Maven: ")) {
            this.a(projectStructureProblemsHolder, libraryEx, OrderRootType.SOURCES, "sources", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
            this.a(projectStructureProblemsHolder, libraryEx, JavadocOrderRootType.getInstance(), "javadoc", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
        }
    }

    private void a(ProjectStructureProblemsHolder projectStructureProblemsHolder, LibraryEx libraryEx, @NotNull OrderRootType orderRootType, String string, ProjectStructureProblemType projectStructureProblemType) {
        List list2;
        if (orderRootType == null) {
            LibraryProjectStructureElement.b(2);
        }
        if (!(list2 = libraryEx.getInvalidRootUrls(orderRootType)).isEmpty()) {
            String string2 = LibraryProjectStructureElement.a(list2, string, libraryEx.getName());
            PlaceInProjectStructure placeInProjectStructure = this.b();
            String string3 = ProjectBundle.message((String)"project.roots.error.message.invalid.roots", (Object[])new Object[]{string, list2.size()});
            ProjectStructureProblemDescription.ProblemLevel problemLevel = libraryEx.getTable().getTableLevel().equals("project") ? ProjectStructureProblemDescription.ProblemLevel.PROJECT : ProjectStructureProblemDescription.ProblemLevel.GLOBAL;
            projectStructureProblemsHolder.registerProblem(new ProjectStructureProblemDescription(string3, string2, placeInProjectStructure, projectStructureProblemType, problemLevel, Collections.singletonList(new RemoveInvalidRootsQuickFix((Library)libraryEx, orderRootType, list2)), true));
        }
    }

    private static String a(List<String> list2, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = StringUtil.escapeXml((String)string2);
        stringBuilder.append("Library ");
        stringBuilder.append("<a href='http://library/").append(string3).append("'>").append(string3).append("</a>");
        stringBuilder.append(" has broken " + string + " " + StringUtil.pluralize((String)"path", (int)list2.size()) + ":");
        for (String string4 : list2) {
            stringBuilder.append("<br>&nbsp;&nbsp;");
            stringBuilder.append(PathUtil.toPresentableUrl((String)string4));
        }
        return XmlStringUtil.wrapInHtml((CharSequence)stringBuilder);
    }

    @NotNull
    private PlaceInProjectStructure b() {
        Project project2 = this.myContext.getProject();
        PlaceInProjectStructureBase placeInProjectStructureBase = new PlaceInProjectStructureBase(project2, ProjectStructureConfigurable.getInstance(project2).createProjectOrGlobalLibraryPlace(this.a), this);
        if (placeInProjectStructureBase == null) {
            LibraryProjectStructureElement.b(3);
        }
        return placeInProjectStructureBase;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LibraryProjectStructureElement)) {
            return false;
        }
        return this.a() == ((LibraryProjectStructureElement)object).a();
    }

    public ActionCallback navigate() {
        return this.b().navigate();
    }

    @NotNull
    private Library a() {
        InvocationHandler invocationHandler = Proxy.isProxyClass(this.a.getClass()) ? Proxy.getInvocationHandler(this.a) : null;
        Library library = invocationHandler instanceof ModuleEditor.ProxyDelegateAccessor ? (Library)((ModuleEditor.ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate() : this.a;
        Library library2 = library instanceof LibraryImpl ? ((LibraryImpl)library).getSource() : null;
        Library library3 = library2 != null ? library2 : this.a;
        if (library3 == null) {
            LibraryProjectStructureElement.b(4);
        }
        return library3;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.a());
    }

    @Override
    public boolean shouldShowWarningIfUnused() {
        LibraryTable libraryTable = this.a.getTable();
        if (libraryTable == null) {
            return false;
        }
        return "project".equals(libraryTable.getTableLevel());
    }

    @Override
    public ProjectStructureProblemDescription createUnusedElementWarning() {
        List<ConfigurationErrorQuickFix> list2 = Arrays.asList(new AddLibraryToDependenciesFix(), new RemoveLibraryFix(), new RemoveAllUnusedLibrariesFix());
        String string = StringUtil.escapeXml((String)this.a.getName());
        String string2 = "<a href='http://library/" + string + "'>" + string + "</a>";
        return new ProjectStructureProblemDescription(XmlStringUtil.wrapInHtml((CharSequence)("Library " + string2 + " is not used")), null, this.b(), ProjectStructureProblemType.unused("unused-library"), ProjectStructureProblemDescription.ProblemLevel.PROJECT, list2, false);
    }

    @Override
    public String getPresentableName() {
        return this.a.getName();
    }

    @Override
    public String getTypeName() {
        return "Library";
    }

    @Override
    public String getId() {
        return "library:" + this.a.getTable().getTableLevel() + ":" + this.a.getName();
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceOrThis";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportInvalidRoots";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RemoveAllUnusedLibrariesFix
    extends ConfigurationErrorQuickFix {
        private RemoveAllUnusedLibrariesFix() {
            super("Remove All Unused Libraries");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable baseLibrariesConfigurable = BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject(), "project");
            Library[] libraryArray = baseLibrariesConfigurable.getModelProvider().getModifiableModel().getLibraries();
            ArrayList<LibraryProjectStructureElement> arrayList = new ArrayList<LibraryProjectStructureElement>();
            for (Library library : libraryArray) {
                LibraryProjectStructureElement libraryProjectStructureElement = new LibraryProjectStructureElement(LibraryProjectStructureElement.this.myContext, library);
                if (!LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().getUsages(libraryProjectStructureElement).isEmpty()) continue;
                arrayList.add(libraryProjectStructureElement);
            }
            baseLibrariesConfigurable.removeLibraries(arrayList);
        }
    }

    private class RemoveLibraryFix
    extends ConfigurationErrorQuickFix {
        private RemoveLibraryFix() {
            super("Remove Library");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject(), LibraryProjectStructureElement.this.a.getTable().getTableLevel()).removeLibrary(LibraryProjectStructureElement.this);
        }
    }

    private class AddLibraryToDependenciesFix
    extends ConfigurationErrorQuickFix {
        private AddLibraryToDependenciesFix() {
            super("Add to Dependencies...");
        }

        @Override
        public void performFix() {
            LibraryEditingUtil.showDialogAndAddLibraryToDependencies(LibraryProjectStructureElement.this.a, LibraryProjectStructureElement.this.myContext.getProject(), false);
        }
    }

    private class RemoveInvalidRootsQuickFix
    extends ConfigurationErrorQuickFix {
        private final Library c;
        private final OrderRootType b;
        private final List<String> d;

        public RemoveInvalidRootsQuickFix(Library library, OrderRootType orderRootType, List<String> list2) {
            super("Remove invalid " + StringUtil.pluralize((String)"root", (int)list2.size()));
            this.c = library;
            this.b = orderRootType;
            this.d = list2;
        }

        @Override
        public void performFix() {
            LibraryTable.ModifiableModel modifiableModel = LibraryProjectStructureElement.this.myContext.getModifiableLibraryTable(this.c.getTable());
            if (modifiableModel instanceof LibrariesModifiableModel) {
                for (String string : this.d) {
                    ExistingLibraryEditor existingLibraryEditor = ((LibrariesModifiableModel)modifiableModel).getLibraryEditor(this.c);
                    existingLibraryEditor.removeRoot(string, this.b);
                }
                LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().queueUpdate(LibraryProjectStructureElement.this);
                Object object = ProjectStructureConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject());
                LibraryProjectStructureElement.this.navigate().doWhenDone(() -> {
                    NamedConfigurable namedConfigurable = object.getConfigurableFor(this.c).getSelectedConfigurable();
                    if (namedConfigurable instanceof LibraryConfigurable) {
                        ((LibraryConfigurable)namedConfigurable).updateComponent();
                    }
                });
            }
        }
    }
}

