/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInModuleClasspath;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.UsageInModuleClasspath;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleProjectStructureElement
extends ProjectStructureElement {
    private final Module a;

    public ModuleProjectStructureElement(@NotNull StructureConfigurableContext structureConfigurableContext, @NotNull Module module2) {
        if (structureConfigurableContext == null) {
            ModuleProjectStructureElement.b(0);
        }
        if (module2 == null) {
            ModuleProjectStructureElement.b(1);
        }
        super(structureConfigurableContext);
        this.a = module2;
    }

    public Module getModule() {
        return this.a;
    }

    public void checkModulesNames(ProjectStructureProblemsHolder projectStructureProblemsHolder) {
        ModifiableModuleModel modifiableModuleModel = this.myContext.getModulesConfigurator().getModuleModel();
        Object[] objectArray = modifiableModuleModel.getModules();
        if (!ArrayUtil.contains((Object)this.a, (Object[])objectArray)) {
            return;
        }
        for (Object object : objectArray) {
            if (object == this.a || !this.myContext.getRealName((Module)object).equals(this.myContext.getRealName(this.a))) continue;
            projectStructureProblemsHolder.registerProblem(ProjectBundle.message((String)"project.roots.module.duplicate.name.message", (Object[])new Object[0]), null, ProjectStructureProblemType.error("duplicate-module-name"), this.a(), null);
            break;
        }
    }

    @Override
    public void check(ProjectStructureProblemsHolder projectStructureProblemsHolder) {
        OrderEntry[] orderEntryArray;
        this.checkModulesNames(projectStructureProblemsHolder);
        ModuleRootModel moduleRootModel = this.myContext.getModulesConfigurator().getRootModel(this.a);
        if (moduleRootModel == null) {
            return;
        }
        for (OrderEntry orderEntry : orderEntryArray = moduleRootModel.getOrderEntries()) {
            if (orderEntry.isValid()) continue;
            if (orderEntry instanceof JdkOrderEntry && ((JdkOrderEntry)orderEntry).getJdkName() == null) {
                if (orderEntry instanceof InheritedJdkOrderEntry) continue;
                projectStructureProblemsHolder.registerProblem(ProjectBundle.message((String)"project.roots.module.jdk.problem.message", (Object[])new Object[0]), null, ProjectStructureProblemType.error("module-sdk-not-defined"), this.a(orderEntry), null);
                continue;
            }
            projectStructureProblemsHolder.registerProblem(ProjectBundle.message((String)"project.roots.library.problem.message", (Object[])new Object[]{orderEntry.getPresentableName()}), null, ProjectStructureProblemType.error("invalid-module-dependency"), this.a(orderEntry), null);
        }
    }

    private PlaceInProjectStructure a() {
        Project project2 = this.myContext.getProject();
        return new PlaceInProjectStructureBase(project2, ProjectStructureConfigurable.getInstance(project2).createModulePlace(this.a), this);
    }

    private PlaceInProjectStructure a(OrderEntry orderEntry) {
        return new PlaceInModuleClasspath(this.myContext, this.a, (ProjectStructureElement)this, orderEntry);
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        ArrayList<ProjectStructureElementUsage> arrayList = new ArrayList<ProjectStructureElementUsage>();
        ModuleEditor moduleEditor = this.myContext.getModulesConfigurator().getModuleEditor(this.a);
        if (moduleEditor != null) {
            for (OrderEntry orderEntry : moduleEditor.getOrderEntries()) {
                Module module2;
                ModuleOrderEntry moduleOrderEntry;
                if (orderEntry instanceof ModuleOrderEntry) {
                    moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                    module2 = moduleOrderEntry.getModule();
                    if (module2 == null) continue;
                    arrayList.add(new UsageInModuleClasspath(this.myContext, this, new ModuleProjectStructureElement(this.myContext, module2), moduleOrderEntry.getScope()));
                    continue;
                }
                if (orderEntry instanceof LibraryOrderEntry) {
                    moduleOrderEntry = (LibraryOrderEntry)orderEntry;
                    module2 = moduleOrderEntry.getLibrary();
                    if (module2 == null) continue;
                    arrayList.add(new UsageInModuleClasspath(this.myContext, this, new LibraryProjectStructureElement(this.myContext, (Library)module2), moduleOrderEntry.getScope()));
                    continue;
                }
                if (!(orderEntry instanceof JdkOrderEntry) || (moduleOrderEntry = ((JdkOrderEntry)orderEntry).getJdk()) == null) continue;
                arrayList.add(new UsageInModuleClasspath(this.myContext, this, new SdkProjectStructureElement(this.myContext, (Sdk)moduleOrderEntry), null));
            }
        }
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ModuleProjectStructureElement)) {
            return false;
        }
        return this.a.equals(((ModuleProjectStructureElement)object).a);
    }

    @Override
    public int hashCode() {
        return this.a.hashCode();
    }

    @Override
    public String getPresentableName() {
        return this.a.getName();
    }

    @Override
    public String getTypeName() {
        return "Module";
    }

    @Override
    public String getId() {
        return "module:" + this.a.getName();
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ModuleProjectStructureElement";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

