/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblems;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureDaemonAnalyzer
implements Disposable {
    private static final Logger d = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.validation.ProjectStructureDaemonAnalyzer");
    private final Map<ProjectStructureElement, ProjectStructureProblemsHolderImpl> j = new HashMap<ProjectStructureElement, ProjectStructureProblemsHolderImpl>();
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> l = new MultiValuesMap();
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> f = new MultiValuesMap();
    private final Set<ProjectStructureElement> i = new HashSet<ProjectStructureElement>();
    private final Set<ProjectStructureElement> k = new HashSet<ProjectStructureElement>();
    private final Map<ProjectStructureElement, ProjectStructureProblemDescription> a = new HashMap<ProjectStructureElement, ProjectStructureProblemDescription>();
    private final MergingUpdateQueue c;
    private final MergingUpdateQueue b;
    private final EventDispatcher<ProjectStructureDaemonAnalyzerListener> h = EventDispatcher.create(ProjectStructureDaemonAnalyzerListener.class);
    private final AtomicBoolean g = new AtomicBoolean(false);
    private final ProjectConfigurationProblems e;

    public ProjectStructureDaemonAnalyzer(StructureConfigurableContext structureConfigurableContext) {
        Disposer.register((Disposable)structureConfigurableContext, (Disposable)this);
        this.e = new ProjectConfigurationProblems(this, structureConfigurableContext);
        this.c = new MergingUpdateQueue("Project Structure Daemon Analyzer", 300, false, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.b = new MergingUpdateQueue("Project Structure Analysis Results Updater", 300, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    }

    private void b(ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
        if (this.g.get()) {
            return;
        }
        if (bl2) {
            this.a(projectStructureElement);
        }
        if (bl3) {
            this.c(projectStructureElement);
        }
    }

    private void a(ProjectStructureElement projectStructureElement) {
        ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = new ProjectStructureProblemsHolderImpl();
        ReadAction.run(() -> {
            if (this.g.get()) {
                return;
            }
            if (d.isDebugEnabled()) {
                d.debug("checking " + projectStructureElement);
            }
            ProjectStructureValidator.check(projectStructureElement, projectStructureProblemsHolderImpl);
        });
        this.b.queue((Update)new ProblemsComputedUpdate(projectStructureElement, projectStructureProblemsHolderImpl));
    }

    private void c(ProjectStructureElement projectStructureElement) {
        List list2 = (List)ReadAction.compute(() -> {
            if (this.g.get()) {
                return null;
            }
            if (d.isDebugEnabled()) {
                d.debug("collecting usages in " + projectStructureElement);
            }
            return ProjectStructureDaemonAnalyzer.b(projectStructureElement);
        });
        if (list2 != null) {
            this.b.queue((Update)new UsagesCollectedUpdate(projectStructureElement, list2));
        }
    }

    private static List<ProjectStructureElementUsage> b(ProjectStructureElement projectStructureElement) {
        return ProjectStructureValidator.getUsagesInElement(projectStructureElement);
    }

    private void a(ProjectStructureElement projectStructureElement, List<ProjectStructureElementUsage> list2) {
        this.e(projectStructureElement);
        for (ProjectStructureElementUsage projectStructureElementUsage : list2) {
            this.a(projectStructureElementUsage);
        }
        this.i.remove(projectStructureElement);
        this.b.queue((Update)new ReportUnusedElementsUpdate());
    }

    public void queueUpdate(@NotNull ProjectStructureElement projectStructureElement) {
        if (projectStructureElement == null) {
            ProjectStructureDaemonAnalyzer.a(0);
        }
        this.a(projectStructureElement, true, true);
    }

    private void a(@NotNull ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
        if (projectStructureElement == null) {
            ProjectStructureDaemonAnalyzer.a(1);
        }
        if (d.isDebugEnabled()) {
            d.debug("start " + (bl2 ? "checking " : "") + (bl3 ? "collecting usages " : "") + "for " + projectStructureElement);
        }
        if (bl3) {
            this.i.add(projectStructureElement);
        }
        if (projectStructureElement.shouldShowWarningIfUnused()) {
            this.k.add(projectStructureElement);
        }
        this.c.queue((Update)new AnalyzeElementUpdate(projectStructureElement, bl2, bl3));
    }

    public void removeElement(ProjectStructureElement projectStructureElement) {
        this.removeElements(Collections.singletonList(projectStructureElement));
    }

    public void removeElements(@NotNull List<? extends ProjectStructureElement> list2) {
        if (list2 == null) {
            ProjectStructureDaemonAnalyzer.a(2);
        }
        this.i.removeAll(list2);
        this.k.removeAll(list2);
        for (ProjectStructureElement projectStructureElement : list2) {
            this.a.remove(projectStructureElement);
            this.j.remove(projectStructureElement);
            Collection collection = this.l.removeAll((Object)projectStructureElement);
            if (collection != null) {
                for (ProjectStructureElementUsage projectStructureElementUsage : collection) {
                    this.j.remove(projectStructureElementUsage.getContainingElement());
                }
            }
            this.e(projectStructureElement);
            ((ProjectStructureDaemonAnalyzerListener)this.h.getMulticaster()).problemsChanged(projectStructureElement);
        }
        this.b.queue((Update)new ReportUnusedElementsUpdate());
    }

    private void a() {
        if (!this.i.isEmpty()) {
            return;
        }
        for (ProjectStructureElement projectStructureElement : this.k) {
            Collection collection = this.l.get((Object)projectStructureElement);
            ProjectStructureProblemDescription projectStructureProblemDescription = collection == null || collection.isEmpty() ? projectStructureElement.createUnusedElementWarning() : null;
            ProjectStructureProblemDescription projectStructureProblemDescription2 = this.a.put(projectStructureElement, projectStructureProblemDescription);
            ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = this.j.get(projectStructureElement);
            if (projectStructureProblemsHolderImpl == null) {
                projectStructureProblemsHolderImpl = new ProjectStructureProblemsHolderImpl();
                this.j.put(projectStructureElement, projectStructureProblemsHolderImpl);
            }
            if (projectStructureProblemDescription2 != null) {
                projectStructureProblemsHolderImpl.removeProblem(projectStructureProblemDescription2);
            }
            if (projectStructureProblemDescription != null) {
                projectStructureProblemsHolderImpl.registerProblem(projectStructureProblemDescription);
            }
            if (projectStructureProblemDescription2 == null && projectStructureProblemDescription == null) continue;
            ((ProjectStructureDaemonAnalyzerListener)this.h.getMulticaster()).problemsChanged(projectStructureElement);
        }
    }

    private void e(ProjectStructureElement projectStructureElement) {
        Collection collection = this.f.removeAll((Object)projectStructureElement);
        if (collection != null) {
            for (ProjectStructureElementUsage projectStructureElementUsage : collection) {
                this.l.remove((Object)projectStructureElementUsage.getSourceElement(), (Object)projectStructureElementUsage);
            }
        }
    }

    private void a(@NotNull ProjectStructureElementUsage projectStructureElementUsage) {
        if (projectStructureElementUsage == null) {
            ProjectStructureDaemonAnalyzer.a(3);
        }
        this.l.put((Object)projectStructureElementUsage.getSourceElement(), (Object)projectStructureElementUsage);
        this.f.put((Object)projectStructureElementUsage.getContainingElement(), (Object)projectStructureElementUsage);
    }

    public void stop() {
        d.debug("analyzer stopped");
        this.g.set(true);
        this.c.cancelAllUpdates();
        this.b.cancelAllUpdates();
        this.clearCaches();
        this.c.deactivate();
        this.b.deactivate();
    }

    public void clearCaches() {
        d.debug("clear caches");
        this.j.clear();
    }

    public void queueUpdateForAllElementsWithErrors() {
        ArrayList<ProjectStructureElement> arrayList = new ArrayList<ProjectStructureElement>();
        for (Map.Entry<ProjectStructureElement, ProjectStructureProblemsHolderImpl> entry : this.j.entrySet()) {
            if (!entry.getValue().containsProblems()) continue;
            arrayList.add(entry.getKey());
        }
        this.j.clear();
        d.debug("Adding to queue updates for " + arrayList.size() + " problematic elements");
        for (ProjectStructureElement projectStructureElement : arrayList) {
            this.queueUpdate(projectStructureElement);
        }
    }

    public void dispose() {
        this.g.set(true);
        this.c.cancelAllUpdates();
        this.b.cancelAllUpdates();
    }

    @Nullable
    public ProjectStructureProblemsHolderImpl getProblemsHolder(ProjectStructureElement projectStructureElement) {
        return this.j.get(projectStructureElement);
    }

    public Collection<ProjectStructureElementUsage> getUsages(ProjectStructureElement projectStructureElement) {
        ProjectStructureElement[] projectStructureElementArray;
        for (ProjectStructureElement projectStructureElement2 : projectStructureElementArray = this.i.toArray(new ProjectStructureElement[0])) {
            this.a(projectStructureElement2, ProjectStructureDaemonAnalyzer.b(projectStructureElement2));
        }
        List<ProjectStructureElementUsage> list2 = this.l.get((Object)projectStructureElement);
        return list2 != null ? list2 : Collections.emptyList();
    }

    public void addListener(ProjectStructureDaemonAnalyzerListener projectStructureDaemonAnalyzerListener) {
        d.debug("listener added " + projectStructureDaemonAnalyzerListener);
        this.h.addListener((EventListener)projectStructureDaemonAnalyzerListener);
    }

    public void reset() {
        d.debug("analyzer started");
        this.c.activate();
        this.b.activate();
        this.c.queue(new Update("reset"){

            public void run() {
                ProjectStructureDaemonAnalyzer.this.g.set(false);
            }
        });
    }

    public void clear() {
        this.a.clear();
        this.k.clear();
        this.l.clear();
        this.f.clear();
        this.i.clear();
        this.e.clearProblems();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "queueUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ReportUnusedElementsUpdate
    extends Update {
        private ReportUnusedElementsUpdate() {
            super((Object)"unused elements");
        }

        public void run() {
            ProjectStructureDaemonAnalyzer.this.a();
        }
    }

    private class ProblemsComputedUpdate
    extends Update {
        private final ProjectStructureElement b;
        private final ProjectStructureProblemsHolderImpl a;
        private final Object[] c;

        public ProblemsComputedUpdate(ProjectStructureElement projectStructureElement, ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl) {
            super((Object)projectStructureElement);
            this.b = projectStructureElement;
            this.a = projectStructureProblemsHolderImpl;
            this.c = new Object[]{projectStructureElement, "problems computed"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.c == null) {
                ProblemsComputedUpdate.a(0);
            }
            return this.c;
        }

        public void run() {
            ProjectStructureProblemDescription projectStructureProblemDescription;
            if (ProjectStructureDaemonAnalyzer.this.g.get()) {
                return;
            }
            if (d.isDebugEnabled()) {
                d.debug("updating problems for " + this.b);
            }
            if ((projectStructureProblemDescription = (ProjectStructureProblemDescription)ProjectStructureDaemonAnalyzer.this.a.get(this.b)) != null) {
                this.a.registerProblem(projectStructureProblemDescription);
            }
            ProjectStructureDaemonAnalyzer.this.j.put(this.b, this.a);
            ((ProjectStructureDaemonAnalyzerListener)ProjectStructureDaemonAnalyzer.this.h.getMulticaster()).problemsChanged(this.b);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$ProblemsComputedUpdate", "getEqualityObjects"));
        }
    }

    private class UsagesCollectedUpdate
    extends Update {
        private final ProjectStructureElement a;
        private final List<ProjectStructureElementUsage> c;
        private final Object[] b;

        public UsagesCollectedUpdate(ProjectStructureElement projectStructureElement, List<ProjectStructureElementUsage> list2) {
            super((Object)projectStructureElement);
            this.a = projectStructureElement;
            this.c = list2;
            this.b = new Object[]{projectStructureElement, "usages collected"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.b == null) {
                UsagesCollectedUpdate.a(0);
            }
            return this.b;
        }

        public void run() {
            if (ProjectStructureDaemonAnalyzer.this.g.get()) {
                return;
            }
            if (d.isDebugEnabled()) {
                d.debug("updating usages for " + this.a);
            }
            ProjectStructureDaemonAnalyzer.this.a(this.a, this.c);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$UsagesCollectedUpdate", "getEqualityObjects"));
        }
    }

    private class AnalyzeElementUpdate
    extends Update {
        private final ProjectStructureElement c;
        private final boolean b;
        private final boolean d;
        private final Object[] a;

        public AnalyzeElementUpdate(ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
            super((Object)projectStructureElement);
            this.c = projectStructureElement;
            this.b = bl2;
            this.d = bl3;
            this.a = new Object[]{this.c, this.b, this.d};
        }

        public boolean canEat(Update update) {
            if (!(update instanceof AnalyzeElementUpdate)) {
                return false;
            }
            AnalyzeElementUpdate analyzeElementUpdate = (AnalyzeElementUpdate)update;
            return !(!this.c.equals(analyzeElementUpdate.c) || analyzeElementUpdate.b && !this.b || analyzeElementUpdate.d && !this.d);
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.a == null) {
                AnalyzeElementUpdate.a(0);
            }
            return this.a;
        }

        public void run() {
            try {
                ProjectStructureDaemonAnalyzer.this.b(this.c, this.b, this.d);
            }
            catch (Throwable throwable) {
                d.error(throwable);
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$AnalyzeElementUpdate", "getEqualityObjects"));
        }
    }
}

