/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.ProjectCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectCheckoutListener
implements CheckoutListener {
    private static final Logger a = Logger.getInstance(NewProjectCheckoutListener.class);

    public boolean processCheckedOutDirectory(Project project2, File file) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        a.assertTrue(virtualFile != null, (Object)("Can't find " + file));
        int n2 = Messages.showYesNoDialog((Project)project2, (String)VcsBundle.message((String)"checkout.create.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), file.getAbsolutePath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (n2 == 0) {
            AddModuleWizard addModuleWizard = this.createImportWizard(virtualFile);
            if (addModuleWizard == null) {
                return false;
            }
            if (addModuleWizard.showAndGet()) {
                ImportModuleAction.createFromWizard(null, addModuleWizard);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected AddModuleWizard createImportWizard(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            NewProjectCheckoutListener.a(0);
        }
        return ImportModuleAction.createImportWizard(null, null, virtualFile, (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions());
    }

    public void processOpenedProject(Project project2) {
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkout/NewProjectCheckoutListener", "createImportWizard"));
    }
}

