/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.server.BuildManager;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactImpl;
import com.intellij.packaging.impl.artifacts.ArtifactLoadingErrorDescription;
import com.intellij.packaging.impl.artifacts.ArtifactManagerStateSplitter;
import com.intellij.packaging.impl.artifacts.ArtifactModelBase;
import com.intellij.packaging.impl.artifacts.ArtifactModelImpl;
import com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactVirtualFileListener;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.UnknownPackagingElementTypeException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.artifact.ArtifactManagerState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactPropertiesState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

@State(name="ArtifactManager", storages={@Storage(value="artifacts", stateSplitter=ArtifactManagerStateSplitter.class)})
public class ArtifactManagerImpl
extends ArtifactManager
implements ProjectComponent,
PersistentStateComponent<ArtifactManagerState>,
Disposable {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.packaging.impl.artifacts.ArtifactManagerImpl");
    @NonNls
    public static final String COMPONENT_NAME = "ArtifactManager";
    @NonNls
    public static final String PACKAGING_ELEMENT_NAME = "element";
    @NonNls
    public static final String TYPE_ID_ATTRIBUTE = "id";
    private final ArtifactManagerModel d;
    private final Project e;
    private final DefaultPackagingElementResolvingContext g;
    private boolean f = false;
    private boolean b;
    private final SimpleModificationTracker c = new SimpleModificationTracker();
    private final Map<String, LocalFileSystem.WatchRequest> h = new HashMap<String, LocalFileSystem.WatchRequest>();

    public ArtifactManagerImpl(Project project2) {
        this.e = project2;
        this.d = new ArtifactManagerModel();
        this.g = new DefaultPackagingElementResolvingContext(this.e);
        ((ArtifactPointerManagerImpl)ArtifactPointerManager.getInstance((Project)project2)).setArtifactManager(this);
    }

    @NotNull
    public Artifact[] getArtifacts() {
        Artifact[] artifactArray = this.d.getArtifacts();
        if (artifactArray == null) {
            ArtifactManagerImpl.a(0);
        }
        return artifactArray;
    }

    public Artifact findArtifact(@NotNull String string) {
        if (string == null) {
            ArtifactManagerImpl.a(1);
        }
        return this.d.findArtifact(string);
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactManagerImpl.a(2);
        }
        Artifact artifact2 = this.d.getArtifactByOriginal(artifact);
        if (artifact2 == null) {
            ArtifactManagerImpl.a(3);
        }
        return artifact2;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactManagerImpl.a(4);
        }
        Artifact artifact2 = this.d.getOriginalArtifact(artifact);
        if (artifact2 == null) {
            ArtifactManagerImpl.a(5);
        }
        return artifact2;
    }

    @NotNull
    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType artifactType) {
        if (artifactType == null) {
            ArtifactManagerImpl.a(6);
        }
        Collection<? extends Artifact> collection = this.d.getArtifactsByType(artifactType);
        if (collection == null) {
            ArtifactManagerImpl.a(7);
        }
        return collection;
    }

    public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
        return this.d.getAllArtifactsIncludingInvalid();
    }

    public ArtifactManagerState getState() {
        ArtifactManagerState artifactManagerState = new ArtifactManagerState();
        for (Artifact artifact : this.getAllArtifactsIncludingInvalid()) {
            ArtifactState artifactState;
            if (artifact instanceof InvalidArtifact) {
                artifactState = ((InvalidArtifact)artifact).getState();
            } else {
                artifactState = new ArtifactState();
                artifactState.setBuildOnMake(artifact.isBuildOnMake());
                artifactState.setName(artifact.getName());
                artifactState.setOutputPath(artifact.getOutputPath());
                artifactState.setRootElement(ArtifactManagerImpl.a(artifact.getRootElement()));
                artifactState.setArtifactType(artifact.getArtifactType().getId());
                ProjectModelExternalSource projectModelExternalSource = artifact.getExternalSource();
                if (projectModelExternalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)this.e)) {
                    artifactState.setExternalSystemId(projectModelExternalSource.getId());
                }
                for (ArtifactPropertiesProvider artifactPropertiesProvider : artifact.getPropertiesProviders()) {
                    ArtifactPropertiesState artifactPropertiesState = ArtifactManagerImpl.a(artifactPropertiesProvider, artifact.getProperties(artifactPropertiesProvider));
                    if (artifactPropertiesState == null) continue;
                    artifactState.getPropertiesList().add(artifactPropertiesState);
                }
                Collections.sort(artifactState.getPropertiesList(), Comparator.comparing(ArtifactPropertiesState::getId));
            }
            artifactManagerState.getArtifacts().add(artifactState);
        }
        return artifactManagerState;
    }

    @Nullable
    private static <S> ArtifactPropertiesState a(ArtifactPropertiesProvider artifactPropertiesProvider, ArtifactProperties<S> artifactProperties) {
        Element element = XmlSerializer.serialize((Object)artifactProperties.getState());
        if (element == null) {
            return null;
        }
        element.setName("options");
        ArtifactPropertiesState artifactPropertiesState = new ArtifactPropertiesState();
        artifactPropertiesState.setId(artifactPropertiesProvider.getId());
        artifactPropertiesState.setOptions(element);
        return artifactPropertiesState;
    }

    private static Element a(PackagingElement<?> packagingElement) {
        Element element = new Element(PACKAGING_ELEMENT_NAME);
        element.setAttribute(TYPE_ID_ATTRIBUTE, packagingElement.getType().getId());
        Object object = packagingElement.getState();
        if (object != null) {
            XmlSerializer.serializeObjectInto((Object)object, (Element)element);
        }
        if (packagingElement instanceof CompositePackagingElement) {
            for (PackagingElement packagingElement2 : ((CompositePackagingElement)packagingElement).getChildren()) {
                element.addContent(ArtifactManagerImpl.a(packagingElement2));
            }
        }
        return element;
    }

    private <T> PackagingElement<T> a(Element element) throws UnknownPackagingElementTypeException {
        String string = element.getAttributeValue(TYPE_ID_ATTRIBUTE);
        PackagingElementType packagingElementType = PackagingElementFactory.getInstance().findElementType(string);
        if (packagingElementType == null) {
            throw new UnknownPackagingElementTypeException(string);
        }
        PackagingElement packagingElement = packagingElementType.createEmpty(this.e);
        Object object = packagingElement.getState();
        if (object != null) {
            XmlSerializer.deserializeInto((Element)element, (Object)object);
            packagingElement.loadState(object);
        }
        List list2 = element.getChildren(PACKAGING_ELEMENT_NAME);
        for (Element element2 : list2) {
            ((CompositePackagingElement)packagingElement).addOrFindChild(this.a(element2));
        }
        return packagingElement;
    }

    public void loadState(@NotNull ArtifactManagerState artifactManagerState) {
        if (artifactManagerState == null) {
            ArtifactManagerImpl.a(8);
        }
        List list2 = artifactManagerState.getArtifacts();
        ArrayList<ArtifactImpl> arrayList = new ArrayList<ArtifactImpl>(list2.size());
        if (!list2.isEmpty()) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (ArtifactState artifactState : list2) {
                    arrayList.add(this.a(artifactState));
                }
            });
        }
        if (this.b) {
            ArtifactModelImpl artifactModelImpl = new ArtifactModelImpl(this, arrayList);
            this.a(artifactModelImpl);
        } else {
            this.d.setArtifactsList(arrayList);
            this.b = true;
        }
    }

    private ArtifactImpl a(ArtifactState artifactState) {
        CompositePackagingElement compositePackagingElement;
        ArtifactType artifactType = ArtifactType.findById((String)artifactState.getArtifactType());
        ProjectModelExternalSource projectModelExternalSource = ArtifactManagerImpl.a(artifactState.getExternalSystemId());
        if (artifactType == null) {
            return this.a(artifactState, projectModelExternalSource, "Unknown artifact type: " + artifactState.getArtifactType());
        }
        Element element = artifactState.getRootElement();
        String string = artifactState.getName();
        if (element != null) {
            try {
                compositePackagingElement = (CompositePackagingElement)this.a(element);
            }
            catch (UnknownPackagingElementTypeException unknownPackagingElementTypeException) {
                return this.a(artifactState, projectModelExternalSource, "Unknown element: " + unknownPackagingElementTypeException.getTypeId());
            }
        } else {
            compositePackagingElement = artifactType.createRootElement(string);
        }
        ArtifactImpl artifactImpl = new ArtifactImpl(string, artifactType, artifactState.isBuildOnMake(), compositePackagingElement, artifactState.getOutputPath(), projectModelExternalSource);
        List list2 = artifactState.getPropertiesList();
        for (ArtifactPropertiesState artifactPropertiesState : list2) {
            ArtifactPropertiesProvider artifactPropertiesProvider = ArtifactPropertiesProvider.findById((String)artifactPropertiesState.getId());
            if (artifactPropertiesProvider != null) {
                ArtifactManagerImpl.a(artifactImpl.getProperties(artifactPropertiesProvider), artifactPropertiesState);
                continue;
            }
            return this.a(artifactState, projectModelExternalSource, "Unknown artifact properties: " + artifactPropertiesState.getId());
        }
        return artifactImpl;
    }

    private InvalidArtifact a(ArtifactState artifactState, ProjectModelExternalSource projectModelExternalSource, String string) {
        InvalidArtifact invalidArtifact = new InvalidArtifact(artifactState, string, projectModelExternalSource);
        ProjectLoadingErrorsNotifier.getInstance((Project)this.e).registerError((ConfigurationErrorDescription)new ArtifactLoadingErrorDescription(this.e, invalidArtifact));
        UnknownFeaturesCollector.getInstance((Project)this.e).registerUnknownFeature("com.intellij.packaging.artifacts.ArtifactType", artifactState.getArtifactType(), "Artifact");
        return invalidArtifact;
    }

    @Nullable
    private static ProjectModelExternalSource a(@Nullable String string) {
        return string != null ? ExternalProjectSystemRegistry.getInstance().getSourceById(string) : null;
    }

    private static <S> void a(ArtifactProperties<S> artifactProperties, ArtifactPropertiesState artifactPropertiesState) {
        Element element = artifactPropertiesState.getOptions();
        if (artifactProperties == null || element == null) {
            return;
        }
        Object object = artifactProperties.getState();
        if (object != null) {
            XmlSerializer.deserializeInto((Element)element, (Object)object);
            artifactProperties.loadState(object);
        }
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.h.values());
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            ArtifactManagerImpl.a(9);
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new ArtifactVirtualFileListener(this.e, this), (Disposable)this.e);
        this.a();
    }

    private void a() {
        Artifact artifact2;
        HashSet<String> hashSet = new HashSet<String>(this.h.keySet());
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Artifact artifact2 : this.getArtifacts()) {
            String string = artifact2.getOutputPath();
            if (string == null || string.length() <= 0) continue;
            hashSet.remove(string);
            if (this.h.containsKey(string)) continue;
            hashSet2.add(string);
        }
        ArrayList arrayList = new ArrayList();
        for (String iterator : hashSet) {
            artifact2 = this.h.remove(iterator);
            ContainerUtil.addIfNotNull(arrayList, (Object)artifact2);
        }
        Set set = LocalFileSystem.getInstance().replaceWatchedRoots(arrayList, hashSet2, null);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            artifact2 = (LocalFileSystem.WatchRequest)iterator.next();
            this.h.put(artifact2.getRootPath(), (LocalFileSystem.WatchRequest)artifact2);
        }
    }

    public Artifact[] getSortedArtifacts() {
        return this.d.getSortedArtifacts();
    }

    public ModifiableArtifactModel createModifiableModel() {
        return new ArtifactModelImpl(this, this.getArtifactsList());
    }

    public PackagingElementResolvingContext getResolvingContext() {
        return this.g;
    }

    public List<ArtifactImpl> getArtifactsList() {
        return this.d.c;
    }

    public void commit(ArtifactModelImpl artifactModelImpl) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.a(artifactModelImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ArtifactModelImpl artifactModelImpl) {
        boolean bl2;
        a.assertTrue(!this.f, (Object)"Recursive commit");
        this.f = true;
        try {
            List<ArtifactImpl> list2 = artifactModelImpl.getOriginalArtifacts();
            THashSet tHashSet = new THashSet((Collection)this.d.c);
            ArrayList<ArtifactImpl> arrayList = new ArrayList<ArtifactImpl>();
            ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
            for (ArtifactImpl artifactImpl : list2) {
                boolean bl3 = !tHashSet.remove((Object)artifactImpl);
                ArtifactImpl artifactImpl2 = artifactModelImpl.getModifiableCopy((Artifact)artifactImpl);
                if (bl3) {
                    arrayList.add(artifactImpl);
                    continue;
                }
                if (artifactImpl2 == null || ((Object)((Object)artifactImpl2)).equals((Object)artifactImpl)) continue;
                String string = artifactImpl.getName();
                artifactImpl.copyFrom(artifactImpl2);
                arrayList2.add(Pair.create((Object)((Object)artifactImpl), (Object)string));
            }
            this.d.setArtifactsList(list2);
            this.c.incModificationCount();
            ArtifactListener artifactListener = (ArtifactListener)this.e.getMessageBus().syncPublisher(TOPIC);
            bl2 = !tHashSet.isEmpty() || !arrayList.isEmpty() || !arrayList2.isEmpty();
            ProjectRootManagerEx.getInstanceEx((Project)this.e).mergeRootsChangesDuring(() -> ArtifactManagerImpl.a((Set)tHashSet, artifactListener, arrayList, arrayList2));
        }
        finally {
            this.f = false;
        }
        this.a();
        if (bl2) {
            BuildManager.getInstance().clearState(this.e);
        }
    }

    public Project getProject() {
        return this.e;
    }

    @NotNull
    public Artifact addArtifact(final @NotNull String string, final @NotNull ArtifactType artifactType, final CompositePackagingElement<?> compositePackagingElement) {
        if (string == null) {
            ArtifactManagerImpl.a(10);
        }
        if (artifactType == null) {
            ArtifactManagerImpl.a(11);
        }
        Artifact artifact = (Artifact)new WriteAction<Artifact>(){

            protected void run(@NotNull Result<Artifact> result2) {
                if (result2 == null) {
                    1.a(0);
                }
                ModifiableArtifactModel modifiableArtifactModel = ArtifactManagerImpl.this.createModifiableModel();
                ModifiableArtifact modifiableArtifact = modifiableArtifactModel.addArtifact(string, artifactType);
                if (compositePackagingElement != null) {
                    modifiableArtifact.setRootElement(compositePackagingElement);
                }
                modifiableArtifactModel.commit();
                result2.setResult((Object)modifiableArtifact);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/artifacts/ArtifactManagerImpl$1", "run"));
            }
        }.execute().getResultObject();
        if (artifact == null) {
            ArtifactManagerImpl.a(12);
        }
        return artifact;
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String string, @NotNull PackagingElement<?> packagingElement) {
        if (artifact == null) {
            ArtifactManagerImpl.a(13);
        }
        if (string == null) {
            ArtifactManagerImpl.a(14);
        }
        if (packagingElement == null) {
            ArtifactManagerImpl.a(15);
        }
        this.addElementsToDirectory(artifact, string, Collections.singletonList(packagingElement));
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String string, @NotNull Collection<? extends PackagingElement<?>> collection) {
        if (artifact == null) {
            ArtifactManagerImpl.a(16);
        }
        if (string == null) {
            ArtifactManagerImpl.a(17);
        }
        if (collection == null) {
            ArtifactManagerImpl.a(18);
        }
        final ModifiableArtifactModel modifiableArtifactModel = this.createModifiableModel();
        CompositePackagingElement compositePackagingElement = modifiableArtifactModel.getOrCreateModifiableArtifact(artifact).getRootElement();
        PackagingElementFactory.getInstance().getOrCreateDirectory(compositePackagingElement, string).addOrFindChildren(collection);
        new WriteAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    2.a(0);
                }
                modifiableArtifactModel.commit();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/artifacts/ArtifactManagerImpl$2", "run"));
            }
        }.execute();
    }

    public ModificationTracker getModificationTracker() {
        return this.c;
    }

    private static /* synthetic */ void a(Set set, ArtifactListener artifactListener, List list2, List list3) {
        for (ArtifactImpl artifactImpl : set) {
            artifactListener.artifactRemoved((Artifact)artifactImpl);
        }
        for (ArtifactImpl artifactImpl : list2) {
            artifactListener.artifactAdded((Artifact)artifactImpl);
        }
        for (ArtifactImpl artifactImpl : list3) {
            artifactListener.artifactChanged((Artifact)artifactImpl.getFirst(), (String)artifactImpl.getSecond());
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactManagerImpl";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerState";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = PACKAGING_ELEMENT_NAME;
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactByOriginal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalArtifact";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsByType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifact";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactByOriginal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalArtifact";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactsByType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addElementsToDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArtifactManagerModel
    extends ArtifactModelBase {
        private List<ArtifactImpl> c = new ArrayList<ArtifactImpl>();
        private Artifact[] d;

        private ArtifactManagerModel() {
        }

        public void setArtifactsList(List<ArtifactImpl> list2) {
            this.c = list2;
            this.artifactsChanged();
        }

        @Override
        protected void artifactsChanged() {
            super.artifactsChanged();
            this.d = null;
        }

        @Override
        protected List<? extends Artifact> getArtifactsList() {
            return this.c;
        }

        public Artifact[] getSortedArtifacts() {
            if (this.d == null) {
                this.d = (Artifact[])this.getArtifacts().clone();
                Arrays.sort(this.d, ArtifactManager.ARTIFACT_COMPARATOR);
            }
            return this.d;
        }
    }
}

