/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarArtifactFromModulesDialog
extends DialogWrapper {
    private JPanel c;
    private TextFieldWithBrowseButton j;
    private JComboBox h;
    private JLabel a;
    private TextFieldWithBrowseButton b;
    private JLabel g;
    private JRadioButton e;
    private JRadioButton f;
    private JCheckBox d;
    private final PackagingElementResolvingContext i;

    public JarArtifactFromModulesDialog(PackagingElementResolvingContext packagingElementResolvingContext) {
        super(packagingElementResolvingContext.getProject());
        this.i = packagingElementResolvingContext;
        this.b();
        this.setTitle("Create JAR from Modules");
        this.a.setLabelFor(this.j.getTextField());
        this.g.setLabelFor(this.b.getTextField());
        Project project2 = this.i.getProject();
        ManifestFileUtil.setupMainClassField(project2, this.j);
        this.j.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                JarArtifactFromModulesDialog.this.a();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JarArtifactFromModulesDialog.this.a();
            }
        };
        this.e.addActionListener(actionListener);
        this.f.addActionListener(actionListener);
        this.a();
        this.b.addBrowseFolderListener(null, null, project2, ManifestFileUtil.createDescriptorForManifestDirectory());
        this.a(packagingElementResolvingContext);
        this.init();
    }

    private void a(PackagingElementResolvingContext packagingElementResolvingContext) {
        Module[] moduleArray = (Module[])packagingElementResolvingContext.getModulesProvider().getModules().clone();
        Arrays.sort(moduleArray, ModulesAlphaComparator.INSTANCE);
        if (moduleArray.length > 1) {
            this.h.addItem(null);
        }
        for (Module module2 : moduleArray) {
            this.h.addItem(module2);
        }
        this.h.setRenderer(new ModuleListRenderer(this.h));
        new ComboboxSpeedSearch(this.h){

            protected String getElementText(Object object) {
                return object instanceof Module ? ((Module)object).getName() : "";
            }
        };
    }

    private void a() {
        VirtualFile virtualFile;
        boolean bl2 = !this.j.getText().isEmpty() || !this.e.isSelected();
        this.a(bl2);
        if (bl2 && this.b.getText().isEmpty() && (virtualFile = ManifestFileUtil.suggestManifestFileDirectory(this.i.getProject(), this.c())) != null) {
            this.b.setText(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        }
    }

    @Nullable
    private Module c() {
        return (Module)this.h.getSelectedItem();
    }

    @NotNull
    public Module[] getSelectedModules() {
        Module module2 = this.c();
        if (module2 != null) {
            Module[] moduleArray = new Module[]{module2};
            if (moduleArray == null) {
                JarArtifactFromModulesDialog.a(0);
            }
            return moduleArray;
        }
        Module[] moduleArray = this.i.getModulesProvider().getModules();
        if (moduleArray == null) {
            JarArtifactFromModulesDialog.a(1);
        }
        return moduleArray;
    }

    @NotNull
    public String getDirectoryForManifest() {
        String string = FileUtil.toSystemIndependentName((String)this.b.getText());
        if (string == null) {
            JarArtifactFromModulesDialog.a(2);
        }
        return string;
    }

    public boolean isExtractLibrariesToJar() {
        return this.e.isSelected();
    }

    public boolean isIncludeTests() {
        return this.d.isSelected();
    }

    public String getMainClassName() {
        return this.j.getText();
    }

    private void a(boolean bl2) {
        this.g.setEnabled(bl2);
        this.b.setEnabled(bl2);
    }

    protected JComponent createCenterPanel() {
        return this.c;
    }

    protected String getHelpId() {
        return "reference.project.structure.artifacts.jar.from.module";
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/packaging/impl/artifacts/JarArtifactFromModulesDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryForManifest";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void b() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel2;
        JPanel jPanel;
        this.c = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.a = jLabel2 = new JLabel();
        jLabel2.setText("Main Class:");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.j = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Module:");
        jLabel3.setDisplayedMnemonic('M');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.h = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(400, -1), null));
        this.g = jLabel = new JLabel();
        jLabel.setText("Directory for META-INF/MANIFEST.MF:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.b = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 2, 0, 1, 6, 0, null, null, null, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"JAR files from libraries", (int)0, (int)0, null, null));
        this.e = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("extract to the target JAR");
        jRadioButton2.setMnemonic('E');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.f = jRadioButton = new JRadioButton();
        jRadioButton.setText("copy to the output directory and link via manifest");
        jRadioButton.setMnemonic('T');
        jRadioButton.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.d = jCheckBox = new JCheckBox();
        jCheckBox.setText("Include tests");
        jCheckBox.setMnemonic('I');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.c;
    }

    private static class ModuleListRenderer
    extends ListCellRendererWrapper<Module> {
        public ModuleListRenderer(JComboBox jComboBox) {
        }

        public void customize(JList jList, Module module2, int n2, boolean bl2, boolean bl3) {
            if (module2 != null) {
                this.setIcon(ModuleType.get((Module)module2).getIcon());
                this.setText(module2.getName());
            } else {
                this.setText("<All Modules>");
                this.setIcon(null);
            }
        }
    }
}

