/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;

public class ArtifactCompilerUtil {
    private ArtifactCompilerUtil() {
    }

    public static boolean containsArtifacts(List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list2) {
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope targetTypeBuildScope : list2) {
            if (!ArtifactBuildTargetType.INSTANCE.getTypeId().equals(targetTypeBuildScope.getTypeId())) continue;
            return true;
        }
        return false;
    }

    public static MultiMap<String, Artifact> createOutputToArtifactMap(Project project2) {
        MultiMap multiMap = MultiMap.create((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        ReadAction.run(() -> {
            for (Artifact artifact : ArtifactManager.getInstance((Project)project2).getArtifacts()) {
                String string = artifact.getOutputFilePath();
                if (StringUtil.isEmpty((String)string)) continue;
                multiMap.putValue((Object)string, (Object)artifact);
            }
        });
        return multiMap;
    }
}

