/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.RenameablePackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.FileCopyPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileCopyPackagingElement
extends FileOrDirectoryCopyPackagingElement<FileCopyPackagingElement>
implements RenameablePackagingElement {
    @NonNls
    public static final String OUTPUT_FILE_NAME_ATTRIBUTE = "output-file-name";
    private String a;

    public FileCopyPackagingElement() {
        super(PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE);
    }

    public FileCopyPackagingElement(String string) {
        this();
        this.myFilePath = string;
    }

    public FileCopyPackagingElement(String string, String string2) {
        this(string);
        this.a = string2;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext artifactEditorContext) {
        if (artifactEditorContext == null) {
            FileCopyPackagingElement.b(0);
        }
        return new FileCopyPresentation(this.myFilePath, this.getOutputFileName());
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext packagingElementResolvingContext, @NotNull AntCopyInstructionCreator antCopyInstructionCreator, @NotNull ArtifactAntGenerationContext artifactAntGenerationContext, @NotNull ArtifactType artifactType) {
        if (packagingElementResolvingContext == null) {
            FileCopyPackagingElement.b(1);
        }
        if (antCopyInstructionCreator == null) {
            FileCopyPackagingElement.b(2);
        }
        if (artifactAntGenerationContext == null) {
            FileCopyPackagingElement.b(3);
        }
        if (artifactType == null) {
            FileCopyPackagingElement.b(4);
        }
        if (this.isDirectory()) {
            return Collections.emptyList();
        }
        String string = artifactAntGenerationContext.getSubstitutedPath(this.myFilePath);
        return Collections.singletonList(antCopyInstructionCreator.createFileCopyInstruction(string, this.getOutputFileName()));
    }

    public String getOutputFileName() {
        return this.a != null ? this.a : PathUtil.getFileName((String)this.myFilePath);
    }

    @NonNls
    public String toString() {
        return "file:" + this.myFilePath + (this.a != null ? ",rename to:" + this.a : "");
    }

    public boolean isDirectory() {
        return new File(FileUtil.toSystemDependentName((String)this.myFilePath)).isDirectory();
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> packagingElement) {
        if (packagingElement == null) {
            FileCopyPackagingElement.b(5);
        }
        return packagingElement instanceof FileCopyPackagingElement && super.isEqualTo(packagingElement) && Comparing.equal((String)this.a, (String)((FileCopyPackagingElement)packagingElement).getRenamedOutputFileName());
    }

    public FileCopyPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull FileCopyPackagingElement fileCopyPackagingElement) {
        if (fileCopyPackagingElement == null) {
            FileCopyPackagingElement.b(6);
        }
        this.setFilePath(fileCopyPackagingElement.getFilePath());
        this.setRenamedOutputFileName(fileCopyPackagingElement.getRenamedOutputFileName());
    }

    @Attribute(value="output-file-name")
    @Nullable
    public String getRenamedOutputFileName() {
        return this.a;
    }

    public void setRenamedOutputFileName(String string) {
        this.a = string;
    }

    public String getName() {
        return this.getOutputFileName();
    }

    public boolean canBeRenamed() {
        return !this.isDirectory();
    }

    public void rename(@NotNull String string) {
        if (string == null) {
            FileCopyPackagingElement.b(7);
        }
        this.a = string.equals(PathUtil.getFileName((String)this.myFilePath)) ? null : string;
    }

    @Nullable
    public VirtualFile getLibraryRoot() {
        String string = VfsUtil.getUrlForLibraryRoot((File)new File(FileUtil.toSystemDependentName((String)this.getFilePath())));
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/FileCopyPackagingElement";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAntInstructions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

