/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ArchiveElementType;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.DirectoryCopyElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryElementType;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyElementType;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.packaging.impl.elements.TestModuleOutputPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementFactoryImpl
extends PackagingElementFactory {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.packaging.impl.elements.PackagingElementFactoryImpl");
    public static final PackagingElementType<DirectoryPackagingElement> DIRECTORY_ELEMENT_TYPE = new DirectoryElementType();
    public static final PackagingElementType<ArchivePackagingElement> ARCHIVE_ELEMENT_TYPE = new ArchiveElementType();
    public static final PackagingElementType<FileCopyPackagingElement> FILE_COPY_ELEMENT_TYPE = new FileCopyElementType();
    public static final PackagingElementType<DirectoryCopyPackagingElement> DIRECTORY_COPY_ELEMENT_TYPE = new DirectoryCopyElementType();
    public static final PackagingElementType<ExtractedDirectoryPackagingElement> EXTRACTED_DIRECTORY_ELEMENT_TYPE = new ExtractedDirectoryElementType();
    public static final PackagingElementType<ArtifactRootElement<?>> ARTIFACT_ROOT_ELEMENT_TYPE = new ArtifactRootElementType();
    private static final PackagingElementType[] a = new PackagingElementType[]{DIRECTORY_ELEMENT_TYPE, ARCHIVE_ELEMENT_TYPE, LibraryElementType.LIBRARY_ELEMENT_TYPE, ProductionModuleOutputElementType.ELEMENT_TYPE, TestModuleOutputElementType.ELEMENT_TYPE, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, FILE_COPY_ELEMENT_TYPE, DIRECTORY_COPY_ELEMENT_TYPE, EXTRACTED_DIRECTORY_ELEMENT_TYPE};

    @NotNull
    public PackagingElementType<?>[] getNonCompositeElementTypes() {
        ArrayList<PackagingElementType> arrayList = new ArrayList<PackagingElementType>();
        for (PackagingElementType packagingElementType : this.getAllElementTypes()) {
            if (packagingElementType instanceof CompositePackagingElementType) continue;
            arrayList.add(packagingElementType);
        }
        PackagingElementType[] packagingElementTypeArray = arrayList.toArray(new PackagingElementType[0]);
        if (packagingElementTypeArray == null) {
            PackagingElementFactoryImpl.a(0);
        }
        return packagingElementTypeArray;
    }

    @NotNull
    public ComplexPackagingElementType<?>[] getComplexElementTypes() {
        ArrayList<ComplexPackagingElementType> arrayList = new ArrayList<ComplexPackagingElementType>();
        for (PackagingElementType packagingElementType : this.getAllElementTypes()) {
            if (!(packagingElementType instanceof ComplexPackagingElementType)) continue;
            arrayList.add((ComplexPackagingElementType)packagingElementType);
        }
        ComplexPackagingElementType[] complexPackagingElementTypeArray = arrayList.toArray(new ComplexPackagingElementType[0]);
        if (complexPackagingElementTypeArray == null) {
            PackagingElementFactoryImpl.a(1);
        }
        return complexPackagingElementTypeArray;
    }

    @NotNull
    public CompositePackagingElementType<?>[] getCompositeElementTypes() {
        ArrayList<CompositePackagingElementType> arrayList = new ArrayList<CompositePackagingElementType>();
        for (PackagingElementType packagingElementType : this.getAllElementTypes()) {
            if (!(packagingElementType instanceof CompositePackagingElementType)) continue;
            arrayList.add((CompositePackagingElementType)packagingElementType);
        }
        CompositePackagingElementType[] compositePackagingElementTypeArray = arrayList.toArray(new CompositePackagingElementType[0]);
        if (compositePackagingElementTypeArray == null) {
            PackagingElementFactoryImpl.a(2);
        }
        return compositePackagingElementTypeArray;
    }

    public PackagingElementType<?> findElementType(String string) {
        for (PackagingElementType packagingElementType : this.getAllElementTypes()) {
            if (!packagingElementType.getId().equals(string)) continue;
            return packagingElementType;
        }
        if (string.equals(ARTIFACT_ROOT_ELEMENT_TYPE.getId())) {
            return ARTIFACT_ROOT_ELEMENT_TYPE;
        }
        return null;
    }

    @NotNull
    public PackagingElementType[] getAllElementTypes() {
        Object[] objectArray = (PackagingElementType[])Extensions.getExtensions((ExtensionPointName)PackagingElementType.EP_NAME);
        PackagingElementType[] packagingElementTypeArray = (PackagingElementType[])ArrayUtil.mergeArrays((Object[])a, (Object[])objectArray);
        if (packagingElementTypeArray == null) {
            PackagingElementFactoryImpl.a(3);
        }
        return packagingElementTypeArray;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull Artifact artifact, @NotNull Project project2) {
        if (artifact == null) {
            PackagingElementFactoryImpl.a(4);
        }
        if (project2 == null) {
            PackagingElementFactoryImpl.a(5);
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project2, ArtifactPointerManager.getInstance((Project)project2).createPointer(artifact));
        if (artifactPackagingElement == null) {
            PackagingElementFactoryImpl.a(6);
        }
        return artifactPackagingElement;
    }

    @NotNull
    public DirectoryPackagingElement createDirectory(@NotNull @NonNls String string) {
        if (string == null) {
            PackagingElementFactoryImpl.a(7);
        }
        DirectoryPackagingElement directoryPackagingElement = new DirectoryPackagingElement(string);
        if (directoryPackagingElement == null) {
            PackagingElementFactoryImpl.a(8);
        }
        return directoryPackagingElement;
    }

    @NotNull
    public ArtifactRootElement<?> createArtifactRootElement() {
        ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
        if (artifactRootElementImpl == null) {
            PackagingElementFactoryImpl.a(9);
        }
        return artifactRootElementImpl;
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateDirectory(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull String string) {
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.a(10);
        }
        if (string == null) {
            PackagingElementFactoryImpl.a(11);
        }
        CompositePackagingElement<?> compositePackagingElement2 = this.a(compositePackagingElement, string, true);
        if (compositePackagingElement2 == null) {
            PackagingElementFactoryImpl.a(12);
        }
        return compositePackagingElement2;
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateArchive(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull String string) {
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.a(13);
        }
        if (string == null) {
            PackagingElementFactoryImpl.a(14);
        }
        CompositePackagingElement<?> compositePackagingElement2 = this.a(compositePackagingElement, string, false);
        if (compositePackagingElement2 == null) {
            PackagingElementFactoryImpl.a(15);
        }
        return compositePackagingElement2;
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull String string, @NotNull String string2) {
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.a(16);
        }
        if (string == null) {
            PackagingElementFactoryImpl.a(17);
        }
        if (string2 == null) {
            PackagingElementFactoryImpl.a(18);
        }
        this.addFileCopy(compositePackagingElement, string, string2, null);
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull String string, @NotNull String string2, @Nullable String string3) {
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.a(19);
        }
        if (string == null) {
            PackagingElementFactoryImpl.a(20);
        }
        if (string2 == null) {
            PackagingElementFactoryImpl.a(21);
        }
        String string4 = PathUtil.getFileName((String)string2);
        if (string3 != null && string3.equals(string4)) {
            string3 = null;
        }
        this.getOrCreateDirectory(compositePackagingElement, string).addOrFindChild(this.createFileCopy(string2, string3));
    }

    @NotNull
    private CompositePackagingElement<?> a(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull @NonNls String string, boolean bl2) {
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.a(22);
        }
        if (string == null) {
            PackagingElementFactoryImpl.a(23);
        }
        if ((string = StringUtil.trimStart((String)StringUtil.trimEnd((String)string, (String)"/"), (String)"/")).length() == 0) {
            CompositePackagingElement<?> compositePackagingElement2 = compositePackagingElement;
            if (compositePackagingElement2 == null) {
                PackagingElementFactoryImpl.a(24);
            }
            return compositePackagingElement2;
        }
        int n2 = string.lastIndexOf(47);
        String string2 = string.substring(n2 + 1);
        String string3 = n2 != -1 ? string.substring(0, n2) : "";
        CompositePackagingElement<?> compositePackagingElement3 = this.a(compositePackagingElement, string3, true);
        CompositePackagingElement<?> compositePackagingElement4 = bl2 ? this.createDirectory(string2) : this.createArchive(string2);
        CompositePackagingElement compositePackagingElement5 = (CompositePackagingElement)compositePackagingElement3.addOrFindChild(compositePackagingElement4);
        if (compositePackagingElement5 == null) {
            PackagingElementFactoryImpl.a(25);
        }
        return compositePackagingElement5;
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull String string, @NotNull Project project2) {
        if (string == null) {
            PackagingElementFactoryImpl.a(26);
        }
        if (project2 == null) {
            PackagingElementFactoryImpl.a(27);
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)project2).create(string);
        ProductionModuleOutputPackagingElement productionModuleOutputPackagingElement = new ProductionModuleOutputPackagingElement(project2, modulePointer);
        if (productionModuleOutputPackagingElement == null) {
            PackagingElementFactoryImpl.a(28);
        }
        return productionModuleOutputPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull Module module2) {
        if (module2 == null) {
            PackagingElementFactoryImpl.a(29);
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        ProductionModuleOutputPackagingElement productionModuleOutputPackagingElement = new ProductionModuleOutputPackagingElement(module2.getProject(), modulePointer);
        if (productionModuleOutputPackagingElement == null) {
            PackagingElementFactoryImpl.a(30);
        }
        return productionModuleOutputPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createTestModuleOutput(@NotNull Module module2) {
        if (module2 == null) {
            PackagingElementFactoryImpl.a(31);
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        TestModuleOutputPackagingElement testModuleOutputPackagingElement = new TestModuleOutputPackagingElement(module2.getProject(), modulePointer);
        if (testModuleOutputPackagingElement == null) {
            PackagingElementFactoryImpl.a(32);
        }
        return testModuleOutputPackagingElement;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createLibraryElements(@NotNull Library library) {
        Object object;
        if (library == null) {
            PackagingElementFactoryImpl.a(33);
        }
        LibraryTable libraryTable = library.getTable();
        String string = library.getName();
        if (libraryTable != null) {
            List<PackagingElement<?>> list2 = Collections.singletonList(this.createLibraryFiles(string, libraryTable.getTableLevel(), null));
            if (list2 == null) {
                PackagingElementFactoryImpl.a(34);
            }
            return list2;
        }
        if (string != null && (object = ((LibraryImpl)library).getModule()) != null) {
            List<PackagingElement<?>> list3 = Collections.singletonList(this.createLibraryFiles(string, "module", object.getName()));
            if (list3 == null) {
                PackagingElementFactoryImpl.a(35);
            }
            return list3;
        }
        object = new ArrayList();
        for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
            String string2 = FileUtil.toSystemIndependentName((String)PathUtil.getLocalPath((VirtualFile)virtualFile));
            object.add(virtualFile.isDirectory() && virtualFile.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(string2) : new FileCopyPackagingElement(string2));
        }
        Object object2 = object;
        if (object2 == null) {
            PackagingElementFactoryImpl.a(36);
        }
        return object2;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull ArtifactPointer artifactPointer, @NotNull Project project2) {
        if (artifactPointer == null) {
            PackagingElementFactoryImpl.a(37);
        }
        if (project2 == null) {
            PackagingElementFactoryImpl.a(38);
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project2, artifactPointer);
        if (artifactPackagingElement == null) {
            PackagingElementFactoryImpl.a(39);
        }
        return artifactPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createLibraryFiles(@NotNull String string, @NotNull String string2, String string3) {
        if (string == null) {
            PackagingElementFactoryImpl.a(40);
        }
        if (string2 == null) {
            PackagingElementFactoryImpl.a(41);
        }
        LibraryPackagingElement libraryPackagingElement = new LibraryPackagingElement(string2, string, string3);
        if (libraryPackagingElement == null) {
            PackagingElementFactoryImpl.a(42);
        }
        return libraryPackagingElement;
    }

    @NotNull
    public CompositePackagingElement<?> createArchive(@NotNull @NonNls String string) {
        if (string == null) {
            PackagingElementFactoryImpl.a(43);
        }
        ArchivePackagingElement archivePackagingElement = new ArchivePackagingElement(string);
        if (archivePackagingElement == null) {
            PackagingElementFactoryImpl.a(44);
        }
        return archivePackagingElement;
    }

    @Nullable
    private static PackagingElement<?> a(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull String string) {
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.a(45);
        }
        if (string == null) {
            PackagingElementFactoryImpl.a(46);
        }
        for (PackagingElement packagingElement : compositePackagingElement.getChildren()) {
            if ((!(packagingElement instanceof ArchivePackagingElement) || !((ArchivePackagingElement)packagingElement).getArchiveFileName().equals(string)) && (!(packagingElement instanceof DirectoryPackagingElement) || !((DirectoryPackagingElement)packagingElement).getDirectoryName().equals(string))) continue;
            return packagingElement;
        }
        return null;
    }

    @NotNull
    public static String suggestFileName(@NotNull CompositePackagingElement<?> compositePackagingElement, @NonNls @NotNull String string, @NonNls @NotNull String string2) {
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.a(47);
        }
        if (string == null) {
            PackagingElementFactoryImpl.a(48);
        }
        if (string2 == null) {
            PackagingElementFactoryImpl.a(49);
        }
        String string3 = string + string2;
        int n2 = 2;
        while (PackagingElementFactoryImpl.a(compositePackagingElement, string3) != null) {
            string3 = string + n2++ + string2;
        }
        String string4 = string3;
        if (string4 == null) {
            PackagingElementFactoryImpl.a(50);
        }
        return string4;
    }

    @NotNull
    public PackagingElement<?> createDirectoryCopyWithParentDirectories(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            PackagingElementFactoryImpl.a(51);
        }
        if (string2 == null) {
            PackagingElementFactoryImpl.a(52);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(string2, new DirectoryCopyPackagingElement(string));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.a(53);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createExtractedDirectoryWithParentDirectories(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        if (string == null) {
            PackagingElementFactoryImpl.a(54);
        }
        if (string2 == null) {
            PackagingElementFactoryImpl.a(55);
        }
        if (string3 == null) {
            PackagingElementFactoryImpl.a(56);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(string3, new ExtractedDirectoryPackagingElement(string, string2));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.a(57);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createExtractedDirectory(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PackagingElementFactoryImpl.a(58);
        }
        b.assertTrue(virtualFile.getFileSystem() instanceof JarFileSystem, (Object)("Expected file from JAR but file from " + virtualFile.getFileSystem() + " found"));
        String string = virtualFile.getPath();
        int n2 = string.indexOf("!/");
        ExtractedDirectoryPackagingElement extractedDirectoryPackagingElement = new ExtractedDirectoryPackagingElement(string.substring(0, n2), string.substring(n2 + 1));
        if (extractedDirectoryPackagingElement == null) {
            PackagingElementFactoryImpl.a(59);
        }
        return extractedDirectoryPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            PackagingElementFactoryImpl.a(60);
        }
        if (string2 == null) {
            PackagingElementFactoryImpl.a(61);
        }
        PackagingElement<?> packagingElement = this.createFileCopyWithParentDirectories(string, string2, null);
        if (packagingElement == null) {
            PackagingElementFactoryImpl.a(62);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String string, @NotNull String string2, @Nullable String string3) {
        if (string == null) {
            PackagingElementFactoryImpl.a(63);
        }
        if (string2 == null) {
            PackagingElementFactoryImpl.a(64);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(string2, this.createFileCopy(string, string3));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.a(65);
        }
        return packagingElement;
    }

    public PackagingElement<?> createFileCopy(@NotNull String string, String string2) {
        if (string == null) {
            PackagingElementFactoryImpl.a(66);
        }
        return new FileCopyPackagingElement(string, string2);
    }

    @NotNull
    public PackagingElement<?> createParentDirectories(@NotNull String string, @NotNull PackagingElement<?> packagingElement) {
        if (string == null) {
            PackagingElementFactoryImpl.a(67);
        }
        if (packagingElement == null) {
            PackagingElementFactoryImpl.a(68);
        }
        PackagingElement<?> packagingElement2 = this.createParentDirectories(string, Collections.singletonList(packagingElement)).get(0);
        if (packagingElement2 == null) {
            PackagingElementFactoryImpl.a(69);
        }
        return packagingElement2;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createParentDirectories(@NotNull String string, @NotNull List<? extends PackagingElement<?>> list2) {
        if (string == null) {
            PackagingElementFactoryImpl.a(70);
        }
        if (list2 == null) {
            PackagingElementFactoryImpl.a(71);
        }
        if ((string = StringUtil.trimStart((String)string, (String)"/")).length() == 0) {
            List<? extends PackagingElement<?>> list3 = list2;
            if (list3 == null) {
                PackagingElementFactoryImpl.a(72);
            }
            return list3;
        }
        int n2 = string.indexOf(47);
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2);
        DirectoryPackagingElement directoryPackagingElement = this.createDirectory(string2);
        CompositePackagingElement<?> compositePackagingElement = this.getOrCreateDirectory(directoryPackagingElement, string3);
        compositePackagingElement.addOrFindChildren(list2);
        List<DirectoryPackagingElement> list4 = Collections.singletonList(directoryPackagingElement);
        if (list4 == null) {
            PackagingElementFactoryImpl.a(73);
        }
        return list4;
    }

    public static CompositePackagingElement<?> createDirectoryOrArchiveWithParents(@NotNull String string, boolean bl2) {
        if (string == null) {
            PackagingElementFactoryImpl.a(74);
        }
        string = FileUtil.toSystemIndependentName((String)string);
        String string2 = PathUtil.getParentPath((String)string);
        String string3 = PathUtil.getFileName((String)string);
        CompositeElementWithManifest compositeElementWithManifest = bl2 ? new ArchivePackagingElement(string3) : new DirectoryPackagingElement(string3);
        return (CompositePackagingElement)PackagingElementFactoryImpl.getInstance().createParentDirectories(string2, (PackagingElement)compositeElementWithManifest);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 74: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 74: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 10: 
            case 13: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectoryPath";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePath";
                break;
            }
            case 23: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPointer";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFileName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 51: 
            case 60: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 52: 
            case 56: 
            case 61: 
            case 64: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeOutputPath";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarEntry";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonCompositeElementTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComplexElementTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeElementTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElementTypes";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl";
                break;
            }
            case 6: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactRootElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateArchive";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDirectoryOrArchive";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleOutput";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestModuleOutput";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryElements";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryFiles";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createArchive";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryCopyWithParentDirectories";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractedDirectoryWithParentDirectories";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractedDirectory";
                break;
            }
            case 62: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileCopyWithParentDirectories";
                break;
            }
            case 69: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentDirectories";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDirectory";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateArchive";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addFileCopy";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDirectoryOrArchive";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createModuleOutput";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTestModuleOutput";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryElements";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryFiles";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createArchive";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findArchiveOrDirectoryByName";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryCopyWithParentDirectories";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createExtractedDirectoryWithParentDirectories";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createExtractedDirectory";
                break;
            }
            case 60: 
            case 61: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createFileCopyWithParentDirectories";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createFileCopy";
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirectories";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryOrArchiveWithParents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 74: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArtifactRootElementType
    extends PackagingElementType<ArtifactRootElement<?>> {
        protected ArtifactRootElementType() {
            super("root", "");
        }

        public boolean canCreate(@NotNull ArtifactEditorContext artifactEditorContext, @NotNull Artifact artifact) {
            if (artifactEditorContext == null) {
                ArtifactRootElementType.a(0);
            }
            if (artifact == null) {
                ArtifactRootElementType.a(1);
            }
            return false;
        }

        @NotNull
        public List<? extends ArtifactRootElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext artifactEditorContext, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> compositePackagingElement) {
            if (artifactEditorContext == null) {
                ArtifactRootElementType.a(2);
            }
            if (artifact == null) {
                ArtifactRootElementType.a(3);
            }
            if (compositePackagingElement == null) {
                ArtifactRootElementType.a(4);
            }
            throw new UnsupportedOperationException("'create' not implemented in " + ((Object)((Object)this)).getClass().getName());
        }

        @NotNull
        public ArtifactRootElement<?> createEmpty(@NotNull Project project2) {
            if (project2 == null) {
                ArtifactRootElementType.a(5);
            }
            ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
            if (artifactRootElementImpl == null) {
                ArtifactRootElementType.a(6);
            }
            return artifactRootElementImpl;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEmpty";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canCreate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseAndCreate";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createEmpty";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

