/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryElementPresentation
extends PackagingElementPresentation {
    private final String b;
    private final String c;
    private final Library e;
    private final String d;
    private final ArtifactEditorContext a;

    public LibraryElementPresentation(String string, String string2, @Nullable String string3, Library library, ArtifactEditorContext artifactEditorContext) {
        this.b = string2;
        this.c = string3;
        this.e = library;
        this.d = string;
        this.a = artifactEditorContext;
    }

    public String getPresentableName() {
        return this.d;
    }

    public boolean canNavigateToSource() {
        return this.e != null;
    }

    public void navigateToSource() {
        this.a.selectLibrary(this.e);
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes simpleTextAttributes, SimpleTextAttributes simpleTextAttributes2) {
        if (presentationData == null) {
            LibraryElementPresentation.a(0);
        }
        if (this.e != null) {
            presentationData.setIcon(PlatformIcons.LIBRARY_ICON);
            presentationData.addText(this.d, simpleTextAttributes);
            presentationData.addText(LibraryElementPresentation.getLibraryTableComment(this.e), simpleTextAttributes2);
        } else {
            presentationData.addText(this.d + " (" + (this.c != null ? "module '" + this.c + "'" : this.b) + ")", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public int getWeight() {
        return 30;
    }

    public static String getLibraryTableDisplayName(Library library) {
        LibraryTable libraryTable = library.getTable();
        LibraryTablePresentation libraryTablePresentation = libraryTable != null ? libraryTable.getPresentation() : ModuleLibraryTable.MODULE_LIBRARY_TABLE_PRESENTATION;
        return libraryTablePresentation.getDisplayName(false);
    }

    public static String getLibraryTableComment(Library library) {
        String string;
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            string = libraryTable.getPresentation().getDisplayName(false);
        } else {
            Module module2 = ((LibraryImpl)library).getModule();
            String string2 = LibraryElementPresentation.getLibraryTableDisplayName(library);
            string = module2 != null ? "'" + module2.getName() + "' " + string2 : string2;
        }
        return " (" + string + ")";
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/packaging/impl/ui/LibraryElementPresentation", "render"));
    }
}

