/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.ChannelFactory;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.impl.SshConnectionKt;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0003J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001d\u001a\u00020\u0017J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J-\u0010!\u001a\u0002H\"\"\b\b\u0000\u0010\"*\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0%H\u0007\u00a2\u0006\u0002\u0010&R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006("}, d2={"Lcom/intellij/ssh/impl/SshConnection;", "", "userName", "", "host", "port", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "allSessions", "Ljava/util/ArrayList;", "Lcom/intellij/ssh/SshSession;", "disposeLock", "Ljava/util/concurrent/locks/ReentrantLock;", "disposed", "", "getHost", "()Ljava/lang/String;", "getPort", "()I", "serveLock", "sessions", "getUserName", "assertNotDisposed", "", "connect", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "createSession", "createSshSession", "dispose", "getSession", "Lcom/jcraft/jsch/Session;", "getSshSession", "openChannel", "R", "Lcom/intellij/ssh/channels/SshChannel;", "channelCreator", "Lcom/intellij/ssh/ChannelFactory;", "(Lcom/intellij/ssh/SessionConfig;Lcom/intellij/ssh/ChannelFactory;)Lcom/intellij/ssh/channels/SshChannel;", "Companion", "intellij.platform.ssh"})
public final class SshConnection {
    private final ArrayList<SshSession> h;
    private final ArrayList<SshSession> c;
    private final ReentrantLock i;
    private final ReentrantLock g;
    private volatile boolean b;
    @NotNull
    private final String a;
    @NotNull
    private final String d;
    private final int f;
    private static final Logger e;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final <R extends SshChannel> R openChannel(@NotNull SessionConfig sessionConfig, @NotNull ChannelFactory<? extends R> channelFactory) throws SshTransportException {
        SshSession sshSession;
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkParameterIsNotNull(channelFactory, (String)"channelCreator");
        Lock lock = this.i;
        lock.lock();
        this.a();
        Iterator<SshSession> iterator = this.h.iterator();
        while (iterator.hasNext()) {
            sshSession = iterator.next();
            if (sshSession.isConnected()) {
                try {
                    R r2 = sshSession.openChannel$intellij_platform_ssh(channelFactory);
                    lock.unlock();
                    return r2;
                }
                catch (SshTransportException sshTransportException) {
                    if (SshConnection.Companion.a(sshTransportException)) continue;
                    throw (Throwable)new SshTransportException(sshTransportException.getMessage(), sshTransportException);
                }
            }
            iterator.remove();
            Lock lock2 = this.g;
            lock2.lock();
            try {
                boolean bl2 = this.c.remove(sshSession);
            }
            finally {
                lock2.unlock();
            }
        }
        SshConnection.Companion.a().debug("Failed to create SSH channel using existing SSH sessions, creating new SSH session");
        sshSession = this.b(sessionConfig);
        R r3 = sshSession.openChannel$intellij_platform_ssh(channelFactory);
        return r3;
        finally {
            lock.unlock();
        }
    }

    public final void connect(@NotNull SessionConfig sessionConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        this.getSession(sessionConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SshSession getSshSession(@NotNull SessionConfig sessionConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Lock lock = this.i;
        lock.lock();
        try {
            Iterator<SshSession> iterator = this.h.iterator();
            while (iterator.hasNext()) {
                SshSession sshSession = iterator.next();
                if (sshSession.isConnected()) {
                    SshSession sshSession2 = sshSession;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sshSession2, (String)"session");
                    SshSession sshSession3 = sshSession2;
                    return sshSession3;
                }
                iterator.remove();
                Lock lock2 = this.g;
                lock2.lock();
                try {
                    boolean bl2 = this.c.remove(sshSession);
                }
                finally {
                    lock2.unlock();
                }
            }
            SshConnection.Companion.a().debug("No opened sessions to " + this.a + '@' + this.d + ':' + this.f + " found");
            SshSession sshSession = this.b(sessionConfig);
            return sshSession;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final Session getSession(@NotNull SessionConfig sessionConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        return this.getSshSession(sessionConfig).getRawSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SshSession b(SessionConfig sessionConfig) throws SshTransportException {
        try {
            SshConnection.Companion.a().debug("Establishing new SSH session to " + this.a + '@' + this.d + ':' + this.f);
            SshSession sshSession = this.a(sessionConfig);
            Session session = sshSession.getRawSession();
            SshConnection.Companion.a().debug("SSH session " + SshConnectionUtil.id(sshSession) + " (" + SshConnectionUtil.id(session) + ") established to " + this.a + '@' + this.d + ':' + this.f);
            Lock lock = this.g;
            lock.lock();
            try {
                this.a();
                boolean bl2 = this.h.add(sshSession);
            }
            finally {
                lock.unlock();
            }
            return sshSession;
        }
        catch (JSchException jSchException) {
            throw (Throwable)new SshTransportException(SshConnectionKt.getErrorMessage(this.d, jSchException), jSchException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SshSession a(SessionConfig sessionConfig) {
        Object object = SshConnectionUtil.setUpSession(sessionConfig);
        ConfigRepository.Config config = (ConfigRepository.Config)object.component1();
        Session session = (Session)object.component2();
        object = new SshSession(session, config);
        Lock lock = this.g;
        lock.lock();
        try {
            this.a();
            boolean bl2 = this.c.add((SshSession)object);
        }
        finally {
            lock.unlock();
        }
        session.connect();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Lock lock = this.g;
        lock.lock();
        try {
            if (!this.b) {
                this.b = true;
                SshConnection.Companion.a().debug("Disconnecting SSH sessions to " + this.a + '@' + this.d + ':' + this.f);
                for (SshSession object2 : this.c) {
                    object2.disconnect();
                }
                this.c.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void a() {
        if (this.b) {
            throw (Throwable)new IllegalStateException("SSH connection to " + this.a + '@' + this.d + ':' + this.f + " disposed");
        }
    }

    @NotNull
    public final String getUserName() {
        return this.a;
    }

    @NotNull
    public final String getHost() {
        return this.d;
    }

    public final int getPort() {
        return this.f;
    }

    public SshConnection(@NotNull String string, @NotNull String string2, int n2) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"userName");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"host");
        this.a = string;
        this.d = string2;
        this.f = n2;
        this.h = new ArrayList();
        this.c = new ArrayList();
        this.i = new ReentrantLock();
        this.g = new ReentrantLock();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SshConnection.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(SshConnection::class.java)");
        e = logger;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ssh/impl/SshConnection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "isChannelIsNotOpenedCause", "", "e", "Lcom/intellij/ssh/SshTransportException;", "intellij.platform.ssh"})
    public static final class Companion {
        private final Logger a() {
            return e;
        }

        private final boolean a(SshTransportException sshTransportException) {
            String string = sshTransportException.getMessage();
            return string != null && StringsKt.contains$default((CharSequence)string, (CharSequence)"channel is not opened.", (boolean)false, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

