/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl;

import com.intellij.util.ExceptionUtil;
import java.net.ConnectException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"getErrorMessage", "", "host", "exception", "", "intellij.platform.ssh"})
public final class SshConnectionKt {
    @NotNull
    public static final String getErrorMessage(@NotNull String string, @NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"exception");
        ConnectException connectException = (ConnectException)ExceptionUtil.findCause((Throwable)throwable, ConnectException.class);
        if (connectException != null) {
            String string2 = connectException.getLocalizedMessage();
            return "Error connecting to remote host " + string + ": " + string2;
        }
        UnknownHostException unknownHostException = (UnknownHostException)ExceptionUtil.findCause((Throwable)throwable, UnknownHostException.class);
        if (unknownHostException != null) {
            String string3 = unknownHostException.getMessage();
            if (string3 == null) {
                string3 = string;
            }
            String string4 = string3;
            return "DNS address of remote host " + string4 + " could not be found.";
        }
        String string5 = throwable.getLocalizedMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"exception.localizedMessage");
        return string5;
    }
}

