/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TObjectLongHashMap;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class CpuUsageData {
    private static final ThreadMXBean c = ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> a = ManagementFactory.getGarbageCollectorMXBeans();
    private static final CompilationMXBean e = ManagementFactory.getCompilationMXBean();
    public final long durationMs;
    private final FreeMemorySnapshot h;
    private final FreeMemorySnapshot f;
    private final long b;
    private final List<Pair<Long, String>> g = new ArrayList<Pair<Long, String>>();
    private final List<Pair<Long, String>> d = new ArrayList<Pair<Long, String>>();

    private CpuUsageData(long l4, TObjectLongHashMap<GarbageCollectorMXBean> tObjectLongHashMap, TLongLongHashMap tLongLongHashMap, long l5, FreeMemorySnapshot freeMemorySnapshot, FreeMemorySnapshot freeMemorySnapshot2) {
        this.durationMs = l4;
        this.h = freeMemorySnapshot;
        this.f = freeMemorySnapshot2;
        this.b = l5;
        tObjectLongHashMap.forEachEntry((garbageCollectorMXBean, l2) -> {
            this.g.add((Pair<Long, String>)Pair.create((Object)l2, (Object)garbageCollectorMXBean.getName()));
            return true;
        });
        tLongLongHashMap.forEachEntry((l2, l3) -> {
            ThreadInfo threadInfo = c.getThreadInfo(l2);
            this.d.add((Pair<Long, String>)Pair.create((Object)CpuUsageData.a(l3), (Object)(threadInfo == null ? "<unknown>" : threadInfo.getThreadName())));
            return true;
        });
    }

    public String getGcStats() {
        return CpuUsageData.a(this.g) + "; free " + this.h + " -> " + this.f + " MB";
    }

    public String getThreadStats() {
        return CpuUsageData.a(this.d);
    }

    public String getSummary(String string) {
        return string + "GC: " + this.getGcStats() + "\n" + string + "Threads: " + this.getThreadStats() + "\n" + string + "JIT: " + this.b + "ms";
    }

    boolean hasAnyActivityBesides(Thread thread) {
        return this.b > 0L || this.d.stream().anyMatch(pair2 -> (Long)pair2.first > 0L && !((String)pair2.second).equals(thread.getName())) || this.g.stream().anyMatch(pair2 -> (Long)pair2.first > 0L);
    }

    @NotNull
    private static String a(List<Pair<Long, String>> list2) {
        String string = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(list2).sortedBy(pair2 -> -((Long)pair2.first).longValue())).filter(pair2 -> (Long)pair2.first > 10L)).limit(10L)).map(pair2 -> "\"" + (String)pair2.second + "\" took " + pair2.first + "ms").joining((CharSequence)", ");
        String string2 = string.isEmpty() ? "insignificant" : string;
        if (string2 == null) {
            CpuUsageData.a(0);
        }
        return string2;
    }

    private static long a(long l2) {
        return l2 / 1000000L;
    }

    public static <E extends Throwable> CpuUsageData measureCpuUsage(ThrowableRunnable<E> throwableRunnable) throws E {
        FreeMemorySnapshot freeMemorySnapshot = new FreeMemorySnapshot();
        TObjectLongHashMap tObjectLongHashMap = new TObjectLongHashMap();
        for (GarbageCollectorMXBean object : a) {
            tObjectLongHashMap.put((Object)object, object.getCollectionTime());
        }
        TLongLongHashMap tLongLongHashMap = new TLongLongHashMap();
        for (long l2 : c.getAllThreadIds()) {
            tLongLongHashMap.put(l2, c.getThreadUserTime(l2));
        }
        long l3 = e.getTotalCompilationTime();
        long l4 = System.currentTimeMillis();
        throwableRunnable.run();
        long l5 = System.currentTimeMillis() - l4;
        long l6 = e.getTotalCompilationTime() - l3;
        FreeMemorySnapshot freeMemorySnapshot2 = new FreeMemorySnapshot();
        for (long l7 : c.getAllThreadIds()) {
            tLongLongHashMap.put(l7, c.getThreadUserTime(l7) - tLongLongHashMap.get(l7));
        }
        Object object = a.iterator();
        while (object.hasNext()) {
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)object.next();
            tObjectLongHashMap.put((Object)garbageCollectorMXBean, garbageCollectorMXBean.getCollectionTime() - tObjectLongHashMap.get((Object)garbageCollectorMXBean));
        }
        return new CpuUsageData(l5, (TObjectLongHashMap<GarbageCollectorMXBean>)tObjectLongHashMap, tLongLongHashMap, l6, freeMemorySnapshot, freeMemorySnapshot2);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/CpuUsageData", "printLongestNames"));
    }

    private static class FreeMemorySnapshot {
        final long free = FreeMemorySnapshot.a(Runtime.getRuntime().freeMemory());
        final long total = FreeMemorySnapshot.a(Runtime.getRuntime().totalMemory());

        private FreeMemorySnapshot() {
        }

        private static long a(long l2) {
            return l2 / 1024L / 1024L;
        }

        public String toString() {
            return this.free + "/" + this.total;
        }
    }
}

