/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.io.CharArrayReader;
import java.io.File;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class InspectionTestUtil {
    private InspectionTestUtil() {
    }

    protected static void compareWithExpected(Document document, Document document2, boolean bl2) throws Exception {
        ArrayList arrayList = new ArrayList(document.getRootElement().getChildren("problem"));
        ArrayList arrayList2 = new ArrayList(document2.getRootElement().getChildren("problem"));
        Element[] elementArray = arrayList.toArray(new Element[0]);
        boolean bl3 = false;
        block0: for (Element element : elementArray) {
            Document document3;
            for (Element element2 : document3 = arrayList2.toArray(new Element[0])) {
                if (!InspectionTestUtil.compareProblemWithExpected(element2, element, bl2)) continue;
                arrayList.remove(element);
                arrayList2.remove(element2);
                continue block0;
            }
            Document document4 = new Document(element.clone());
            System.out.println("The following haven't been reported as expected: " + JDOMUtil.writeDocument((Document)document4, (String)"\n"));
            bl3 = true;
        }
        for (Element element : arrayList2) {
            Document document5 = new Document(element.clone());
            System.out.println("The following has been unexpectedly reported: " + JDOMUtil.writeDocument((Document)document5, (String)"\n"));
            bl3 = true;
        }
        Assert.assertFalse((boolean)bl3);
    }

    static boolean compareProblemWithExpected(Element element, Element element2, boolean bl2) throws Exception {
        if (!InspectionTestUtil.compareFiles(element, element2)) {
            return false;
        }
        if (!InspectionTestUtil.compareLines(element, element2)) {
            return false;
        }
        if (!InspectionTestUtil.compareDescriptions(element, element2)) {
            return false;
        }
        return !bl2 || InspectionTestUtil.compareTextRange(element, element2);
    }

    static boolean compareTextRange(Element element, Element element2) {
        Element element3 = element.getChild("entry_point");
        if (element3 == null) {
            return false;
        }
        Element element4 = element2.getChild("entry_point");
        return Comparing.equal((String)element3.getAttributeValue("TYPE"), (String)element4.getAttributeValue("TYPE")) && Comparing.equal((String)element3.getAttributeValue("FQNAME"), (String)element4.getAttributeValue("FQNAME"));
    }

    static boolean compareDescriptions(Element element, Element element2) throws Exception {
        String string;
        String string2 = element2.getChildText("description");
        if (string2.equals(string = element.getChildText("description"))) {
            return true;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new CharArrayReader(string2.toCharArray()));
        streamTokenizer.quoteChar(39);
        int n2 = 0;
        while (streamTokenizer.nextToken() != -1) {
            String string3;
            if (streamTokenizer.sval != null) {
                string3 = streamTokenizer.sval;
            } else {
                if (streamTokenizer.ttype != -2) continue;
                string3 = Double.toString(streamTokenizer.nval);
            }
            n2 = string.indexOf(string3, n2);
            if (n2 == -1) {
                return false;
            }
            n2 += string3.length();
        }
        return true;
    }

    static boolean compareLines(Element element, Element element2) {
        return Comparing.equal((String)element.getChildText("line"), (String)element2.getChildText("line"));
    }

    static boolean compareFiles(Element element, Element element2) {
        String string = element.getChildText("file");
        if (string == null) {
            return true;
        }
        File file = new File(string);
        return Comparing.equal((String)file.getName(), (String)element2.getChildText("file"));
    }

    public static void compareToolResults(@NotNull GlobalInspectionContextImpl globalInspectionContextImpl, @NotNull InspectionToolWrapper inspectionToolWrapper, boolean bl2, @NotNull String string) {
        if (globalInspectionContextImpl == null) {
            InspectionTestUtil.a(0);
        }
        if (inspectionToolWrapper == null) {
            InspectionTestUtil.a(1);
        }
        if (string == null) {
            InspectionTestUtil.a(2);
        }
        InspectionTestUtil.compareToolResults(globalInspectionContextImpl, bl2, string, Collections.singletonList(inspectionToolWrapper));
    }

    static void compareToolResults(@NotNull GlobalInspectionContextImpl globalInspectionContextImpl, boolean bl2, @NotNull String string, @NotNull Collection<? extends InspectionToolWrapper> collection) {
        if (globalInspectionContextImpl == null) {
            InspectionTestUtil.a(3);
        }
        if (string == null) {
            InspectionTestUtil.a(4);
        }
        if (collection == null) {
            InspectionTestUtil.a(5);
        }
        Element element = new Element("problems");
        for (InspectionToolWrapper inspectionToolWrapper : collection) {
            InspectionToolPresentation inspectionToolPresentation = globalInspectionContextImpl.getPresentation(inspectionToolWrapper);
            inspectionToolPresentation.updateContent();
            inspectionToolPresentation.exportResults(element, refEntity -> false, commonProblemDescriptor -> false);
        }
        try {
            File file = new File(string + "/expected.xml");
            InspectionTestUtil.compareWithExpected(JDOMUtil.loadDocument((File)file), new Document(element), bl2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void runTool(@NotNull InspectionToolWrapper inspectionToolWrapper, @NotNull AnalysisScope analysisScope, @NotNull GlobalInspectionContextForTests globalInspectionContextForTests) {
        String string;
        HighlightDisplayKey highlightDisplayKey;
        if (inspectionToolWrapper == null) {
            InspectionTestUtil.a(6);
        }
        if (analysisScope == null) {
            InspectionTestUtil.a(7);
        }
        if (globalInspectionContextForTests == null) {
            InspectionTestUtil.a(8);
        }
        if ((highlightDisplayKey = HighlightDisplayKey.find((String)(string = inspectionToolWrapper.getShortName()))) == null) {
            HighlightDisplayKey.register((String)string);
        }
        globalInspectionContextForTests.doInspections(analysisScope);
        do {
            UIUtil.dispatchAllInvocationEvents();
        } while (!globalInspectionContextForTests.isFinished());
    }

    @NotNull
    public static <T extends InspectionProfileEntry> List<InspectionProfileEntry> instantiateTools(@NotNull Collection<Class<? extends T>> collection) {
        if (collection == null) {
            InspectionTestUtil.a(9);
        }
        Set set = JBIterable.from(collection).transform(Class::getName).toSet();
        List list2 = JBIterable.of((Object[])new ExtensionPointName[]{LocalInspectionEP.LOCAL_INSPECTION, InspectionEP.GLOBAL_INSPECTION}).flatten(extensionPointName -> Arrays.asList(extensionPointName.getExtensions())).filter(inspectionEP -> set.contains(inspectionEP.implementationClass)).transform(InspectionEP::instantiateTool).toList();
        if (list2.size() != set.size()) {
            TreeSet treeSet = ContainerUtil.newTreeSet((Iterable)set);
            treeSet.removeAll(JBIterable.from((Iterable)list2).transform(inspectionProfileEntry -> inspectionProfileEntry.getClass().getName()).toSet());
            throw new RuntimeException("Unregistered inspections requested: " + treeSet);
        }
        List list3 = list2;
        if (list3 == null) {
            InspectionTestUtil.a(10);
        }
        return list3;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/InspectionTestUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/InspectionTestUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateTools";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareToolResults";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "instantiateTools";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

