/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class LightProjectDescriptor {
    public static final LightProjectDescriptor EMPTY_PROJECT_DESCRIPTOR = new LightProjectDescriptor();
    public static final String TEST_MODULE_NAME = "light_idea_test_case";

    public void setUpProject(@NotNull Project project2, @NotNull SetupHandler setupHandler) throws Exception {
        if (project2 == null) {
            LightProjectDescriptor.a(0);
        }
        if (setupHandler == null) {
            LightProjectDescriptor.a(1);
        }
        WriteAction.run(() -> {
            if (project2 == null) {
                LightProjectDescriptor.a(20);
            }
            if (setupHandler == null) {
                LightProjectDescriptor.a(21);
            }
            Module module2 = this.createMainModule(project2);
            setupHandler.moduleCreated(module2);
            VirtualFile virtualFile = this.createSourcesRoot(module2);
            if (virtualFile != null) {
                setupHandler.sourceRootCreated(virtualFile);
                this.createContentEntry(module2, virtualFile);
            }
        });
    }

    @NotNull
    public Module createMainModule(@NotNull Project project2) {
        if (project2 == null) {
            LightProjectDescriptor.a(2);
        }
        Module module2 = this.createModule(project2, FileUtil.join((String[])new String[]{FileUtil.getTempDirectory(), "light_idea_test_case.iml"}));
        if (module2 == null) {
            LightProjectDescriptor.a(3);
        }
        return module2;
    }

    protected Module createModule(@NotNull Project project2, @NotNull String string) {
        if (project2 == null) {
            LightProjectDescriptor.a(4);
        }
        if (string == null) {
            LightProjectDescriptor.a(5);
        }
        return (Module)WriteAction.compute(() -> {
            File file;
            if (string == null) {
                LightProjectDescriptor.a(18);
            }
            if (project2 == null) {
                LightProjectDescriptor.a(19);
            }
            if ((file = new File(string)).exists()) {
                FileUtil.delete((File)file);
            }
            return ModuleManager.getInstance((Project)project2).newModule(string, this.getModuleType().getId());
        });
    }

    @NotNull
    public ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            LightProjectDescriptor.a(6);
        }
        return emptyModuleType;
    }

    @Nullable
    public VirtualFile createSourcesRoot(@NotNull Module module2) {
        if (module2 == null) {
            LightProjectDescriptor.a(7);
        }
        return this.createSourceRoot(module2, "src");
    }

    protected VirtualFile createSourceRoot(@NotNull Module module2, String string) {
        if (module2 == null) {
            LightProjectDescriptor.a(8);
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        assert (virtualFile != null);
        virtualFile.refresh(false, false);
        VirtualFile virtualFile2 = this.doCreateSourceRoot(virtualFile, string);
        this.registerSourceRoot(module2.getProject(), virtualFile2);
        return virtualFile2;
    }

    protected VirtualFile doCreateSourceRoot(VirtualFile virtualFile, String string) {
        VirtualFile virtualFile2;
        try {
            virtualFile2 = virtualFile.createChildDirectory((Object)this, string);
            this.a(virtualFile2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return virtualFile2;
    }

    protected void registerSourceRoot(final Project project2, final VirtualFile virtualFile) {
        IndexableFileSet indexableFileSet = new IndexableFileSet(){

            public boolean isInSet(@NotNull VirtualFile virtualFile2) {
                if (virtualFile2 == null) {
                    1.a(0);
                }
                return virtualFile2.getFileSystem() == virtualFile.getFileSystem() && project2.isOpen();
            }

            public void iterateIndexableFilesIn(@NotNull VirtualFile virtualFile2, final @NotNull ContentIterator contentIterator) {
                if (virtualFile2 == null) {
                    1.a(1);
                }
                if (contentIterator == null) {
                    1.a(2);
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile virtualFile) {
                        if (virtualFile == null) {
                            1.a(0);
                        }
                        contentIterator.processFile(virtualFile);
                        return true;
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$1$1", "visitFile"));
                    }
                });
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "iterator";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/LightProjectDescriptor$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInSet";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "iterateIndexableFilesIn";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        FileBasedIndex.getInstance().registerIndexableSet(indexableFileSet, null);
        Disposer.register((Disposable)project2, () -> FileBasedIndex.getInstance().removeIndexableSet(indexableFileSet));
    }

    protected void createContentEntry(@NotNull Module module2, @NotNull VirtualFile virtualFile) {
        if (module2 == null) {
            LightProjectDescriptor.a(9);
        }
        if (virtualFile == null) {
            LightProjectDescriptor.a(10);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> {
            Sdk sdk;
            if (virtualFile == null) {
                LightProjectDescriptor.a(16);
            }
            if (module2 == null) {
                LightProjectDescriptor.a(17);
            }
            if ((sdk = this.getSdk()) != null) {
                modifiableRootModel.setSdk(sdk);
            }
            ContentEntry contentEntry = modifiableRootModel.addContentEntry(virtualFile);
            contentEntry.addSourceFolder(virtualFile, this.getSourceRootType());
            this.configureModule(module2, (ModifiableRootModel)modifiableRootModel, contentEntry);
        });
    }

    @NotNull
    protected JpsModuleSourceRootType<?> getSourceRootType() {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        if (javaSourceRootType == null) {
            LightProjectDescriptor.a(11);
        }
        return javaSourceRootType;
    }

    @Nullable
    public Sdk getSdk() {
        return null;
    }

    private void a(@NotNull VirtualFile virtualFile) throws IOException {
        if (virtualFile == null) {
            LightProjectDescriptor.a(12);
        }
        TempFileSystem tempFileSystem = (TempFileSystem)virtualFile.getFileSystem();
        for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
            if (!tempFileSystem.exists(virtualFile2)) {
                tempFileSystem.createChildFile((Object)this, virtualFile, virtualFile2.getName());
            }
            virtualFile2.delete((Object)this);
        }
    }

    protected void configureModule(@NotNull Module module2, @NotNull ModifiableRootModel modifiableRootModel, @NotNull ContentEntry contentEntry) {
        if (module2 == null) {
            LightProjectDescriptor.a(13);
        }
        if (modifiableRootModel == null) {
            LightProjectDescriptor.a(14);
        }
        if (contentEntry == null) {
            LightProjectDescriptor.a(15);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightProjectDescriptor";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRoot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightProjectDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMainModule";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSourcesRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRoot";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createContentEntry";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cleanSourceRoot";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureModule";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createContentEntry$3";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createModule$1";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setUpProject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SetupHandler {
        default public void moduleCreated(@NotNull Module module2) {
            if (module2 == null) {
                SetupHandler.a(0);
            }
        }

        default public void sourceRootCreated(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                SetupHandler.a(1);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoot";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/LightProjectDescriptor$SetupHandler";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moduleCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceRootCreated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

