/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockEditorFactory;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileTypeManager;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.mock.MockProjectEx;
import com.intellij.mock.MockPsiDocumentManager;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.MockSchemeManagerFactory;
import com.intellij.testFramework.PlatformLiteFixture;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;

public abstract class ParsingTestCase
extends PlatformLiteFixture {
    protected String myFilePrefix;
    protected String myFileExt;
    protected final String myFullDataPath;
    protected PsiFile myFile;
    private MockPsiManager n;
    private PsiFileFactoryImpl m;
    protected Language myLanguage;
    private final ParserDefinition[] l;
    private final boolean k;

    protected ParsingTestCase(@NonNls @NotNull String string, @NotNull String string2, ParserDefinition ... parserDefinitionArray) {
        if (string == null) {
            ParsingTestCase.c(0);
        }
        if (string2 == null) {
            ParsingTestCase.c(1);
        }
        if (parserDefinitionArray == null) {
            ParsingTestCase.c(2);
        }
        this(string, string2, false, parserDefinitionArray);
    }

    protected ParsingTestCase(@NonNls @NotNull String string, @NotNull String string2, boolean bl2, ParserDefinition ... parserDefinitionArray) {
        if (string == null) {
            ParsingTestCase.c(3);
        }
        if (string2 == null) {
            ParsingTestCase.c(4);
        }
        if (parserDefinitionArray == null) {
            ParsingTestCase.c(5);
        }
        this.myFilePrefix = "";
        this.l = parserDefinitionArray;
        this.myFullDataPath = this.getTestDataPath() + "/" + string;
        this.myFileExt = string2;
        this.k = bl2;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        ComponentAdapter componentAdapter = ParsingTestCase.getApplication().getPicoContainer().getComponentAdapter((Object)ProgressManager.class.getName());
        if (componentAdapter == null) {
            ParsingTestCase.getApplication().getPicoContainer().registerComponent((ComponentAdapter)new AbstractComponentAdapter(ProgressManager.class.getName(), Object.class){

                public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException {
                    return new ProgressManagerImpl();
                }

                public void verify(PicoContainer picoContainer) throws PicoIntrospectionException {
                }
            });
        }
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        this.myProject = new MockProjectEx(this.getTestRootDisposable());
        this.n = new MockPsiManager((Project)this.myProject);
        this.m = new PsiFileFactoryImpl((PsiManager)this.n);
        MutablePicoContainer mutablePicoContainer = ParsingTestCase.getApplication().getPicoContainer();
        ParsingTestCase.registerComponentInstance(mutablePicoContainer, MessageBus.class, ParsingTestCase.getApplication().getMessageBus());
        ParsingTestCase.registerComponentInstance(mutablePicoContainer, SchemeManagerFactory.class, new MockSchemeManagerFactory());
        MockEditorFactory mockEditorFactory = new MockEditorFactory();
        ParsingTestCase.registerComponentInstance(mutablePicoContainer, EditorFactory.class, mockEditorFactory);
        ParsingTestCase.registerComponentInstance(mutablePicoContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(charSequence -> mockEditorFactory.createDocument((CharSequence)charSequence), FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY));
        ParsingTestCase.registerComponentInstance(mutablePicoContainer, PsiDocumentManager.class, new MockPsiDocumentManager());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(DefaultASTFactory.class, new DefaultASTFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl((Project)this.myProject, (CachedValuesFactory)new PsiCachedValuesFactory((PsiManager)this.n)));
        this.myProject.registerService(PsiManager.class, this.n);
        this.myProject.registerService(StartupManager.class, new StartupManagerImpl((Project)this.myProject));
        this.registerExtensionPoint(FileTypeFactory.FILE_TYPE_FACTORY_EP, FileTypeFactory.class);
        this.registerExtensionPoint(MetaLanguage.EP_NAME, MetaLanguage.class);
        for (ParserDefinition parserDefinition : this.l) {
            this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, parserDefinition.getFileNodeType().getLanguage(), (Object)parserDefinition);
        }
        if (this.l.length > 0) {
            this.configureFromParserDefinition(this.l[0], this.myFileExt);
        }
        PomModelImpl pomModelImpl = new PomModelImpl((Project)this.myProject);
        this.myProject.registerService(PomModel.class, pomModelImpl);
        new TreeAspect((PomModel)pomModelImpl);
    }

    public void configureFromParserDefinition(ParserDefinition parserDefinition, String string) {
        this.myLanguage = parserDefinition.getFileNodeType().getLanguage();
        this.myFileExt = string;
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, this.myLanguage, (Object)parserDefinition);
        ParsingTestCase.registerComponentInstance(ParsingTestCase.getApplication().getPicoContainer(), FileTypeManager.class, new MockFileTypeManager((FileType)new MockLanguageFileType(this.myLanguage, this.myFileExt)));
    }

    protected <T> void addExplicitExtension(LanguageExtension<T> languageExtension, Language language, T t2) {
        languageExtension.addExplicitExtension((Object)language, t2);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> languageExtension.removeExplicitExtension((Object)language, t2));
    }

    @Override
    protected <T> void registerExtensionPoint(ExtensionPointName<T> extensionPointName, Class<T> clazz) {
        super.registerExtensionPoint(extensionPointName, clazz);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> Extensions.getRootArea().unregisterExtensionPoint(extensionPointName.getName()));
    }

    protected <T> void registerApplicationService(Class<T> clazz, T t2) {
        ParsingTestCase.getApplication().registerService(clazz, t2);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> ParsingTestCase.getApplication().getPicoContainer().unregisterComponent((Object)clazz.getName()));
    }

    @NotNull
    public MockProjectEx getProject() {
        MockProjectEx mockProjectEx = this.myProject;
        if (mockProjectEx == null) {
            ParsingTestCase.c(6);
        }
        return mockProjectEx;
    }

    public MockPsiManager getPsiManager() {
        return this.n;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFile = null;
        this.myProject = null;
        this.n = null;
        this.m = null;
        super.tearDown();
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    public final String getTestName() {
        String string = this.getTestName(this.k);
        if (string == null) {
            ParsingTestCase.c(7);
        }
        return string;
    }

    protected boolean includeRanges() {
        return false;
    }

    protected boolean skipSpaces() {
        return false;
    }

    protected boolean checkAllPsiRoots() {
        return true;
    }

    protected void doTest(boolean bl2) {
        String string = this.getTestName();
        try {
            String string2 = this.loadFile(string + "." + this.myFileExt);
            this.myFile = this.createPsiFile(string, string2);
            ParsingTestCase.ensureParsed(this.myFile);
            ParsingTestCase.assertEquals((String)"light virtual file text mismatch", (String)string2, (String)((LightVirtualFile)this.myFile.getVirtualFile()).getContent().toString());
            ParsingTestCase.assertEquals((String)"virtual file text mismatch", (Object)string2, (Object)LoadTextUtil.loadText((VirtualFile)this.myFile.getVirtualFile()));
            ParsingTestCase.assertEquals((String)"doc text mismatch", (String)string2, (String)this.myFile.getViewProvider().getDocument().getText());
            ParsingTestCase.assertEquals((String)"psi text mismatch", (String)string2, (String)this.myFile.getText());
            ParsingTestCase.ensureCorrectReparse(this.myFile);
            if (bl2) {
                this.checkResult(string, this.myFile);
            } else {
                ParsingTestCase.toParseTreeText((PsiElement)this.myFile, this.skipSpaces(), this.includeRanges());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void doTest(String string) throws IOException {
        String string2 = this.getTestName();
        String string3 = this.loadFile(string2 + "." + this.myFileExt);
        this.myFile = this.createPsiFile(string2, string3);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)string3, (String)this.myFile.getText());
        this.checkResult(string2 + string, this.myFile);
    }

    protected void doCodeTest(String string) throws IOException {
        String string2 = this.getTestName();
        this.myFile = this.createPsiFile("a", string);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)string, (String)this.myFile.getText());
        this.checkResult(this.myFilePrefix + string2, this.myFile);
    }

    protected PsiFile createPsiFile(String string, String string2) {
        return this.createFile(string + "." + this.myFileExt, string2);
    }

    protected PsiFile createFile(@NonNls String string, String string2) {
        LightVirtualFile lightVirtualFile = new LightVirtualFile(string, this.myLanguage, (CharSequence)string2);
        lightVirtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        return this.createFile(lightVirtualFile);
    }

    protected PsiFile createFile(LightVirtualFile lightVirtualFile) {
        return this.m.trySetupPsiForFile(lightVirtualFile, this.myLanguage, true, false);
    }

    protected void checkResult(@NonNls String string, PsiFile psiFile) throws IOException {
        ParsingTestCase.doCheckResult(this.myFullDataPath, psiFile, this.checkAllPsiRoots(), string, this.skipSpaces(), this.includeRanges(), this.allTreesInSingleFile());
    }

    protected boolean allTreesInSingleFile() {
        return false;
    }

    public static void doCheckResult(String string, PsiFile psiFile, boolean bl2, String string2, boolean bl3, boolean bl4) {
        ParsingTestCase.doCheckResult(string, psiFile, bl2, string2, bl3, bl4, false);
    }

    public static void doCheckResult(String string, PsiFile psiFile, boolean bl2, String string2, boolean bl3, boolean bl4, boolean bl5) {
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Set set = fileViewProvider.getLanguages();
        if (!bl2 || set.size() == 1) {
            ParsingTestCase.doCheckResult(string, string2 + ".txt", ParsingTestCase.toParseTreeText((PsiElement)psiFile, bl3, bl4).trim());
            return;
        }
        if (bl5) {
            String string3 = string2 + ".txt";
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList arrayList = new ArrayList(set);
            ContainerUtil.sort(arrayList, Comparator.comparing(Language::getID));
            for (Language language : arrayList) {
                stringBuilder.append("Subtree: ").append(language.getDisplayName()).append(" (").append(language.getID()).append(")").append("\n").append(ParsingTestCase.toParseTreeText((PsiElement)fileViewProvider.getPsi(language), bl3, bl4).trim()).append("\n").append(StringUtil.repeat((String)"-", (int)80)).append("\n");
            }
            ParsingTestCase.doCheckResult(string, string3, stringBuilder.toString());
        } else {
            for (Language language : set) {
                PsiFile psiFile2 = fileViewProvider.getPsi(language);
                String string4 = string2 + "." + language.getID() + ".txt";
                ParsingTestCase.doCheckResult(string, string4, ParsingTestCase.toParseTreeText((PsiElement)psiFile2, bl3, bl4).trim());
            }
        }
    }

    protected void checkResult(String string) {
        String string2 = this.getTestName();
        ParsingTestCase.doCheckResult(this.myFullDataPath, this.myFilePrefix + string2 + ".txt", string);
    }

    protected void checkResult(@NonNls String string, String string2) {
        ParsingTestCase.doCheckResult(this.myFullDataPath, string, string2);
    }

    public static void doCheckResult(String string, String string2, String string3) {
        String string4 = string + File.separatorChar + string2;
        UsefulTestCase.assertSameLinesWithFile(string4, string3);
    }

    protected static String toParseTreeText(PsiElement psiElement, boolean bl2, boolean bl3) {
        return DebugUtil.psiToString((PsiElement)psiElement, (boolean)bl2, (boolean)bl3);
    }

    protected String loadFile(@NonNls String string) throws IOException {
        return ParsingTestCase.loadFileDefault(this.myFullDataPath, string);
    }

    public static String loadFileDefault(String string, String string2) throws IOException {
        return FileUtil.loadFile((File)new File(string, string2), (String)"UTF-8", (boolean)true).trim();
    }

    public static void ensureParsed(PsiFile psiFile) {
        psiFile.accept(new PsiElementVisitor(){

            public void visitElement(PsiElement psiElement) {
                psiElement.acceptChildren((PsiElementVisitor)this);
            }
        });
    }

    public static void ensureCorrectReparse(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ParsingTestCase.c(8);
        }
        String string = DebugUtil.psiToString((PsiElement)psiFile, (boolean)false, (boolean)false);
        String string2 = psiFile.getText();
        DiffLog diffLog = new BlockSupportImpl(psiFile.getProject()).reparseRange(psiFile, psiFile.getNode(), TextRange.allOf((String)string2), (CharSequence)string2, (ProgressIndicator)new EmptyProgressIndicator(), (CharSequence)string2);
        diffLog.performActualPsiChange(psiFile);
        TestCase.assertEquals((String)string, (String)DebugUtil.psiToString((PsiElement)psiFile, (boolean)false, (boolean)false));
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureCorrectReparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

