/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ThrowableRunnable;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PerformanceTestInfo {
    private final ThrowableRunnable<?> e;
    private final int a;
    private ThrowableRunnable<?> h;
    private int g;
    private int f;
    private final String b;
    private boolean c;
    private boolean d;
    private boolean i;

    PerformanceTestInfo(@NotNull ThrowableRunnable throwableRunnable, int n2, @NotNull String string) {
        if (throwableRunnable == null) {
            PerformanceTestInfo.a(0);
        }
        if (string == null) {
            PerformanceTestInfo.a(1);
        }
        this.g = 1;
        this.f = 4;
        this.c = false;
        this.d = true;
        this.e = throwableRunnable;
        this.a = n2;
        assert (n2 > 0) : "Expected must be > 0. Was: " + n2;
        this.b = string;
    }

    @Contract(pure=true)
    public PerformanceTestInfo setup(@NotNull ThrowableRunnable throwableRunnable) {
        if (throwableRunnable == null) {
            PerformanceTestInfo.a(2);
        }
        assert (this.h == null);
        this.h = throwableRunnable;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesAllCPUCores() {
        return this.usesMultipleCPUCores(8);
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesMultipleCPUCores(int n2) {
        assert (this.d) : "This test configured to be io-bound, it cannot use all cores";
        this.g = n2;
        return this;
    }

    @Deprecated
    @Contract(pure=true)
    public PerformanceTestInfo cpuBound() {
        this.c = false;
        this.d = true;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo ioBound() {
        this.c = true;
        this.d = false;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo attempts(int n2) {
        this.f = n2;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo useLegacyScaling() {
        this.i = true;
        return this;
    }

    public void assertTiming() {
        if (PlatformTestUtil.COVERAGE_ENABLED_BUILD) {
            return;
        }
        Timings.getStatistics();
        if (this.f == 1) {
            System.gc();
        }
        while (true) {
            CpuUsageData cpuUsageData;
            --this.f;
            try {
                if (this.h != null) {
                    this.h.run();
                }
                PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
                cpuUsageData = CpuUsageData.measureCpuUsage(this.e);
            }
            catch (Error | RuntimeException throwable) {
                throw throwable;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            long l2 = cpuUsageData.durationMs;
            int n2 = this.a();
            double d2 = this.f == 1 ? 1.1 : 1.0;
            int n3 = (int)(100.0 * (double)(l2 - (long)n2) / (double)n2);
            String string = l2 < (long)n2 ? "32;1m" : ((double)l2 < (double)n2 * d2 ? "33;1m" : "31;1m");
            String string2 = String.format("%s took \u001b[%s%d%% %s time\u001b[0m than expected\n  Expected: %sms (%s)\n  Actual:   %sms (%s)\n  Timings:  %s\n  Threads:  %s\n  GC stats: %s", this.b, string, Math.abs(n3), n3 > 0 ? "more" : "less", n2, StringUtil.formatDuration((long)n2), l2, StringUtil.formatDuration((long)l2), Timings.getStatistics(), cpuUsageData.getThreadStats(), cpuUsageData.getGcStats());
            if (l2 < (long)n2) {
                TeamCityLogger.info((String)string2);
                System.out.println("\nSUCCESS: " + string2);
                break;
            }
            if ((double)l2 < (double)n2 * d2) {
                TeamCityLogger.warning((String)string2, null);
                System.out.println("\nWARNING: " + string2);
                break;
            }
            if (this.f == 0) {
                throw new AssertionFailedError(string2);
            }
            System.gc();
            System.gc();
            System.gc();
            String string3 = string2 + "\n  " + this.f + " attempts remain";
            TeamCityLogger.warning((String)string3, null);
            if (!UsefulTestCase.IS_UNDER_TEAMCITY) continue;
            System.err.println(string3);
        }
    }

    private int a() {
        int n2 = this.a;
        if (this.d) {
            int n3 = this.g < 8 ? Math.min(JobSchedulerImpl.getJobPoolParallelism(), this.g) : JobSchedulerImpl.getJobPoolParallelism();
            n2 *= this.g;
            n2 = PerformanceTestInfo.a(n2, Timings.CPU_TIMING, 200L, this.i);
            n2 /= n3;
        }
        if (this.c) {
            n2 = PerformanceTestInfo.a(n2, Timings.IO_TIMING, 100L, this.i);
        }
        return n2;
    }

    private static int a(int n2, long l2, long l3, boolean bl2) {
        if (bl2) {
            double d2 = 1.0 * (double)l2 / (double)l3;
            double d3 = d2 < 1.0 ? 0.9 + Math.pow(d2 - 0.7, 2.0) : 0.45 + Math.pow(d2 - 0.25, 2.0);
            n2 = (int)((double)n2 * d3);
            return n2;
        }
        return (int)((long)n2 * l2 / l3);
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/PerformanceTestInfo";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

