/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull Logger logger) {
        if (logger == null) {
            TestLogger.a(0);
        }
        super(logger);
    }

    public void warn(String string, @Nullable Throwable throwable) {
        throwable = TestLogger.checkException((Throwable)throwable);
        LoggedErrorProcessor.getInstance().processWarn(string, throwable, this.myLogger);
    }

    public void error(String string, @Nullable Throwable throwable, String ... stringArray) {
        if (stringArray == null) {
            TestLogger.a(1);
        }
        throwable = TestLogger.checkException((Throwable)throwable);
        LoggedErrorProcessor.getInstance().processError(string, throwable, stringArray, this.myLogger);
    }

    public void debug(@NonNls String string) {
        if (this.isDebugEnabled()) {
            super.debug(string);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, string, null);
        }
    }

    public void debug(@Nullable Throwable throwable) {
        if (this.isDebugEnabled()) {
            super.debug(throwable);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, null, throwable);
        }
    }

    public void debug(@NonNls String string, @Nullable Throwable throwable) {
        if (this.isDebugEnabled()) {
            super.debug(string, throwable);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, string, throwable);
        }
    }

    public void info(@NonNls String string) {
        super.info(string);
        TestLoggerFactory.log(this.myLogger, Level.INFO, string, null);
    }

    public void info(@NonNls String string, @Nullable Throwable throwable) {
        super.info(string, throwable);
        TestLoggerFactory.log(this.myLogger, Level.INFO, string, throwable);
    }

    public boolean isDebugEnabled() {
        if (ApplicationInfoImpl.isInStressTest()) {
            return super.isDebugEnabled();
        }
        return true;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestLogger";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

