/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.lang.Language;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.RegExp;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class UsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA;
    private static final String g;
    private static final String h;
    private static final Map<String, Long> c;
    private static final Map<String, Long> j;
    protected static final Logger LOG;
    @NotNull
    private final Disposable i = new TestDisposable();
    static String ourPathToKeep;
    private final List<String> d = new ArrayList<String>();
    private CodeStyleSettings f;
    private String b;
    static final Key<String> CREATION_PLACE;
    private static final Set<String> e;
    private static final Class a;
    @Deprecated
    public static final String IDEA_MARKER_CLASS = "com.intellij.openapi.roots.IdeaModifiableModelsProvider";

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.shouldContainTempFiles()) {
            String string = FileUtil.sanitizeFileName((String)this.getTestName(true));
            if (StringUtil.isEmptyOrSpaces((String)string)) {
                string = "";
            }
            string = new File(string).getName();
            this.b = new File(h, TEMP_DIR_MARKER + string).getPath();
            FileUtil.resetCanonicalTempPathCache((String)this.b);
        }
        boolean bl2 = this.isStressTest();
        ApplicationInfoImpl.setInStressTest((boolean)bl2);
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        Disposer.setDebugMode((!bl2 ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        try {
            new RunAll(() -> this.disposeRootDisposable(), () -> UsefulTestCase.c(), () -> UsefulTestCase.h(), () -> Disposer.setDebugMode((boolean)true), () -> {
                if (this.shouldContainTempFiles()) {
                    FileUtil.resetCanonicalTempPathCache((String)h);
                    if (this.d()) {
                        File[] fileArray = new File(this.b).listFiles();
                        if (fileArray != null) {
                            for (File file : fileArray) {
                                if (this.b(file)) continue;
                                FileUtil.delete((File)file);
                            }
                        }
                    } else {
                        FileUtil.delete((File)new File(this.b));
                    }
                }
            }, () -> UIUtil.removeLeakingAppleListeners()).run();
        }
        finally {
            super.tearDown();
        }
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull File file) {
        if (file == null) {
            UsefulTestCase.a(0);
        }
        this.d.add(file.getPath());
    }

    private boolean d() {
        return ourPathToKeep != null && FileUtil.isAncestor((String)this.b, (String)ourPathToKeep, (boolean)false) || !this.d.isEmpty();
    }

    private boolean b(@NotNull File file) {
        String string;
        if (file == null) {
            UsefulTestCase.a(1);
        }
        if (FileUtil.pathsEqual((String)(string = file.getPath()), (String)ourPathToKeep)) {
            return true;
        }
        for (String string2 : this.d) {
            if (!FileUtil.pathsEqual((String)string, (String)string2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void h() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        ArrayList<String> arrayList;
        Class clazz = a;
        synchronized (clazz) {
            if (e.isEmpty()) {
                return;
            }
            arrayList = new ArrayList<String>(e);
        }
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            String string = (String)arrayList.get(i2);
            File file = new File(string);
            if (!file.delete() && file.exists()) continue;
            Class clazz2 = a;
            synchronized (clazz2) {
                e.remove(string);
                continue;
            }
        }
    }

    private static void c() throws Exception {
        Object object = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map map = (Map)ReflectionUtil.getField(object.getClass(), (Object)object, Hashtable.class, (String)"componentKeyStrokeMap");
        map.clear();
        Map map2 = (Map)ReflectionUtil.getField(object.getClass(), (Object)object, Hashtable.class, (String)"containerMap");
        map2.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForJdkTableLeaks(@NotNull Sdk[] sdkArray) {
        Sdk[] sdkArray2;
        ProjectJdkTable projectJdkTable;
        if (sdkArray == null) {
            UsefulTestCase.a(2);
        }
        if ((projectJdkTable = ProjectJdkTable.getInstance()) != null && (sdkArray2 = projectJdkTable.getAllJdks()).length != 0) {
            THashSet tHashSet = new THashSet(Arrays.asList(sdkArray2));
            THashSet tHashSet2 = new THashSet(Arrays.asList(sdkArray));
            tHashSet.removeAll((Collection<?>)tHashSet2);
            try {
                if (!tHashSet.isEmpty()) {
                    UsefulTestCase.fail((String)("Leaked SDKs: " + tHashSet));
                }
            }
            finally {
                for (Sdk sdk : tHashSet) {
                    WriteAction.run(() -> projectJdkTable.removeJdk(sdk));
                }
            }
        }
    }

    protected void checkForSettingsDamage() {
        Application application = ApplicationManager.getApplication();
        if (this.isStressTest() || application == null || application instanceof MockApplication) {
            return;
        }
        CodeStyleSettings codeStyleSettings = this.f;
        if (codeStyleSettings == null) {
            return;
        }
        this.f = null;
        UsefulTestCase.doCheckForSettingsDamage(codeStyleSettings, CodeStyle.getDefaultSettings());
    }

    public static void doCheckForSettingsDamage(@NotNull CodeStyleSettings codeStyleSettings, @NotNull CodeStyleSettings codeStyleSettings2) {
        if (codeStyleSettings == null) {
            UsefulTestCase.a(3);
        }
        if (codeStyleSettings2 == null) {
            UsefulTestCase.a(4);
        }
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            try {
                Element element = new Element("temp");
                codeInsightSettings.writeExternal(element);
                Assert.assertEquals((String)"Code insight settings damaged", (Object)g, (Object)JDOMUtil.writeElement((Element)element));
            }
            catch (AssertionError assertionError) {
                CodeInsightSettings codeInsightSettings2 = new CodeInsightSettings();
                for (Field field : codeInsightSettings2.getClass().getFields()) {
                    try {
                        ReflectionUtil.copyFieldValue((Object)codeInsightSettings2, (Object)codeInsightSettings, (Field)field);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw assertionError;
            }
        }).append(() -> {
            if (codeStyleSettings2 == null) {
                UsefulTestCase.a(90);
            }
            if (codeStyleSettings == null) {
                UsefulTestCase.a(91);
            }
            codeStyleSettings2.getIndentOptions((FileType)StdFileTypes.JAVA);
            try {
                UsefulTestCase.a(codeStyleSettings, codeStyleSettings2);
            }
            finally {
                codeStyleSettings2.clearCodeStyleSettings();
            }
        }).append(() -> InplaceRefactoring.checkCleared()).append(() -> StartMarkAction.checkCleared()).run();
    }

    void storeSettings() {
        if (!this.isStressTest() && ApplicationManager.getApplication() != null) {
            this.f = CodeStyle.getDefaultSettings().clone();
            this.f.getIndentOptions((FileType)StdFileTypes.JAVA);
        }
    }

    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyle.getDefaultSettings();
        if (codeStyleSettings == null) {
            UsefulTestCase.a(5);
        }
        return codeStyleSettings;
    }

    protected final CommonCodeStyleSettings getLanguageSettings(@NotNull Language language) {
        if (language == null) {
            UsefulTestCase.a(6);
        }
        return this.getCurrentCodeStyleSettings().getCommonSettings(language);
    }

    protected final <T extends CustomCodeStyleSettings> CustomCodeStyleSettings getCustomSettings(@NotNull Class<T> clazz) {
        if (clazz == null) {
            UsefulTestCase.a(7);
        }
        return this.getCurrentCodeStyleSettings().getCustomSettings(clazz);
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable = this.i;
        if (disposable == null) {
            UsefulTestCase.a(8);
        }
        return disposable;
    }

    protected void runTest() throws Throwable {
        Throwable[] throwableArray = new Throwable[1];
        Runnable runnable = () -> {
            try {
                super.runTest();
                TestLoggerFactory.onTestFinished(true);
            }
            catch (InvocationTargetException invocationTargetException) {
                TestLoggerFactory.onTestFinished(false);
                invocationTargetException.fillInStackTrace();
                throwableArray[0] = invocationTargetException.getTargetException();
            }
            catch (IllegalAccessException illegalAccessException) {
                TestLoggerFactory.onTestFinished(false);
                illegalAccessException.fillInStackTrace();
                throwableArray[0] = illegalAccessException;
            }
            catch (Throwable throwable) {
                TestLoggerFactory.onTestFinished(false);
                throwableArray[0] = throwable;
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwableArray[0] != null) {
            throw throwableArray[0];
        }
    }

    protected boolean shouldRunTest() {
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            UsefulTestCase.a(9);
        }
        EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> {
            if (runnable == null) {
                UsefulTestCase.a(89);
            }
            runnable.run();
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void defaultRunBare() throws Throwable {
        Throwable throwable;
        block13: {
            throwable = null;
            long l2 = System.nanoTime();
            this.setUp();
            long l3 = (System.nanoTime() - l2) / 1000000L;
            this.a(l3, c);
            this.runTest();
            try {
                l2 = System.nanoTime();
                this.tearDown();
                l3 = (System.nanoTime() - l2) / 1000000L;
                this.a(l3, j);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    break block13;
                }
                throwable = new CompoundRuntimeException(Arrays.asList(throwable, throwable2));
            }
            break block13;
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                }
                catch (Throwable throwable4) {
                    try {
                        long l4 = System.nanoTime();
                        this.tearDown();
                        long l5 = (System.nanoTime() - l4) / 1000000L;
                        this.a(l5, j);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable == null ? throwable5 : new CompoundRuntimeException(Arrays.asList(throwable, throwable5));
                    }
                    throw throwable4;
                }
                try {
                    long l6 = System.nanoTime();
                    this.tearDown();
                    long l7 = (System.nanoTime() - l6) / 1000000L;
                    this.a(l7, j);
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        break block13;
                    }
                    throwable = new CompoundRuntimeException(Arrays.asList(throwable, throwable6));
                }
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    private void a(long l2, @NotNull Map<String, Long> map) {
        Class<?> clazz;
        Long l3;
        if (map == null) {
            UsefulTestCase.a(10);
        }
        long l4 = (l3 = map.get((clazz = ((Object)((Object)this)).getClass().getSuperclass()).getName())) == null ? l2 : l3 + l2;
        map.put(clazz.getName(), l4);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long l2 = 0L;
        for (Map.Entry<String, Long> entry : c.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            l2 += entry.getValue().longValue();
        }
        System.out.println("Teardown costs");
        long l3 = 0L;
        for (Map.Entry<String, Long> entry : j.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            l3 += entry.getValue().longValue();
        }
        System.out.println(String.format("Total overhead: setup %d ms, teardown %d ms", l2, l3));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']", l2));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']", l3));
    }

    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        if (this.runInDispatchThread()) {
            TestRunnerUtil.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)this::defaultRunBare));
        } else {
            this.defaultRunBare();
        }
    }

    protected boolean runInDispatchThread() {
        return true;
    }

    protected void edt(@NotNull ThrowableRunnable<Throwable> throwableRunnable) {
        if (throwableRunnable == null) {
            UsefulTestCase.a(11);
        }
        EdtTestUtil.runInEdtAndWait(throwableRunnable);
    }

    public static String toString(@NotNull Iterable<?> iterable) {
        if (iterable == null) {
            UsefulTestCase.a(12);
        }
        if (!iterable.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : iterable) {
            if (obj instanceof THashSet) {
                stringBuilder.append(new TreeSet((THashSet)obj));
            } else {
                stringBuilder.append(obj);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull T[] TArray, T ... TArray2) {
        if (TArray == null) {
            UsefulTestCase.a(13);
        }
        if (TArray2 == null) {
            UsefulTestCase.a(14);
        }
        UsefulTestCase.assertOrderedEquals(Arrays.asList(TArray), TArray2);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<T> iterable, T ... TArray) {
        if (iterable == null) {
            UsefulTestCase.a(15);
        }
        if (TArray == null) {
            UsefulTestCase.a(16);
        }
        UsefulTestCase.assertOrderedEquals(null, iterable, TArray);
    }

    public static void assertOrderedEquals(@NotNull byte[] byArray, @NotNull byte[] byArray2) {
        if (byArray == null) {
            UsefulTestCase.a(17);
        }
        if (byArray2 == null) {
            UsefulTestCase.a(18);
        }
        UsefulTestCase.assertEquals((int)byArray.length, (int)byArray2.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by2 = byArray[i2];
            byte by3 = byArray2[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (byte)by3, (byte)by2);
        }
    }

    public static void assertOrderedEquals(@NotNull int[] nArray, @NotNull int[] nArray2) {
        if (nArray == null) {
            UsefulTestCase.a(19);
        }
        if (nArray2 == null) {
            UsefulTestCase.a(20);
        }
        if (nArray.length != nArray2.length) {
            UsefulTestCase.fail((String)("Expected size: " + nArray2.length + "; actual: " + nArray.length + "\nexpected: " + Arrays.toString(nArray2) + "\nactual  : " + Arrays.toString(nArray)));
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            int n3 = nArray2[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (int)n3, (int)n2);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(String string, @NotNull Iterable<T> iterable, T ... TArray) {
        if (iterable == null) {
            UsefulTestCase.a(21);
        }
        if (TArray == null) {
            UsefulTestCase.a(22);
        }
        UsefulTestCase.assertOrderedEquals(string, iterable, Arrays.asList(TArray));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2) {
        if (iterable == null) {
            UsefulTestCase.a(23);
        }
        if (iterable2 == null) {
            UsefulTestCase.a(24);
        }
        UsefulTestCase.assertOrderedEquals(null, iterable, iterable2);
    }

    public static <T> void assertOrderedEquals(String string, @NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2) {
        if (iterable == null) {
            UsefulTestCase.a(25);
        }
        if (iterable2 == null) {
            UsefulTestCase.a(26);
        }
        UsefulTestCase.assertOrderedEquals(string, iterable, iterable2, Equality.CANONICAL);
    }

    public static <T> void assertOrderedEquals(String string, @NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2, @NotNull Equality<? super T> equality) {
        if (iterable == null) {
            UsefulTestCase.a(27);
        }
        if (iterable2 == null) {
            UsefulTestCase.a(28);
        }
        if (equality == null) {
            UsefulTestCase.a(29);
        }
        if (!UsefulTestCase.a(iterable, iterable2, equality)) {
            String string2 = UsefulTestCase.toString(iterable2);
            String string3 = UsefulTestCase.toString(iterable);
            Assert.assertEquals((String)string, (Object)string2, (Object)string3);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + string2 + "\nActual: " + string3));
        }
    }

    private static <T> boolean a(@NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2, @NotNull Equality<? super T> equality) {
        if (iterable == null) {
            UsefulTestCase.a(30);
        }
        if (iterable2 == null) {
            UsefulTestCase.a(31);
        }
        if (equality == null) {
            UsefulTestCase.a(32);
        }
        Iterator<T> iterator = iterable.iterator();
        Iterator<T> iterator2 = iterable2.iterator();
        while (iterator.hasNext() || iterator2.hasNext()) {
            if (!iterator.hasNext() || !iterator2.hasNext()) {
                return false;
            }
            if (equality.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull T[] TArray, Consumer<T> ... consumerArray) {
        if (TArray == null) {
            UsefulTestCase.a(33);
        }
        if (consumerArray == null) {
            UsefulTestCase.a(34);
        }
        UsefulTestCase.assertOrderedCollection(Arrays.asList(TArray), consumerArray);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull T[] TArray, T ... TArray2) {
        if (TArray == null) {
            UsefulTestCase.a(35);
        }
        if (TArray2 == null) {
            UsefulTestCase.a(36);
        }
        UsefulTestCase.assertSameElements(Arrays.asList(TArray), TArray2);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> collection, T ... TArray) {
        if (collection == null) {
            UsefulTestCase.a(37);
        }
        if (TArray == null) {
            UsefulTestCase.a(38);
        }
        UsefulTestCase.assertSameElements(collection, Arrays.asList(TArray));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        if (collection == null) {
            UsefulTestCase.a(39);
        }
        if (collection2 == null) {
            UsefulTestCase.a(40);
        }
        UsefulTestCase.assertSameElements(null, collection, collection2);
    }

    public static <T> void assertSameElements(String string, @NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        if (collection == null) {
            UsefulTestCase.a(41);
        }
        if (collection2 == null) {
            UsefulTestCase.a(42);
        }
        if (collection.size() != collection2.size() || !new HashSet<T>(collection2).equals(new HashSet<T>(collection))) {
            Assert.assertEquals((String)string, (Object)UsefulTestCase.toString(collection2, "\n"), (Object)UsefulTestCase.toString(collection, "\n"));
            Assert.assertEquals((String)string, new HashSet<T>(collection2), new HashSet<T>(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... TArray) {
        if (collection == null) {
            UsefulTestCase.a(43);
        }
        if (TArray == null) {
            UsefulTestCase.a(44);
        }
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(TArray));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        if (collection == null) {
            UsefulTestCase.a(45);
        }
        if (collection2 == null) {
            UsefulTestCase.a(46);
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.retainAll(collection2);
        UsefulTestCase.assertOrderedEquals(UsefulTestCase.toString(collection), arrayList, collection2);
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... TArray) {
        if (collection == null) {
            UsefulTestCase.a(47);
        }
        if (TArray == null) {
            UsefulTestCase.a(48);
        }
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(TArray));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        if (collection == null) {
            UsefulTestCase.a(49);
        }
        if (collection2 == null) {
            UsefulTestCase.a(50);
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.retainAll(collection2);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), arrayList, collection2);
    }

    @NotNull
    public static String toString(@NotNull Object[] objectArray, @NotNull String string) {
        if (objectArray == null) {
            UsefulTestCase.a(51);
        }
        if (string == null) {
            UsefulTestCase.a(52);
        }
        String string2 = UsefulTestCase.toString(Arrays.asList(objectArray), string);
        if (string2 == null) {
            UsefulTestCase.a(53);
        }
        return string2;
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... TArray) {
        if (collection == null) {
            UsefulTestCase.a(54);
        }
        if (TArray == null) {
            UsefulTestCase.a(55);
        }
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(TArray));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<T> collection2) {
        if (collection == null) {
            UsefulTestCase.a(56);
        }
        if (collection2 == null) {
            UsefulTestCase.a(57);
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.removeAll(collection2);
        UsefulTestCase.assertSameElements(collection, arrayList);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String string) {
        if (collection == null) {
            UsefulTestCase.a(58);
        }
        if (string == null) {
            UsefulTestCase.a(59);
        }
        List list2 = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list2);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (String string2 : list2) {
            if (bl2) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
            bl2 = true;
        }
        String string3 = stringBuilder.toString();
        if (string3 == null) {
            UsefulTestCase.a(60);
        }
        return string3;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... consumerArray) {
        if (collection == null) {
            UsefulTestCase.a(61);
        }
        if (consumerArray == null) {
            UsefulTestCase.a(62);
        }
        if (collection.size() != consumerArray.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int n2 = 0;
        for (T t2 : collection) {
            try {
                consumerArray[n2].consume(t2);
            }
            catch (AssertionFailedError assertionFailedError) {
                System.out.println(n2 + ": " + t2);
                throw assertionFailedError;
            }
            ++n2;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull T[] TArray, Consumer<T> ... consumerArray) {
        if (TArray == null) {
            UsefulTestCase.a(63);
        }
        if (consumerArray == null) {
            UsefulTestCase.a(64);
        }
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(TArray), consumerArray);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... consumerArray) {
        if (collection == null) {
            UsefulTestCase.a(65);
        }
        if (consumerArray == null) {
            UsefulTestCase.a(66);
        }
        if (collection.size() != consumerArray.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        HashSet<Consumer<T>> hashSet = new HashSet<Consumer<T>>(Arrays.asList(consumerArray));
        int n2 = 0;
        Throwable throwable = null;
        for (T t2 : collection) {
            boolean bl2 = true;
            for (Consumer consumer : hashSet) {
                Throwable throwable2 = UsefulTestCase.a(consumer, t2);
                if (throwable2 == null) {
                    hashSet.remove(consumer);
                    bl2 = false;
                    break;
                }
                throwable = throwable2;
            }
            if (bl2) {
                throwable.printStackTrace();
                Assert.fail((String)("Incorrect element(" + n2 + "): " + t2));
            }
            ++n2;
        }
    }

    private static <T> Throwable a(@NotNull Consumer<T> consumer, T t2) {
        if (consumer == null) {
            UsefulTestCase.a(67);
        }
        try {
            consumer.consume(t2);
            return null;
        }
        catch (Throwable throwable) {
            return throwable;
        }
    }

    @Contract(value="null, _ -> fail")
    public static <T> T assertInstanceOf(Object object, @NotNull Class<T> clazz) {
        if (clazz == null) {
            UsefulTestCase.a(68);
        }
        Assert.assertNotNull((String)("Expected instance of: " + clazz.getName() + " actual: " + null), (Object)object);
        Assert.assertTrue((String)("Expected instance of: " + clazz.getName() + " actual: " + object.getClass().getName()), (boolean)clazz.isInstance(object));
        Object object2 = object;
        return (T)object2;
    }

    public static <T> T assertOneElement(@NotNull Collection<T> collection) {
        if (collection == null) {
            UsefulTestCase.a(69);
        }
        Iterator<T> iterator = collection.iterator();
        String string = UsefulTestCase.toString(collection);
        Assert.assertTrue((String)string, (boolean)iterator.hasNext());
        T t2 = iterator.next();
        Assert.assertFalse((String)string, (boolean)iterator.hasNext());
        return t2;
    }

    public static <T> T assertOneElement(@NotNull T[] TArray) {
        if (TArray == null) {
            UsefulTestCase.a(70);
        }
        Assert.assertEquals((String)Arrays.asList(TArray).toString(), (long)1L, (long)TArray.length);
        return TArray[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T t2, T ... TArray) {
        if (TArray == null) {
            UsefulTestCase.a(71);
        }
        boolean bl2 = false;
        for (T t3 : TArray) {
            if (t2 != t3 && (t2 == null || !t2.equals(t3))) continue;
            bl2 = true;
        }
        Assert.assertTrue((String)(t2 + " should be equal to one of " + Arrays.toString(TArray)), (boolean)bl2);
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
    }

    public static void assertEmpty(@NotNull Object[] objectArray) {
        if (objectArray == null) {
            UsefulTestCase.a(72);
        }
        UsefulTestCase.assertOrderedEquals(objectArray, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        if (collection == null) {
            UsefulTestCase.a(73);
        }
        UsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty(null, collection);
    }

    public static void assertEmpty(String string) {
        UsefulTestCase.assertTrue((String)string, (boolean)StringUtil.isEmpty((String)string));
    }

    public static <T> void assertEmpty(String string, Collection<T> collection) {
        UsefulTestCase.assertOrderedEquals(string, collection, Collections.emptyList());
    }

    public static void assertSize(int n2, Object[] objectArray) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(objectArray)), (int)n2, (int)objectArray.length);
    }

    public static void assertSize(int n2, Collection<?> collection) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(collection), (int)n2, (int)collection.size());
    }

    protected <T extends Disposable> T disposeOnTearDown(T t2) {
        Disposer.register((Disposable)this.getTestRootDisposable(), t2);
        return t2;
    }

    public static void assertSameLines(String string, String string2) {
        String string3 = StringUtil.convertLineSeparators((String)string.trim());
        String string4 = StringUtil.convertLineSeparators((String)string2.trim());
        Assert.assertEquals((Object)string3, (Object)string4);
    }

    public static void assertExists(@NotNull File file) {
        if (file == null) {
            UsefulTestCase.a(74);
        }
        UsefulTestCase.assertTrue((String)("File should exist " + file), (boolean)file.exists());
    }

    public static void assertDoesntExist(@NotNull File file) {
        if (file == null) {
            UsefulTestCase.a(75);
        }
        UsefulTestCase.assertFalse((String)("File should not exist " + file), (boolean)file.exists());
    }

    @NotNull
    protected String getTestName(boolean bl2) {
        String string = UsefulTestCase.getTestName(this.getName(), bl2);
        if (string == null) {
            UsefulTestCase.a(76);
        }
        return string;
    }

    @NotNull
    public static String getTestName(String string, boolean bl2) {
        String string2 = string == null ? "" : PlatformTestUtil.getTestName(string, bl2);
        if (string2 == null) {
            UsefulTestCase.a(77);
        }
        return string2;
    }

    protected String getTestDirectoryName() {
        String string = this.getTestName(true);
        return string.replaceAll("_.*", "");
    }

    public static void assertSameLinesWithFile(String string, String string2) {
        UsefulTestCase.assertSameLinesWithFile(string, string2, true);
    }

    public static void assertSameLinesWithFile(String string, String string2, boolean bl2) {
        String string3;
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(string, string2);
                System.out.println("File " + string + " created.");
            }
            string3 = FileUtil.loadFile((File)new File(string), (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (FileNotFoundException fileNotFoundException) {
            VfsTestUtil.overwriteTestData(string, string2);
            throw new AssertionFailedError("No output text found. File " + string + " created.");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        String string4 = StringUtil.convertLineSeparators((String)(bl2 ? string3.trim() : string3));
        String string5 = StringUtil.convertLineSeparators((String)(bl2 ? string2.trim() : string2));
        if (!Comparing.equal((String)string4, (String)string5)) {
            throw new FileComparisonFailure(null, string4, string5, string);
        }
    }

    protected static void clearFields(@NotNull Object object) throws IllegalAccessException {
        if (object == null) {
            UsefulTestCase.a(78);
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(object, clazz);
        }
    }

    public static void clearDeclaredFields(Object object, Class clazz) throws IllegalAccessException {
        if (clazz == null) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            int n2;
            String string = field.getDeclaringClass().getName();
            if (string.startsWith("junit.framework.") || string.startsWith("com.intellij.testFramework.") || ((n2 = field.getModifiers()) & 0x10) != 0 || (n2 & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(object, null);
        }
    }

    private static void a(CodeStyleSettings codeStyleSettings, CodeStyleSettings codeStyleSettings2) throws Exception {
        if (codeStyleSettings == null || codeStyleSettings2 == null) {
            return;
        }
        Element element = new Element("temp");
        codeStyleSettings.writeExternal(element);
        Element element2 = new Element("temp");
        codeStyleSettings2.writeExternal(element2);
        String string = JDOMUtil.writeElement((Element)element2);
        String string2 = JDOMUtil.writeElement((Element)element);
        Assert.assertEquals((String)"Code style settings damaged", (Object)string2, (Object)string);
    }

    public boolean isPerformanceTest() {
        String string = this.getName();
        String string2 = ((Object)((Object)this)).getClass().getName();
        return TestFrameworkUtil.isPerformanceTest((String)string, (String)string2);
    }

    public boolean isStressTest() {
        return UsefulTestCase.a(this.getName(), ((Object)((Object)this)).getClass().getName());
    }

    private static boolean a(String string, String string2) {
        return TestFrameworkUtil.isPerformanceTest((String)string, (String)string2) || UsefulTestCase.a(string) || UsefulTestCase.a(string2);
    }

    private static boolean a(@Nullable String string) {
        return string != null && (string.contains("Stress") || string.contains("Slow"));
    }

    public static void doPostponedFormatting(Project project2) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
        });
    }

    protected void assertException(AbstractExceptionCase abstractExceptionCase) throws Throwable {
        this.assertException(abstractExceptionCase, null);
    }

    protected void assertException(AbstractExceptionCase abstractExceptionCase, @Nullable String string) throws Throwable {
        UsefulTestCase.a(true, abstractExceptionCase, string);
    }

    public static <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> clazz, @NotNull ThrowableRunnable<T> throwableRunnable) throws T {
        if (clazz == null) {
            UsefulTestCase.a(79);
        }
        if (throwableRunnable == null) {
            UsefulTestCase.a(80);
        }
        UsefulTestCase.assertThrows(clazz, null, throwableRunnable);
    }

    public static <T extends Throwable> void assertThrows(final @NotNull Class<? extends Throwable> clazz, @Nullable String string, final @NotNull ThrowableRunnable<T> throwableRunnable) throws T {
        if (clazz == null) {
            UsefulTestCase.a(81);
        }
        if (throwableRunnable == null) {
            UsefulTestCase.a(82);
        }
        UsefulTestCase.a(true, new AbstractExceptionCase(){

            public Class<Throwable> getExpectedExceptionClass() {
                return clazz;
            }

            @Override
            public void tryClosure() throws Throwable {
                throwableRunnable.run();
            }
        }, string);
    }

    protected <T extends Throwable> void assertNoException(AbstractExceptionCase<T> abstractExceptionCase) throws T {
        UsefulTestCase.a(false, abstractExceptionCase, null);
    }

    protected void assertNoThrowable(Runnable runnable) {
        String string = null;
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            string = throwable.getClass().getName();
        }
        UsefulTestCase.assertNull(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Throwable> void a(boolean bl2, AbstractExceptionCase<T> abstractExceptionCase, String string) throws T {
        block9: {
            boolean bl3 = false;
            try {
                abstractExceptionCase.tryClosure();
            }
            catch (Throwable throwable) {
                if (bl2) {
                    bl3 = true;
                    String string2 = abstractExceptionCase.getAssertionErrorMessage();
                    UsefulTestCase.assertEquals((String)string2, abstractExceptionCase.getExpectedExceptionClass(), throwable.getClass());
                    if (string != null) {
                        UsefulTestCase.assertEquals((String)"Compare error messages", (String)string, (String)throwable.getMessage());
                    }
                    break block9;
                }
                if (abstractExceptionCase.getExpectedExceptionClass().equals(throwable.getClass())) {
                    bl3 = true;
                    System.out.println("");
                    throwable.printStackTrace(System.out);
                    UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + throwable.getMessage()));
                    break block9;
                }
                throw throwable;
            }
            finally {
                if (bl2 && !bl3) {
                    UsefulTestCase.fail((String)abstractExceptionCase.getAssertionErrorMessage());
                }
            }
        }
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> clazz) {
        if (clazz == null) {
            UsefulTestCase.a(83);
        }
        String string = "test" + this.getTestName(false);
        boolean bl2 = false;
        for (Class<?> clazz2 = ((Object)((Object)this)).getClass(); clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Method method;
            if (clazz2.getAnnotation(clazz) != null) {
                return true;
            }
            if (bl2 || (method = ReflectionUtil.getDeclaredMethod(clazz2, (String)string, (Class[])new Class[0])) == null) continue;
            if (method.getAnnotation(clazz) != null) {
                return true;
            }
            bl2 = true;
        }
        return false;
    }

    protected String getHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    public static void refreshRecursively(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            UsefulTestCase.a(84);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    2.a(0);
                }
                virtualFile.getChildren();
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/UsefulTestCase$2", "visitFile"));
            }
        });
        virtualFile.refresh(false, true);
    }

    @NotNull
    public static Test filteredSuite(@RegExp String string, @NotNull Test test) {
        if (test == null) {
            UsefulTestCase.a(85);
        }
        final Pattern pattern = Pattern.compile(string);
        final TestSuite testSuite = new TestSuite();
        new Processor<Test>(){

            public boolean process(Test test) {
                if (test instanceof TestSuite) {
                    int n2 = ((TestSuite)test).testCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        this.process(((TestSuite)test).testAt(i2));
                    }
                } else if (pattern.matcher(test.toString()).find()) {
                    testSuite.addTest(test);
                }
                return false;
            }
        }.process(test);
        TestSuite testSuite2 = testSuite;
        if (testSuite2 == null) {
            UsefulTestCase.a(86);
        }
        return testSuite2;
    }

    @Nullable
    public static VirtualFile refreshAndFindFile(@NotNull File file) {
        if (file == null) {
            UsefulTestCase.a(87);
        }
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (file == null) {
                UsefulTestCase.a(88);
            }
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        });
    }

    static {
        Object object;
        Object object2;
        IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
        OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
        h = FileUtil.getTempDirectory();
        c = new HashMap();
        j = new HashMap();
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
        Logger.setFactory(TestLoggerFactory.class);
        LOG = Logger.getInstance(UsefulTestCase.class);
        CREATION_PLACE = Key.create((String)"CREATION_PLACE");
        System.setProperty("apple.awt.UIElement", "true");
        try {
            object2 = new CodeInsightSettings();
            object = new Element("temp");
            object2.writeExternal(object);
            g = JDOMUtil.writeElement((Element)object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        try {
            object2 = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        object = (Set)ReflectionUtil.getStaticFieldValue((Class)object2, Set.class, (String)"files");
        a = object2;
        e = object;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSdks";
                break;
            }
            case 3: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCodeStyleSettings";
                break;
            }
            case 4: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCodeStyleSettings";
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/UsefulTestCase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 9: 
            case 11: 
            case 80: 
            case 82: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "costMap";
                break;
            }
            case 12: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 58: 
            case 61: 
            case 63: 
            case 65: 
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 34: 
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 52: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notExpected";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ts";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 78: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/UsefulTestCase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCodeStyleSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
            case 53: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredSuite";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTmpFileToKeep";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldKeepTmpFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdkTableLeaks";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCheckForSettingsDamage";
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeTestRunnable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logPerClassCost";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "edt";
                break;
            }
            case 12: 
            case 51: 
            case 52: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedEquals";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 33: 
            case 34: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedCollection";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "assertSameElements";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsOrdered";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsElements";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntContain";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "assertUnorderedCollection";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "assertInstanceOf";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "assertOneElement";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "assertOneOf";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "assertEmpty";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "assertExists";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntExist";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "clearFields";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "assertThrows";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "annotatedWith";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "refreshRecursively";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "filteredSuite";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFile";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshAndFindFile$14";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeTestRunnable$12";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCheckForSettingsDamage$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class TestDisposable
    implements Disposable {
        private volatile boolean a;

        public void dispose() {
            this.a = true;
        }

        public boolean isDisposed() {
            return this.a;
        }

        public String toString() {
            String string = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (StringUtil.isEmpty((String)string) ? "" : ".test" + string);
        }
    }
}

