/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.ConfigFileMetaDataRegistry;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl;
import com.intellij.util.descriptors.impl.ConfigFileMetaDataRegistryImpl;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class ConfigFileFactoryImpl
extends ConfigFileFactory {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.util.descriptors.impl.ConfigFileFactoryImpl");

    public ConfigFileMetaDataProvider createMetaDataProvider(ConfigFileMetaData ... configFileMetaDataArray) {
        return new ConfigFileMetaDataRegistryImpl(configFileMetaDataArray);
    }

    public ConfigFileMetaDataRegistry createMetaDataRegistry() {
        return new ConfigFileMetaDataRegistryImpl();
    }

    public ConfigFileInfoSet createConfigFileInfoSet(ConfigFileMetaDataProvider configFileMetaDataProvider) {
        return new ConfigFileInfoSetImpl(configFileMetaDataProvider);
    }

    public ConfigFileContainer createConfigFileContainer(Project project2, ConfigFileMetaDataProvider configFileMetaDataProvider, ConfigFileInfoSet configFileInfoSet) {
        return new ConfigFileContainerImpl(project2, configFileMetaDataProvider, (ConfigFileInfoSetImpl)configFileInfoSet);
    }

    private static String a(String string, @Nullable Project project2) throws IOException {
        FileTemplateManager fileTemplateManager = project2 == null ? FileTemplateManager.getDefaultInstance() : FileTemplateManager.getInstance((Project)project2);
        FileTemplate fileTemplate = fileTemplateManager.getJ2eeTemplate(string);
        if (fileTemplate == null) {
            return "";
        }
        return fileTemplate.getText(fileTemplateManager.getDefaultProperties());
    }

    @Nullable
    public VirtualFile createFile(@Nullable Project project2, String string, ConfigFileVersion configFileVersion, boolean bl2) {
        return this.a(project2, string, configFileVersion.getTemplateName(), bl2);
    }

    @Nullable
    private VirtualFile a(@Nullable Project project2, String string, String string2, boolean bl2) {
        File file;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile = localFileSystem.refreshAndFindFileByIoFile(file = new File(VfsUtilCore.urlToPath((String)string)));
        if (virtualFile != null) {
            virtualFile.refresh(false, false);
            if (!virtualFile.isValid()) {
                virtualFile = null;
            }
        }
        if (virtualFile != null && !bl2) {
            return virtualFile;
        }
        try {
            VirtualFile virtualFile2;
            String string3 = ConfigFileFactoryImpl.a(string2, project2);
            if (virtualFile == null || virtualFile.isDirectory()) {
                VirtualFile virtualFile3;
                if (!FileUtil.createParentDirs((File)file) || (virtualFile3 = localFileSystem.refreshAndFindFileByIoFile(file.getParentFile())) == null) {
                    throw new IOException(IdeBundle.message((String)"error.message.unable.to.create.file", (Object[])new Object[]{file.getPath()}));
                }
                virtualFile2 = virtualFile3.createChildData((Object)this, file.getName());
            } else {
                virtualFile2 = virtualFile;
            }
            VfsUtil.saveText((VirtualFile)virtualFile2, (String)string3);
            return virtualFile2;
        }
        catch (IOException iOException) {
            a.info((Throwable)iOException);
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)IdeBundle.message((String)"message.text.error.creating.deployment.descriptor", (Object[])new Object[]{iOException.getLocalizedMessage()}), (String)IdeBundle.message((String)"message.text.creating.deployment.descriptor", (Object[])new Object[0])));
            return null;
        }
    }

    public ConfigFileContainer createSingleFileContainer(Project project2, ConfigFileMetaData configFileMetaData) {
        ConfigFileMetaDataProvider configFileMetaDataProvider = this.createMetaDataProvider(configFileMetaData);
        return this.createConfigFileContainer(project2, configFileMetaDataProvider, this.createConfigFileInfoSet(configFileMetaDataProvider));
    }
}

