/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileInfoSetImpl
implements ConfigFileInfoSet {
    private static final Logger f = Logger.getInstance((String)"#com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl");
    @NonNls
    private static final String g = "deploymentDescriptor";
    @NonNls
    private static final String b = "name";
    @NonNls
    private static final String e = "url";
    private final MultiValuesMap<ConfigFileMetaData, ConfigFileInfo> c = new MultiValuesMap();
    @Nullable
    private ConfigFileContainerImpl d;
    private final ConfigFileMetaDataProvider a;

    public ConfigFileInfoSetImpl(ConfigFileMetaDataProvider configFileMetaDataProvider) {
        this.a = configFileMetaDataProvider;
    }

    public void addConfigFile(ConfigFileInfo configFileInfo) {
        this.c.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        this.a();
    }

    public void addConfigFile(ConfigFileMetaData configFileMetaData, String string) {
        this.addConfigFile(new ConfigFileInfo(configFileMetaData, string));
    }

    public void removeConfigFile(ConfigFileInfo configFileInfo) {
        this.c.remove((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        this.a();
    }

    public void replaceConfigFile(ConfigFileMetaData configFileMetaData, String string) {
        this.c.removeAll((Object)configFileMetaData);
        this.addConfigFile(new ConfigFileInfo(configFileMetaData, string));
    }

    public ConfigFileInfo updateConfigFile(ConfigFile configFile) {
        this.c.remove((Object)configFile.getMetaData(), (Object)configFile.getInfo());
        ConfigFileInfo configFileInfo = new ConfigFileInfo(configFile.getMetaData(), configFile.getUrl());
        this.c.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        ((ConfigFileImpl)configFile).setInfo(configFileInfo);
        return configFileInfo;
    }

    public void removeConfigFiles(ConfigFileMetaData ... configFileMetaDataArray) {
        for (ConfigFileMetaData configFileMetaData : configFileMetaDataArray) {
            this.c.removeAll((Object)configFileMetaData);
        }
        this.a();
    }

    @Nullable
    public ConfigFileInfo getConfigFileInfo(ConfigFileMetaData configFileMetaData) {
        Collection collection = this.c.get((Object)configFileMetaData);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return (ConfigFileInfo)collection.iterator().next();
    }

    public ConfigFileInfo[] getConfigFileInfos() {
        Collection collection = this.c.values();
        return collection.toArray(new ConfigFileInfo[0]);
    }

    public void setConfigFileInfos(Collection<ConfigFileInfo> collection) {
        this.c.clear();
        for (ConfigFileInfo configFileInfo : collection) {
            this.c.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        }
        this.a();
    }

    private void a() {
        if (this.d != null) {
            this.d.updateDescriptors(this.c);
        }
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.a;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.c.clear();
        List list2 = element.getChildren(g);
        for (Element element2 : list2) {
            ConfigFileMetaData configFileMetaData;
            String string = element2.getAttributeValue(b);
            if (string == null || (configFileMetaData = this.a.findMetaData(string)) == null) continue;
            String string2 = element2.getAttributeValue(e);
            if (string2 == null) {
                throw new InvalidDataException("url attribute not specified for " + string + " descriptor");
            }
            this.c.put((Object)configFileMetaData, (Object)new ConfigFileInfo(configFileMetaData, string2));
        }
        this.a();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeSet treeSet = new TreeSet((configFileInfo, configFileInfo2) -> {
            int n2 = Comparing.compare((Comparable)((Object)configFileInfo.getMetaData().getId()), (Comparable)((Object)configFileInfo2.getMetaData().getId()));
            return n2 != 0 ? n2 : Comparing.compare((Comparable)((Object)configFileInfo.getUrl()), (Comparable)((Object)configFileInfo2.getUrl()));
        });
        treeSet.addAll(this.c.values());
        for (ConfigFileInfo configFileInfo3 : treeSet) {
            Element element2 = new Element(g);
            ConfigFileMetaData configFileMetaData = configFileInfo3.getMetaData();
            element2.setAttribute(b, configFileMetaData.getId());
            element2.setAttribute(e, configFileInfo3.getUrl());
            element.addContent(element2);
        }
    }

    public void setContainer(@NotNull ConfigFileContainerImpl configFileContainerImpl) {
        if (configFileContainerImpl == null) {
            ConfigFileInfoSetImpl.a(0);
        }
        f.assertTrue(this.d == null);
        this.d = configFileContainerImpl;
        this.d.updateDescriptors(this.c);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/util/descriptors/impl/ConfigFileInfoSetImpl", "setContainer"));
    }
}

