/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeChildInvocationHandler
extends DomInvocationHandler<AttributeChildDescriptionImpl, AttributeStub> {
    private static final Logger n = Logger.getInstance((String)"#com.intellij.util.xml.impl.AttributeChildInvocationHandler");

    protected AttributeChildInvocationHandler(EvaluatedXmlName evaluatedXmlName, AttributeChildDescriptionImpl attributeChildDescriptionImpl, DomManagerImpl domManagerImpl, DomParentStrategy domParentStrategy, @Nullable AttributeStub attributeStub) {
        super(attributeChildDescriptionImpl.getType(), domParentStrategy, evaluatedXmlName, attributeChildDescriptionImpl, domManagerImpl, false, attributeStub);
    }

    @Override
    public void acceptChildren(DomElementVisitor domElementVisitor) {
    }

    @Override
    protected final XmlTag setEmptyXmlTag() {
        return this.ensureTagExists();
    }

    @Override
    protected boolean isAttribute() {
        return true;
    }

    @Override
    protected XmlElement recomputeXmlElement(@NotNull DomInvocationHandler domInvocationHandler) {
        if (domInvocationHandler == null) {
            AttributeChildInvocationHandler.b(0);
        }
        if (!domInvocationHandler.isValid()) {
            return null;
        }
        XmlTag xmlTag = domInvocationHandler.getXmlTag();
        if (xmlTag == null) {
            return null;
        }
        return xmlTag.getAttribute(this.getXmlElementName(), this.a(domInvocationHandler));
    }

    @Nullable
    private String a(DomInvocationHandler domInvocationHandler) {
        XmlTag xmlTag = domInvocationHandler.getXmlTag();
        if (xmlTag == null) {
            return null;
        }
        String string = this.getXmlName().getNamespace((XmlElement)xmlTag, domInvocationHandler.getFile());
        return xmlTag.getNamespace().equals(string) ? null : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XmlAttribute ensureXmlElementExists() {
        XmlAttribute xmlAttribute = (XmlAttribute)this.getXmlElement();
        if (xmlAttribute != null) {
            return xmlAttribute;
        }
        DomManagerImpl domManagerImpl = this.getManager();
        boolean bl2 = domManagerImpl.setChanging(true);
        try {
            xmlAttribute = this.ensureTagExists().setAttribute(this.getXmlElementName(), this.a(this.getParentHandler()), "");
            this.setXmlElement((XmlElement)xmlAttribute);
            this.getManager().cacheHandler(DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY, (XmlElement)xmlAttribute, this);
            DomElement domElement = this.getProxy();
            domManagerImpl.fireEvent(new DomEvent(domElement, true));
            XmlAttribute xmlAttribute2 = xmlAttribute;
            return xmlAttribute2;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            n.error((Throwable)incorrectOperationException);
            XmlAttribute xmlAttribute3 = null;
            return xmlAttribute3;
        }
        finally {
            domManagerImpl.setChanging(bl2);
        }
    }

    @Override
    public <T extends DomElement> T createStableCopy() {
        DomElement domElement = this.getParent().createStableCopy();
        return this.getManager().createStableValue(() -> domElement.isValid() ? ((AttributeChildDescriptionImpl)this.getChildDescription()).getValues(domElement).get(0) : null);
    }

    @Override
    public final void undefineInternal() {
        XmlTag xmlTag = this.getXmlTag();
        if (xmlTag != null) {
            this.getManager().runChange(() -> {
                try {
                    this.setXmlElement(null);
                    xmlTag.setAttribute(this.getXmlElementName(), this.a(this.getParentHandler()), null);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    n.error((Throwable)incorrectOperationException);
                }
            });
            this.fireUndefinedEvent();
        }
    }

    @Override
    @Nullable
    public final XmlTag getXmlTag() {
        DomInvocationHandler domInvocationHandler = this.getParentHandler();
        return domInvocationHandler == null ? null : domInvocationHandler.getXmlTag();
    }

    @Override
    public final XmlTag ensureTagExists() {
        DomInvocationHandler domInvocationHandler = this.getParentHandler();
        assert (domInvocationHandler != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        return domInvocationHandler.ensureTagExists();
    }

    @Override
    @Nullable
    protected String getValue() {
        XmlAttributeValue xmlAttributeValue;
        if (this.myStub != null) {
            return ((AttributeStub)this.myStub).getValue();
        }
        XmlAttribute xmlAttribute = (XmlAttribute)this.getXmlElement();
        if (xmlAttribute != null && (xmlAttributeValue = xmlAttribute.getValueElement()) != null && xmlAttributeValue.getTextLength() >= 2) {
            return xmlAttribute.getDisplayValue();
        }
        return null;
    }

    @Override
    protected void setValue(@Nullable String string) {
        String string2;
        String string3;
        String string4;
        XmlTag xmlTag = this.ensureTagExists();
        String string5 = StringUtil.unescapeXml((String)xmlTag.getAttributeValue(string4 = this.getXmlElementName(), string3 = this.a(this.getParentHandler())));
        if (Comparing.equal((String)string5, (String)(string2 = XmlStringUtil.escapeString((String)string)), (boolean)true)) {
            return;
        }
        this.getManager().runChange(() -> {
            try {
                XmlAttribute xmlAttribute = xmlTag.setAttribute(string4, string3, string2);
                this.setXmlElement((XmlElement)xmlAttribute);
                this.getManager().cacheHandler(DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY, (XmlElement)xmlAttribute, this);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                n.error((Throwable)incorrectOperationException);
            }
        });
        DomElement domElement = this.getProxy();
        this.getManager().fireEvent(string5 != null ? new DomEvent(domElement, false) : new DomEvent(domElement, true));
    }

    @Override
    public void copyFrom(DomElement domElement) {
        this.setValue(((GenericAttributeValue)domElement).getStringValue());
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/AttributeChildInvocationHandler", "recomputeXmlElement"));
    }
}

