/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.paths.PathReference;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ConcurrentInstanceMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.PathReferenceConverter;
import com.intellij.util.xml.converters.values.NumberValueConverter;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConverterManagerImpl
implements ConverterManager {
    private final ImplementationClassCache c = new ImplementationClassCache(DomImplementationClassEP.CONVERTER_EP_NAME);
    private final ConcurrentMap<Class, Object> a = ConcurrentFactoryMap.createMap(clazz -> {
        Class clazz2 = this.c.get((Class)clazz);
        return ConcurrentInstanceMap.calculate((Class)(clazz2 == null ? clazz : clazz2));
    });
    private final Map<Class, Converter> b = new HashMap<Class, Converter>();

    ConverterManagerImpl() {
        this.b.put(Byte.TYPE, (Converter)new NumberValueConverter(Byte.TYPE, false));
        this.b.put(Byte.class, (Converter)new NumberValueConverter(Byte.class, true));
        this.b.put(Short.TYPE, (Converter)new NumberValueConverter(Short.TYPE, false));
        this.b.put(Short.class, (Converter)new NumberValueConverter(Short.class, true));
        this.b.put(Integer.TYPE, (Converter)new NumberValueConverter(Integer.TYPE, false));
        this.b.put(Integer.class, (Converter)new NumberValueConverter(Integer.class, false));
        this.b.put(Long.TYPE, (Converter)new NumberValueConverter(Long.TYPE, false));
        this.b.put(Long.class, (Converter)new NumberValueConverter(Long.class, true));
        this.b.put(Float.TYPE, (Converter)new NumberValueConverter(Float.TYPE, false));
        this.b.put(Float.class, (Converter)new NumberValueConverter(Float.class, true));
        this.b.put(Double.TYPE, (Converter)new NumberValueConverter(Double.TYPE, false));
        this.b.put(Double.class, (Converter)new NumberValueConverter(Double.class, true));
        this.b.put(BigDecimal.class, (Converter)new NumberValueConverter(BigDecimal.class, true));
        this.b.put(BigInteger.class, (Converter)new NumberValueConverter(BigInteger.class, true));
        this.b.put(Boolean.TYPE, ResolvingConverter.BOOLEAN_CONVERTER);
        this.b.put(Boolean.class, ResolvingConverter.BOOLEAN_CONVERTER);
        this.b.put(String.class, Converter.EMPTY_CONVERTER);
        this.b.put(Object.class, Converter.EMPTY_CONVERTER);
        this.b.put(PathReference.class, PathReferenceConverter.INSTANCE);
    }

    public void addConverter(Class clazz, Converter converter) {
        this.b.put(clazz, converter);
    }

    @NotNull
    public final Converter getConverterInstance(Class<? extends Converter> clazz) {
        Converter converter = this.getInstance(clazz);
        assert (converter != null) : "Converter not found for " + clazz;
        Converter converter2 = converter;
        if (converter2 == null) {
            ConverterManagerImpl.a(0);
        }
        return converter2;
    }

    <T> T getInstance(Class<T> clazz) {
        return (T)this.a.get(clazz);
    }

    @Nullable
    public final Converter getConverterByClass(Class<?> clazz) {
        Converter converter = this.b.get(clazz);
        if (converter != null) {
            return converter;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return EnumConverter.createEnumConverter(clazz);
        }
        if (DomElement.class.isAssignableFrom(clazz)) {
            return DomResolveConverter.createConverter(clazz);
        }
        return null;
    }

    public <T extends Converter> void registerConverterImplementation(Class<T> clazz, T t2) {
        this.a.put(clazz, t2);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/ConverterManagerImpl", "getConverterInstance"));
    }
}

