/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.HyphenNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaNameStrategy;
import com.intellij.util.xml.NameStrategy;
import com.intellij.util.xml.NameStrategyForAttributes;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomImplUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomImplUtil");

    private DomImplUtil() {
    }

    public static void assertValidity(DomElement domElement, String string) {
        if (domElement instanceof DomFileElementImpl) {
            String string2 = ((DomFileElementImpl)domElement).checkValidity();
            if (string2 != null) {
                throw new AssertionError((Object)string2);
            }
            return;
        }
        DomInvocationHandler domInvocationHandler = DomManagerImpl.getDomInvocationHandler(domElement);
        assert (domInvocationHandler != null);
        try {
            domInvocationHandler.assertValid();
        }
        catch (AssertionError assertionError) {
            throw new AssertionError((Object)(string + ((Throwable)((Object)assertionError)).getMessage()));
        }
    }

    public static boolean isTagValueGetter(JavaMethod javaMethod) {
        if (!DomImplUtil.isGetter(javaMethod)) {
            return false;
        }
        if (DomImplUtil.a(javaMethod)) {
            return true;
        }
        if ("getValue".equals(javaMethod.getName())) {
            if (javaMethod.getAnnotation(SubTag.class) != null) {
                return false;
            }
            if (javaMethod.getAnnotation(SubTagList.class) != null) {
                return false;
            }
            if (javaMethod.getAnnotation(Convert.class) != null || javaMethod.getAnnotation(Resolve.class) != null) {
                return !ReflectionUtil.isAssignable(GenericDomValue.class, (Class)javaMethod.getReturnType());
            }
            return !ReflectionUtil.isAssignable(DomElement.class, (Class)javaMethod.getReturnType());
        }
        return false;
    }

    private static boolean a(JavaMethod javaMethod) {
        return javaMethod.getAnnotation(TagValue.class) != null;
    }

    public static boolean isGetter(JavaMethod javaMethod) {
        boolean bl2;
        String string = javaMethod.getName();
        boolean bl3 = string.startsWith("get");
        boolean bl4 = bl2 = !bl3 && string.startsWith("is");
        if (!bl3 && !bl2) {
            return false;
        }
        if (javaMethod.getGenericParameterTypes().length != 0) {
            return false;
        }
        Type type = javaMethod.getGenericReturnType();
        if (bl3) {
            return type != Void.TYPE;
        }
        return DomReflectionUtil.canHaveIsPropertyGetterPrefix((Type)type);
    }

    public static boolean isTagValueSetter(JavaMethod javaMethod) {
        boolean bl2 = javaMethod.getName().startsWith("set") && javaMethod.getGenericParameterTypes().length == 1 && javaMethod.getReturnType() == Void.TYPE;
        return bl2 && (DomImplUtil.a(javaMethod) || "setValue".equals(javaMethod.getName()));
    }

    @Nullable
    public static DomNameStrategy getDomNameStrategy(Class<?> clazz, boolean bl2) {
        NameStrategyForAttributes nameStrategyForAttributes;
        Class clazz2 = null;
        if (bl2 && (nameStrategyForAttributes = (NameStrategyForAttributes)DomReflectionUtil.findAnnotationDFS(clazz, NameStrategyForAttributes.class)) != null) {
            clazz2 = nameStrategyForAttributes.value();
        }
        if (clazz2 == null && (nameStrategyForAttributes = (NameStrategy)DomReflectionUtil.findAnnotationDFS(clazz, NameStrategy.class)) != null) {
            clazz2 = nameStrategyForAttributes.value();
        }
        if (clazz2 != null) {
            if (HyphenNameStrategy.class.equals(clazz2)) {
                return DomNameStrategy.HYPHEN_STRATEGY;
            }
            if (JavaNameStrategy.class.equals((Object)clazz2)) {
                return DomNameStrategy.JAVA_STRATEGY;
            }
            try {
                return (DomNameStrategy)clazz2.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                a.error((Throwable)reflectiveOperationException);
            }
        }
        return null;
    }

    public static List<XmlTag> findSubTags(@NotNull XmlTag xmlTag, EvaluatedXmlName evaluatedXmlName, XmlFile xmlFile) {
        if (xmlTag == null) {
            DomImplUtil.a(0);
        }
        if (!xmlTag.isValid()) {
            throw new AssertionError((Object)"Invalid tag");
        }
        Object[] objectArray = xmlTag.getSubTags();
        if (objectArray.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])objectArray, xmlTag2 -> {
            if (xmlTag == null) {
                DomImplUtil.a(5);
            }
            try {
                return DomImplUtil.isNameSuitable(evaluatedXmlName, xmlTag2.getLocalName(), xmlTag2.getName(), xmlTag2.getNamespace(), xmlFile);
            }
            catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                if (!xmlTag2.isValid()) {
                    a.error("tag.getSubTags() returned invalid, tag=" + xmlTag + ", containing file: " + xmlTag.getContainingFile() + "subTag.parent=" + xmlTag2.getNode().getTreeParent());
                    return false;
                }
                throw psiInvalidElementAccessException;
            }
        });
    }

    public static List<XmlTag> findSubTags(XmlTag[] xmlTagArray, EvaluatedXmlName evaluatedXmlName, XmlFile xmlFile) {
        if (xmlTagArray.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])xmlTagArray, xmlTag -> DomImplUtil.a(evaluatedXmlName, xmlTag, xmlFile));
    }

    public static boolean isNameSuitable(XmlName xmlName, XmlTag xmlTag, @NotNull DomInvocationHandler domInvocationHandler, XmlFile xmlFile) {
        if (domInvocationHandler == null) {
            DomImplUtil.a(1);
        }
        return DomImplUtil.a(domInvocationHandler.createEvaluatedXmlName(xmlName), xmlTag, xmlFile);
    }

    private static boolean a(EvaluatedXmlName evaluatedXmlName, XmlTag xmlTag, XmlFile xmlFile) {
        return DomImplUtil.isNameSuitable(evaluatedXmlName, xmlTag.getLocalName(), xmlTag.getName(), xmlTag.getNamespace(), xmlFile);
    }

    public static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, String string, String string2, String string3, XmlFile xmlFile) {
        String string4 = evaluatedXmlName.getXmlName().getLocalName();
        return (string4.equals(string) || string4.equals(string2)) && evaluatedXmlName.isNamespaceAllowed(string3, xmlFile, !string4.equals(string2));
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String string, Type type, @Nullable JavaMethod javaMethod) {
        Class<?> clazz;
        if (string == null) {
            DomImplUtil.a(2);
        }
        if ((clazz = DomImplUtil.a(type)) == null) {
            return null;
        }
        String string2 = DomImplUtil.a(clazz);
        if (string2 == null && javaMethod != null) {
            for (Method method : javaMethod.getHierarchy()) {
                String string3 = DomImplUtil.a(method.getDeclaringClass());
                if (string3 == null) continue;
                return new XmlName(string, string3);
            }
        }
        return new XmlName(string, string2);
    }

    @Nullable
    private static Class<?> a(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DomImplUtil.a(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            for (Type type2 : ((TypeVariable)type).getBounds()) {
                Class<?> type3 = DomImplUtil.a(type2);
                if (type3 == null) continue;
                return type3;
            }
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type type2 : wildcardType.getUpperBounds()) {
                Class<?> clazz = DomImplUtil.a(type2);
                if (clazz == null) continue;
                return clazz;
            }
        }
        return null;
    }

    @Nullable
    private static String a(@NotNull Class<?> clazz) {
        Namespace namespace;
        if (clazz == null) {
            DomImplUtil.a(3);
        }
        return (namespace = (Namespace)DomReflectionUtil.findAnnotationDFS(clazz, Namespace.class)) != null ? namespace.value() : null;
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String string, JavaMethod javaMethod) {
        if (string == null) {
            DomImplUtil.a(4);
        }
        return DomImplUtil.createXmlName(string, javaMethod.getGenericReturnType(), javaMethod);
    }

    public static List<XmlTag> getCustomSubTags(DomInvocationHandler domInvocationHandler, XmlTag[] xmlTagArray, XmlFile xmlFile) {
        if (xmlTagArray.length == 0) {
            return Collections.emptyList();
        }
        DomGenericInfoEx domGenericInfoEx = domInvocationHandler.getGenericInfo();
        THashSet tHashSet = new THashSet();
        List list2 = domGenericInfoEx.getCollectionChildrenDescriptions();
        int n2 = list2.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DomCollectionChildDescription domCollectionChildDescription = (DomCollectionChildDescription)list2.get(i2);
            tHashSet.add(domCollectionChildDescription.getXmlName());
        }
        List list3 = domGenericInfoEx.getFixedChildrenDescriptions();
        int n3 = list3.size();
        for (n2 = 0; n2 < n3; ++n2) {
            DomFixedChildDescription domFixedChildDescription = (DomFixedChildDescription)list3.get(n2);
            tHashSet.add(domFixedChildDescription.getXmlName());
        }
        return ContainerUtil.findAll((Object[])xmlTagArray, arg_0 -> DomImplUtil.a((Set)tHashSet, domInvocationHandler, xmlFile, arg_0));
    }

    static XmlFile getFile(DomElement domElement) {
        if (domElement instanceof DomFileElement) {
            return ((DomFileElement)domElement).getFile();
        }
        DomInvocationHandler domInvocationHandler = DomManagerImpl.getDomInvocationHandler(domElement);
        assert (domInvocationHandler != null) : domElement;
        while (!(domInvocationHandler instanceof DomRootInvocationHandler)) {
            XmlTag xmlTag = domInvocationHandler.getXmlTag();
            if (xmlTag != null) {
                return DomImplUtil.a(xmlTag);
            }
            DomInvocationHandler domInvocationHandler2 = domInvocationHandler.getParentHandler();
            if (domInvocationHandler2 == null) {
                throw new AssertionError((Object)("No parent for " + domInvocationHandler.toStringEx()));
            }
            domInvocationHandler = domInvocationHandler2;
        }
        return ((DomRootInvocationHandler)domInvocationHandler).getParent().getFile();
    }

    private static XmlFile a(XmlTag xmlTag) {
        PsiElement psiElement;
        while ((psiElement = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)xmlTag)) instanceof XmlTag) {
            xmlTag = (XmlTag)psiElement;
        }
        return (XmlFile)xmlTag.getContainingFile();
    }

    private static /* synthetic */ boolean a(Set set, DomInvocationHandler domInvocationHandler, XmlFile xmlFile, XmlTag xmlTag) {
        if (StringUtil.isEmpty((String)xmlTag.getName())) {
            return false;
        }
        for (XmlName xmlName : set) {
            if (!DomImplUtil.isNameSuitable(xmlName, xmlTag, domInvocationHandler, xmlFile)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/impl/DomImplUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSubTags";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNameSuitable";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createXmlName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamespaceKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findSubTags$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

