/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.Invocation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class InvocationCache {
    private static final Map<JavaMethodSignature, Invocation> g = new HashMap<JavaMethodSignature, Invocation>();
    private final Map<Method, Invocation> f = ConcurrentFactoryMap.createMap(method -> g.get(new JavaMethodSignature(method)));
    private final Map<Method, JavaMethod> b;
    private final Map<JavaMethod, Boolean> a = ConcurrentFactoryMap.createMap(javaMethod -> DomImplUtil.isTagValueGetter(javaMethod));
    private final Map<JavaMethod, Boolean> e = ConcurrentFactoryMap.createMap(javaMethod -> DomImplUtil.isTagValueSetter(javaMethod));
    private final Map<JavaMethod, Map<Class, Object>> h = ConcurrentFactoryMap.createMap(javaMethod -> ConcurrentFactoryMap.createMap(clazz -> javaMethod.getAnnotation(clazz)));
    private final Map<Class, Object> d;
    private final Class c;

    private static void b(Class<?> clazz) {
        for (final Method method : ReflectionUtil.getClassDeclaredMethods(clazz)) {
            if ("equals".equals(method.getName())) {
                g.put(new JavaMethodSignature(method), new Invocation(){

                    @Override
                    public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                        Object object;
                        DomElement domElement = domInvocationHandler.getProxy();
                        if (domElement == (object = objectArray[0])) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (object instanceof DomElement) {
                            DomInvocationHandler domInvocationHandler2 = DomManagerImpl.getDomInvocationHandler(domElement);
                            return domInvocationHandler2 != null && domInvocationHandler2.equals((Object)DomManagerImpl.getDomInvocationHandler((DomElement)object));
                        }
                        return false;
                    }
                });
                continue;
            }
            if ("hashCode".equals(method.getName())) {
                g.put(new JavaMethodSignature(method), new Invocation(){

                    @Override
                    public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                        return domInvocationHandler.hashCode();
                    }
                });
                continue;
            }
            g.put(new JavaMethodSignature(method), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                    return method.invoke((Object)domInvocationHandler, objectArray);
                }
            });
        }
    }

    public InvocationCache(Class clazz2) {
        this.c = clazz2;
        this.b = ConcurrentFactoryMap.createMap(method -> JavaMethod.getMethod((Class)this.c, (Method)method));
        this.d = ConcurrentFactoryMap.createMap(clazz -> this.c.getAnnotation(clazz));
    }

    @Nullable
    public Invocation getInvocation(Method method) {
        return this.f.get(method);
    }

    public JavaMethod getInternedMethod(Method method) {
        return this.b.get(method);
    }

    public void putInvocation(Method method, Invocation invocation) {
        this.f.put(method, invocation);
    }

    public boolean isTagValueGetter(JavaMethod javaMethod) {
        return this.a.get(javaMethod);
    }

    public boolean isTagValueSetter(JavaMethod javaMethod) {
        return this.e.get(javaMethod);
    }

    @Nullable
    public <T extends Annotation> T getMethodAnnotation(JavaMethod javaMethod, Class<T> clazz) {
        return (T)((Annotation)this.h.get(javaMethod).get(clazz));
    }

    @Nullable
    public <T extends Annotation> T getClassAnnotation(Class<T> clazz) {
        return (T)((Annotation)this.d.get(clazz));
    }

    static {
        InvocationCache.b(DomElement.class);
        InvocationCache.b(Navigatable.class);
        InvocationCache.b(AnnotatedElement.class);
        InvocationCache.b(Object.class);
        g.put(new JavaMethodSignature("getUserData", new Class[]{Key.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getUserData((Key)objectArray[0]);
            }
        });
        g.put(new JavaMethodSignature("putUserData", new Class[]{Key.class, Object.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                domInvocationHandler.putUserData((Key)objectArray[0], objectArray[1]);
                return null;
            }
        });
        g.put(new JavaMethodSignature("getXmlElement", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getXmlElement();
            }
        });
        g.put(new JavaMethodSignature("getXmlTag", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getXmlTag();
            }
        });
        g.put(new JavaMethodSignature("getParent", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getParent();
            }
        });
        g.put(new JavaMethodSignature("accept", new Class[]{DomElementVisitor.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                domInvocationHandler.accept((DomElementVisitor)objectArray[0]);
                return null;
            }
        });
        g.put(new JavaMethodSignature("acceptChildren", new Class[]{DomElementVisitor.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                domInvocationHandler.acceptChildren((DomElementVisitor)objectArray[0]);
                return null;
            }
        });
        g.put(new JavaMethodSignature("getAnnotation", new Class[]{Class.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getAnnotation((Class)objectArray[0]);
            }
        });
        g.put(new JavaMethodSignature("getRawText", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getValue();
            }
        });
        g.put(new JavaMethodSignature("getXmlAttribute", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getXmlElement();
            }
        });
        g.put(new JavaMethodSignature("getXmlAttributeValue", new Class[0]), new Invocation(){

            @Override
            @Nullable
            public final Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                XmlAttribute xmlAttribute = (XmlAttribute)domInvocationHandler.getXmlElement();
                return xmlAttribute != null ? xmlAttribute.getValueElement() : null;
            }
        });
        g.put(new JavaMethodSignature("getConverter", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                try {
                    return domInvocationHandler.getScalarConverter();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable.getCause();
                    if (throwable2 instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)throwable2;
                    }
                    throw new RuntimeException(throwable);
                }
            }
        });
    }
}

