/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommentLineData {
    protected String line;
    int commentOffset;
    int textStartOffset;
    boolean startsWithLetter;
    private final List<TextRange> a;

    public CommentLineData(@NotNull String string) {
        if (string == null) {
            CommentLineData.c(0);
        }
        this.commentOffset = -1;
        this.textStartOffset = -1;
        this.startsWithLetter = false;
        this.a = new ArrayList<TextRange>();
        this.line = string;
    }

    public void addUnbreakableRange(@NotNull TextRange textRange) {
        if (textRange == null) {
            CommentLineData.c(1);
        }
        this.a.add(textRange);
    }

    protected int calcWrapPos(int n2) {
        if (!this.hasText()) {
            return -1;
        }
        int n3 = this.a(n2);
        String string = this.line.substring(0, n3);
        int n4 = string.lastIndexOf(32);
        if (n4 < this.textStartOffset && (n4 = this.line.indexOf(32, this.textStartOffset)) != this.b(n4)) {
            return -1;
        }
        return n4;
    }

    public boolean hasText() {
        return this.textStartOffset > this.commentOffset;
    }

    public boolean canBeMergedWithPrevious() {
        return this.hasText() && this.startsWithLetter;
    }

    @NotNull
    public String getText() {
        if (this.hasText()) {
            String string = this.line.substring(this.textStartOffset);
            if (string == null) {
                CommentLineData.c(2);
            }
            return string;
        }
        if ("" == null) {
            CommentLineData.c(3);
        }
        return "";
    }

    public void merge(@NotNull CommentLineData commentLineData) {
        if (commentLineData == null) {
            CommentLineData.c(4);
        }
        for (TextRange textRange : commentLineData.a) {
            this.a.add(textRange.shiftRight(this.line.length() + 1));
        }
        this.line = this.line + " " + commentLineData.getText();
    }

    public int getLineLength() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.line.length(); ++i2) {
            char c2 = this.line.charAt(i2);
            n2 = this.a(n2, c2);
        }
        return n2;
    }

    @Nullable
    public Pair<String, String> splitLine(int n2) {
        int n3 = this.calcWrapPos(n2);
        if (n3 >= 0) {
            return new Pair((Object)this.line.substring(0, n3), (Object)this.line.substring(n3));
        }
        return null;
    }

    @NotNull
    public String getLine() {
        String string = this.line;
        if (string == null) {
            CommentLineData.c(5);
        }
        return string;
    }

    public boolean isTagLine() {
        return false;
    }

    public void setTagLine(boolean bl2) {
    }

    @NotNull
    public String getLinePrefix() {
        if ("" == null) {
            CommentLineData.c(6);
        }
        return "";
    }

    protected abstract int getTabSize();

    private int a(int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (n4 < this.line.length()) {
                char c2 = this.line.charAt(n4);
                if ((n3 = this.a(n3, c2)) > n2) break;
                ++n4;
                continue;
            }
            --n4;
            break;
        }
        return this.b(n4);
    }

    private int b(int n2) {
        for (TextRange textRange : this.a) {
            if (!textRange.contains(n2)) continue;
            return textRange.getStartOffset();
        }
        return n2;
    }

    private int a(int n2, char c2) {
        return n2 + (c2 == '\t' ? this.getTabSize() : 1);
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/CommentLineData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/CommentLineData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinePrefix";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addUnbreakableRange";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

