/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.util;

import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineUtil {
    private static final Logger a = Logger.getInstance(CommandLineUtil.class);

    private CommandLineUtil() {
    }

    public static void configureShellEnvironment(@NotNull GeneralCommandLine generalCommandLine, boolean bl2, @NotNull Map<String, String> map) {
        if (generalCommandLine == null) {
            CommandLineUtil.a(0);
        }
        if (map == null) {
            CommandLineUtil.a(1);
        }
        generalCommandLine.withParentEnvironmentType(bl2 ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        generalCommandLine.withEnvironment(map);
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((GeneralCommandLine)generalCommandLine);
    }

    public static void setWorkingDirectory(@NotNull GeneralCommandLine generalCommandLine, @Nullable File file, boolean bl2) {
        if (generalCommandLine == null) {
            CommandLineUtil.a(2);
        }
        if (file != null && file.isDirectory()) {
            if (SystemInfo.isWindows && bl2) {
                String string = file.getAbsolutePath();
                file = new File(PathUtil.driveLetterToLowerCase((String)string));
            }
            generalCommandLine.withWorkDirectory(file);
        } else if (file != null) {
            a.warn("Cannot set working directory: " + file.getAbsolutePath() + " is not a directory");
        } else {
            a.warn("Cannot set working directory: no working directory specified");
        }
    }

    public static void setWorkingDirectoryAndPWD(@NotNull GeneralCommandLine generalCommandLine, @NotNull String string) {
        if (generalCommandLine == null) {
            CommandLineUtil.a(3);
        }
        if (string == null) {
            CommandLineUtil.a(4);
        }
        CommandLineUtil.setWorkingDirectoryAndPwd(generalCommandLine, string);
    }

    public static void setWorkingDirectoryAndPwd(@NotNull GeneralCommandLine generalCommandLine, @NotNull String string) {
        if (generalCommandLine == null) {
            CommandLineUtil.a(5);
        }
        if (string == null) {
            CommandLineUtil.a(6);
        }
        String string2 = FileUtil.toSystemDependentName((String)string);
        generalCommandLine.withWorkDirectory(string2);
        if (SystemInfo.isUnix) {
            String string3 = "PWD";
            Map map = generalCommandLine.getEnvironment();
            if (!map.containsKey(string3)) {
                map.put(string3, string2);
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userEnvironment";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/util/CommandLineUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureShellEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setWorkingDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setWorkingDirectoryAndPWD";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setWorkingDirectoryAndPwd";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

