/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.addproperty;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.rpp.RefactorJConfig;
import com.sixrr.rpp.utils.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class AddPropertyDialog
extends RefactoringDialog {
    private JCheckBox f;
    private JCheckBox h;
    private JCheckBox b;
    private JCheckBox g;
    private JTextField a;
    private JTextField e;
    private JTextField c;
    private final PsiClass d;

    AddPropertyDialog(PsiClass psiClass) {
        super(psiClass.getProject(), true);
        this.setModal(true);
        this.d = psiClass;
        this.setTitle(RefactorJBundle.message((String)"add.property", (Object[])new Object[0]));
        this.init();
        RefactorJConfig refactorJConfig = RefactorJConfig.getInstance();
        this.f.setSelected(refactorJConfig.ADD_PROPERTY_ADD_SETTER);
        this.h.setSelected(refactorJConfig.ADD_PROPERTY_ADD_GETTER);
        this.g.setSelected(refactorJConfig.ADD_PROPERTY_ADD_TO_CONSTRUCTOR);
        this.b.setSelected(false);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPropertyDialog.this.validateButtons();
            }
        });
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                AddPropertyDialog.this.validateButtons();
            }
        };
        this.a.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.e.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.c.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.validateButtons();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.AddProperty";
    }

    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel();
        String string = RefactorJBundle.message((String)"add.property.dialog.title", (Object[])new Object[]{this.d.getName()});
        IdeaTitledBorder ideaTitledBorder = IdeBorderFactory.createTitledBorder((String)string, (boolean)true);
        jPanel.setBorder((Border)ideaTitledBorder);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"property.name.field.label", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.a = new JTextField(30);
        jPanel.add((Component)this.a, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"property.type.field.label", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.e = new JTextField(30);
        jPanel.add((Component)this.e, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.h = new JCheckBox(RefactorJBundle.message((String)"create.property.getter.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.h, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.f = new JCheckBox(RefactorJBundle.message((String)"create.property.setter.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.f, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.g = new JCheckBox(RefactorJBundle.message((String)"add.property.to.constructors.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.g, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.b = new JCheckBox(RefactorJBundle.message((String)"make.property.final.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.b, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"initialization.expression.checkbox", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.c = new JTextField(30);
        jPanel.add((Component)this.c, gridBagConstraints);
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.a;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.addProperty");
    }

    protected void doAction() {
    }

    protected boolean areButtonsValid() {
        return this.b() && this.a() && this.c();
    }

    private boolean b() {
        String string = this.getInitializationExpression();
        if (string.length() == 0) {
            return true;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.d.getManager().getProject()).getElementFactory();
        try {
            psiElementFactory.createExpressionFromText(string, (PsiElement)this.d);
            return true;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return false;
        }
    }

    private boolean c() {
        String string = this.getFieldType();
        if (string.length() == 0) {
            return false;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.d.getManager().getProject()).getElementFactory();
        try {
            psiElementFactory.createTypeFromText(string, (PsiElement)this.d);
            return true;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return false;
        }
    }

    private boolean a() {
        String string = this.getFieldName();
        if (string.length() == 0) {
            return false;
        }
        if (StringUtils.isKeyword(string)) {
            return false;
        }
        return string.matches("[a-zA-Z0-9_]*");
    }

    protected void validateButtons() {
        if (this.b()) {
            this.c.setForeground(JBColor.foreground());
        } else {
            this.c.setForeground((Color)JBColor.RED);
        }
        if (this.a()) {
            this.a.setForeground(JBColor.foreground());
        } else {
            this.a.setForeground((Color)JBColor.RED);
        }
        if (this.c()) {
            this.e.setForeground(JBColor.foreground());
        } else {
            this.e.setForeground((Color)JBColor.RED);
        }
        this.b.setEnabled(!this.f.isSelected());
        super.validateButtons();
    }

    public boolean getAddSetter() {
        return this.f.isSelected();
    }

    public boolean getAddGetter() {
        return this.h.isSelected();
    }

    public String getInitializationExpression() {
        return this.c.getText();
    }

    public String getFieldName() {
        return this.a.getText().trim();
    }

    public String getFieldType() {
        return this.e.getText().trim();
    }

    public boolean getAddToConstructor() {
        return this.g.isSelected();
    }

    public boolean getMakeFinal() {
        return this.b.isSelected() && !this.f.isSelected();
    }
}

