/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.pushjavadocdown;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.psi.SearchUtils;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.sixrr.rpp.RefactorJConfig;
import com.sixrr.rpp.utils.JavadocUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PushJavadocDownDialog
extends RefactoringDialog
implements MemberInfoChangeListener<PsiMember, MemberInfo> {
    private final PsiClass c;
    private final List<MemberInfo> e;
    private final JTextField b;
    private final JCheckBox a;
    private final JCheckBox d;

    PushJavadocDownDialog(PsiClass psiClass, PsiMethod psiMethod) {
        super(psiClass.getProject(), true);
        this.setModal(true);
        this.setTitle(RefactorJBundle.message((String)"push.javadoc.down.title", (Object[])new Object[0]));
        this.c = psiClass;
        this.b = new JTextField();
        this.a = new JCheckBox(RefactorJBundle.message((String)"replace.existing.comments.checkbox", (Object[])new Object[0]));
        this.d = new JCheckBox(RefactorJBundle.message((String)"use.inheritdoc.comments", (Object[])new Object[0]));
        MemberInfoBase.Filter<PsiMember> filter = new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember psiMember) {
                if (psiMember instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)psiMember;
                    if (psiMethod.isConstructor()) {
                        return false;
                    }
                    if (!JavadocUtils.hasJavadoc(psiMethod)) {
                        return false;
                    }
                    Iterable iterable = SearchUtils.findOverridingMethods((PsiMethod)psiMethod);
                    return iterable.iterator().hasNext();
                }
                return false;
            }
        };
        this.e = MemberInfo.extractClassMembers((PsiClass)this.c, (MemberInfoBase.Filter)filter, (boolean)true);
        for (MemberInfo memberInfo : this.e) {
            if (!((PsiMember)memberInfo.getMember()).equals(psiMethod)) continue;
            memberInfo.setChecked(true);
        }
        super.init();
        RefactorJConfig refactorJConfig = RefactorJConfig.getInstance();
        this.a.setSelected(refactorJConfig.PUSH_JAVADOC_DOWN_REPLACE_EXISTING_JAVADOC);
        this.d.setSelected(refactorJConfig.PUSH_JAVADOC_DOWN_ADD_INHERITDOC);
        this.validateButtons();
    }

    protected void doAction() {
    }

    protected boolean areButtonsValid() {
        List<PsiMethod> list2 = this.getMethodsToPushDown();
        return !list2.isEmpty();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.PushJavadocDown";
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        this.b.setEditable(false);
        this.b.setText(this.c.getQualifiedName());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"push.javadoc.down.from.label", (Object[])new Object[0])), "North");
        jPanel.add((Component)this.b, "Center");
        box.add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)box, "Center");
        return jPanel2;
    }

    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactorJBundle.message((String)"methods.to.copy.javadoc.from", (Object[])new Object[0]), this.e, null);
        MemberSelectionTable memberSelectionTable = memberSelectionPanel.getTable();
        memberSelectionTable.setMemberInfoModel((MemberInfoModel)new DelegatingMemberInfoModel<PsiMember, MemberInfo>(memberSelectionTable.getMemberInfoModel()){

            public Boolean isFixedAbstract(MemberInfo memberInfo) {
                return Boolean.TRUE;
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)memberSelectionPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.a, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.d, gridBagConstraints);
        memberSelectionTable.addMemberInfoChangeListener((MemberInfoChangeListener)this);
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.a;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.pushJavadocDown");
    }

    public void memberInfoChanged(MemberInfoChange memberInfoChange) {
        this.validateButtons();
    }

    public List<PsiMethod> getMethodsToPushDown() {
        ArrayList<PsiMethod> arrayList = new ArrayList<PsiMethod>();
        for (MemberInfo memberInfo : this.e) {
            if (!memberInfo.isChecked()) continue;
            PsiMember psiMember = (PsiMember)memberInfo.getMember();
            arrayList.add((PsiMethod)psiMember);
        }
        return arrayList;
    }

    public boolean getReplaceExistingComments() {
        return this.a.isSelected();
    }

    public boolean getCreateInheritDoc() {
        return this.d.isSelected();
    }
}

