/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.IncorrectOperationException;

public class PsiUtils {
    private static final Logger a = Logger.getInstance((String)PsiUtils.class.getName());

    private PsiUtils() {
    }

    public static void addMethodToClass(PsiClass psiClass, String string, PsiElement psiElement) {
        try {
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)psiClass.getProject());
            PsiElementFactory psiElementFactory = javaPsiFacade.getElementFactory();
            PsiMethod psiMethod = psiElementFactory.createMethodFromText(string, (PsiElement)psiClass);
            PsiElement psiElement2 = psiElement != null ? psiClass.addBefore((PsiElement)psiMethod, psiElement) : psiClass.add((PsiElement)psiMethod);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)psiClass.getProject());
            javaCodeStyleManager.shortenClassReferences(psiElement2);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            a.error((Throwable)incorrectOperationException);
        }
    }

    public static void reformatClass(PsiClass psiClass) {
        try {
            PsiManager psiManager = psiClass.getManager();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)psiManager.getProject());
            codeStyleManager.reformat((PsiElement)psiClass);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            a.error((Throwable)incorrectOperationException);
        }
    }

    public static String stripFieldName(PsiField psiField) {
        String string = psiField.getName();
        Project project2 = psiField.getProject();
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)project2);
        JavaCodeStyleSettings javaCodeStyleSettings = (JavaCodeStyleSettings)codeStyleSettingsManager.getCurrentSettings().getCustomSettings(JavaCodeStyleSettings.class);
        if (psiField.hasModifierProperty("static")) {
            return StringUtil.trimEnd((String)StringUtil.trimStart((String)string, (String)javaCodeStyleSettings.STATIC_FIELD_NAME_SUFFIX), (String)javaCodeStyleSettings.STATIC_FIELD_NAME_SUFFIX);
        }
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)string, (String)javaCodeStyleSettings.FIELD_NAME_SUFFIX), (String)javaCodeStyleSettings.FIELD_NAME_SUFFIX);
    }

    public static boolean classHasMethod(PsiClass psiClass, String string) {
        PsiMethod[] psiMethodArray = psiClass.findMethodsByName(string, false);
        return psiMethodArray.length != 0;
    }
}

