/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import com.intellij.a.c.j;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSADecoder {
    private final BigInteger d;
    private final BigInteger b;
    private final BigInteger e;
    private final int c;
    private final int a;

    public RSADecoder(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, 16);
    }

    public RSADecoder(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        this.e = bigInteger2;
        this.b = bigInteger;
        int n3 = bigInteger2.bitLength();
        this.a = n3 / 8 - 1;
        int n4 = (int)Math.ceil((double)n3 / Math.log(n2) * Math.log(2.0));
        if (n4 % 5 != 0) {
            n4 = (n4 / 5 + 1) * 5;
        }
        this.c = n4;
        this.d = new BigInteger(Integer.toString(n2));
    }

    public byte[] decode(String string) throws j {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BigInteger bigInteger = BigInteger.ZERO;
            int n2 = 0;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '-') continue;
                bigInteger = bigInteger.multiply(this.d).add(RSADecoder.a(c2));
                if (++n2 != this.c) continue;
                BigInteger bigInteger2 = bigInteger.modPow(this.b, this.e);
                byte[] byArray = bigInteger2.toByteArray();
                byteArrayOutputStream.write(byArray, Math.max(byArray.length - this.a, 0), Math.min(byArray.length, this.a));
                bigInteger = BigInteger.ZERO;
                n2 = 0;
            }
            if (n2 != 0) {
                throw new j();
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    private static BigInteger a(char c2) throws j {
        int n2;
        if ('0' <= c2 && c2 <= '9') {
            n2 = c2 - 48;
        } else if ('A' <= c2 && c2 <= 'Z') {
            n2 = c2 - 65 + 10;
        } else if ('a' <= c2 && c2 <= 'z') {
            n2 = c2 - 97 + 36;
        } else if ('!' <= c2 && c2 <= ')') {
            n2 = c2 - 33 + 62;
        } else {
            throw new j();
        }
        return BigInteger.valueOf(n2);
    }

    public String decodeString(String string) throws j {
        try {
            return new String(this.decode(string), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public Map<String, String> decodeProperties(String string) throws j {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.decodeString(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }
}

