/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSAEncoder {
    private final BigInteger f;
    private final BigInteger a;
    private final int c;
    private final int g;
    private int e = 0;
    private final BigInteger b;
    private final boolean d;

    public RSAEncoder(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, 16, true);
    }

    public RSAEncoder(BigInteger bigInteger, BigInteger bigInteger2, int n2, boolean bl2) {
        this.f = bigInteger;
        this.a = bigInteger2;
        this.d = bl2;
        int n3 = bigInteger2.bitLength();
        this.b = new BigInteger(String.valueOf(n2));
        int n4 = (int)Math.ceil((double)n3 / Math.log(n2) * Math.log(2.0));
        if (n4 % 5 != 0) {
            n4 = (n4 / 5 + 1) * 5;
        }
        this.g = n4;
        this.c = n3 / 8 - 1;
    }

    public String encode(byte[] byArray) {
        byte[] byArray2;
        int n2 = byArray.length % this.c;
        if (n2 == 0) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[byArray.length + this.c - n2];
            System.arraycopy(byArray, 0, byArray2, this.c - n2, byArray.length);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray2.length; i2 += this.c) {
            this.a(byArray2, stringBuilder, i2, this.c);
        }
        return stringBuilder.toString();
    }

    public String encodeString(String string) {
        try {
            return this.encode(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private void a(byte[] byArray, StringBuilder stringBuilder, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        byte[] byArray2 = new byte[this.c];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        if (bigInteger.compareTo(this.a) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.f, this.a);
        this.a(stringBuilder, this.b(bigInteger2));
    }

    private void a(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            this.a(stringBuilder);
            stringBuilder.append(charSequence.charAt(i2));
        }
    }

    private CharSequence b(BigInteger bigInteger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.g; ++i2) {
            stringBuilder.append(RSAEncoder.a(bigInteger.mod(this.b)));
            bigInteger = bigInteger.divide(this.b);
        }
        return new ReverseCharSequence(stringBuilder);
    }

    private void a(StringBuilder stringBuilder) {
        if (this.e > 0 && this.e % 5 == 0) {
            if (this.e % 30 == 0) {
                stringBuilder.append('\n');
            } else if (this.d) {
                stringBuilder.append('-');
            }
        }
        ++this.e;
    }

    private static char a(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        char c2 = n2 < 10 ? (char)(48 + n2) : (n2 < 36 ? (char)(65 + n2 - 10) : (n2 < 62 ? (char)(97 + n2 - 36) : (char)(33 + n2 - 62)));
        return c2;
    }

    public String encodeProperties(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string.indexOf(10) >= 0 || string2.indexOf(10) >= 0) {
                throw new RuntimeException("Keys and values are not allowed to contain linefeeds");
            }
            stringBuilder.append(string).append('\n').append(string2).append('\n');
        }
        return this.encodeString(stringBuilder.toString());
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence a;

        public ReverseCharSequence(CharSequence charSequence) {
            this.a = charSequence;
        }

        public int length() {
            return this.a.length();
        }

        public char charAt(int n2) {
            return this.a.charAt(this.a.length() - n2 - 1);
        }

        public CharSequence subSequence(int n2, int n3) {
            int n4 = this.a.length();
            return new ReverseCharSequence(this.a.subSequence(n4 - n3, n4 - n2));
        }
    }
}

