/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebServicesUtil {
    private static final Key<CachedValue<Set<XmlFile>>> WSDL_FILES_KEY = Key.create((String)"wsdl files");

    public static boolean isMessageDispatcherServletDefined(Collection<WebFacet> webFacets) {
        return SpringWebServicesUtil.getMessageDispatcherServlet(webFacets) != null;
    }

    @Nullable
    public static Servlet getMessageDispatcherServlet(@NotNull Collection<WebFacet> webFacets) {
        if (webFacets == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(0);
        }
        for (WebFacet webFacet : webFacets) {
            WebApp webApp = webFacet.getRoot();
            if (webApp == null) continue;
            for (Servlet servlet : webApp.getServlets()) {
                if (!SpringWebServicesUtil.isMessageDispatcherServlet(servlet)) continue;
                return servlet;
            }
        }
        return null;
    }

    public static boolean isMessageDispatcherServlet(@NotNull Servlet servlet) {
        if (servlet == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(1);
        }
        if ("org.springframework.ws.transport.http.MessageDispatcherServlet".equals(servlet.getServletClass().getStringValue())) {
            return true;
        }
        PsiClass psiClass = (PsiClass)servlet.getServletClass().getValue();
        return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.ws.transport.http.MessageDispatcherServlet");
    }

    @Nullable
    public static String getMessageDispatcherServletName(Collection<WebFacet> webFacets) {
        Servlet dispatcherServlet = SpringWebServicesUtil.getMessageDispatcherServlet(webFacets);
        return dispatcherServlet == null ? null : dispatcherServlet.getServletName().getStringValue();
    }

    @NotNull
    public static Set<XmlFile> getMessageDispatcherServletContexts(@NotNull Servlet servlet) {
        String servletName;
        Module module;
        if (servlet == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(2);
        }
        HashSet appFiles = new HashSet();
        XmlTag tag = servlet.getXmlTag();
        if (tag != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag)) != null && !StringUtil.isEmptyOrSpaces((String)(servletName = servlet.getServletName().getStringValue()))) {
            String relativePath = SpringWebServicesUtil.getApplicationContextRelativePath(servletName);
            for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
                PsiFile psiFile;
                WebDirectoryElement element = WebDirectoryUtil.getWebDirectoryUtil((Project)webFacet.getModule().getProject()).findWebDirectoryElementByPath(relativePath, webFacet);
                if (element == null || !((psiFile = element.getOriginalFile()) instanceof XmlFile) || !SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) continue;
                appFiles.add((XmlFile)psiFile);
            }
        }
        HashSet hashSet = appFiles;
        if (hashSet == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    public static String getApplicationContextRelativePath(@NotNull String servletName) {
        if (servletName == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(4);
        }
        String string = "WEB-INF/" + SpringWebServicesUtil.getApplicationContextFileName(servletName);
        if (string == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getApplicationContextFileName(@NotNull String servletName) {
        if (servletName == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(6);
        }
        String string = servletName + "-servlet.xml";
        if (string == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean isSpringWebServiceBeansDefined(DomFileElement<Beans> fileElement) {
        LocalXmlModel springModel;
        Module module = fileElement.getModule();
        if (module != null && (springModel = SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(fileElement.getFile(), module, Collections.emptySet())) != null) {
            return SpringWebServicesUtil.isWsdlDefinitionDefined(fileElement, (CommonSpringModel)springModel) || SpringWebServicesUtil.isEndpointsDefined(fileElement, (CommonSpringModel)springModel);
        }
        return false;
    }

    private static boolean isWsdlDefinitionDefined(DomFileElement<Beans> fileElement, @NotNull CommonSpringModel springModel) {
        PsiClass psiClass;
        if (springModel == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(8);
        }
        return (psiClass = DomJavaUtil.findClass((String)"org.springframework.ws.wsdl.WsdlDefinition", fileElement)) != null && SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (PsiClass)psiClass);
    }

    private static boolean isEndpointsDefined(DomFileElement<Beans> fileElement, @NotNull CommonSpringModel springModel) {
        PsiClass psiClass;
        if (springModel == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(9);
        }
        return (psiClass = DomJavaUtil.findClass((String)"org.springframework.ws.server.endpoint.PayloadEndpoint", fileElement)) != null && SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (PsiClass)psiClass);
    }

    public static LookupElement createLookupElementFor(@NotNull String key, @Nullable PsiFile target) {
        if (key == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(10);
        }
        return LookupElementBuilder.create((String)key).withIcon(target == null ? null : target.getIcon(0)).withTypeText(target == null ? "" : target.getName());
    }

    public static boolean isEndpointMappingProperty(GenericDomValue value) {
        return SpringPropertyUtils.isSpecificProperty((GenericDomValue)value, (String)"mappings", (String[])new String[]{"org.springframework.ws.server.endpoint.mapping.AbstractMapBasedEndpointMapping"});
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddressingInputActions(@NotNull Module module) {
        if (module == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(11);
        }
        Map<String, PsiElement> map = SpringWebServicesUtil.collectWebServiceAddressingActions(module, "input");
        if (map == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddressingOutputActions(@NotNull Module module) {
        if (module == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(13);
        }
        Map<String, PsiElement> map = SpringWebServicesUtil.collectWebServiceAddressingActions(module, "output");
        if (map == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddressingActions(@NotNull Module module, @NotNull String tagLocalname) {
        if (module == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(15);
        }
        if (tagLocalname == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(16);
        }
        Map<String, PsiElement> map = SpringWebServicesUtil.collectWebServiceAddressingElements(module, tagLocalname, "http://schemas.xmlsoap.org/wsdl/", "Action", "http://www.w3.org/2006/05/addressing/wsdl");
        if (map == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(17);
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddresses(@NotNull Module module) {
        if (module == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(18);
        }
        Map<String, PsiElement> map = SpringWebServicesUtil.collectWebServiceAddressingElements(module, "address", "http://schemas.xmlsoap.org/wsdl/soap/", "location", null);
        if (map == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(19);
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddressingElements(@NotNull Module module, final @NotNull String tagLocalName, final @NotNull String tagNamespace, final @NotNull String attrName, final @Nullable String attrNamespace) {
        if (module == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(20);
        }
        if (tagLocalName == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(21);
        }
        if (tagNamespace == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(22);
        }
        if (attrName == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(23);
        }
        HashMap actions = new HashMap();
        for (XmlFile xmlFile : SpringWebServicesUtil.getWsdlFiles(module)) {
            xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor((Map)actions){
                final /* synthetic */ Map val$actions;
                {
                    this.val$actions = map;
                }

                public void visitXmlTag(XmlTag tag) {
                    if (tag.getLocalName().equals(tagLocalName) && tag.getNamespace().equals(tagNamespace)) {
                        String inputAction;
                        XmlAttribute attribute;
                        XmlAttribute xmlAttribute = attribute = attrNamespace == null ? tag.getAttribute(attrName) : tag.getAttribute(attrName, attrNamespace);
                        if (attribute != null && !StringUtil.isEmptyOrSpaces((String)(inputAction = attribute.getValue()))) {
                            this.val$actions.put(inputAction, attribute);
                        }
                    } else {
                        super.visitXmlTag(tag);
                    }
                }
            });
        }
        HashMap hashMap = actions;
        if (hashMap == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    @NotNull
    public static Set<XmlFile> getWsdlFiles(@NotNull Module module) {
        Project project;
        CachedValuesManager manager;
        Set files;
        if (module == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(25);
        }
        Set set = (files = (Set)(manager = CachedValuesManager.getManager((Project)(project = module.getProject()))).getCachedValue((UserDataHolder)module, WSDL_FILES_KEY, () -> {
            if (module == null) {
                SpringWebServicesUtil.$$$reportNull$$$0(30);
            }
            return SpringWebServicesUtil.findWsdlFiles(module);
        }, false)) == null ? Collections.emptySet() : files;
        if (set == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(26);
        }
        return set;
    }

    @NotNull
    private static CachedValueProvider.Result<Set<XmlFile>> findWsdlFiles(@NotNull Module module) {
        if (module == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(27);
        }
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
        dependencies.add(VirtualFileManager.getInstance());
        HashSet wsdlFiles = new HashSet();
        for (VirtualFile file : FilenameIndex.getAllFilesByExt((Project)module.getProject(), (String)"wsdl", (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module))) {
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
            if (!(psiFile instanceof XmlFile)) continue;
            wsdlFiles.add((XmlFile)psiFile);
        }
        CachedValueProvider.Result result = new CachedValueProvider.Result((Object)wsdlFiles, dependencies.toArray());
        if (result == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(28);
        }
        return result;
    }

    @Nullable
    public static ParamValue getContextConfigurationParam(@NotNull Servlet servlet) {
        WebApp app;
        if (servlet == null) {
            SpringWebServicesUtil.$$$reportNull$$$0(29);
        }
        if ((app = (WebApp)servlet.getParentOfType(WebApp.class, false)) != null) {
            for (ParamValue param : app.getContextParams()) {
                if (!"contextConfigLocation".equals(param.getParamName().getValue())) continue;
                return param;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacets";
                break;
            }
            case 1: 
            case 2: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servlet";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/ws/util/SpringWebServicesUtil";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servletName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagLocalname";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagLocalName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagNamespace";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/ws/util/SpringWebServicesUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageDispatcherServletContexts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationContextRelativePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationContextFileName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebServiceAddressingInputActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebServiceAddressingOutputActions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebServiceAddressingActions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebServiceAddresses";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebServiceAddressingElements";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getWsdlFiles";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findWsdlFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessageDispatcherServlet";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMessageDispatcherServlet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessageDispatcherServletContexts";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationContextRelativePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationContextFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWsdlDefinitionDefined";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEndpointsDefined";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElementFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectWebServiceAddressingInputActions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectWebServiceAddressingOutputActions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectWebServiceAddressingActions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectWebServiceAddresses";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectWebServiceAddressingElements";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getWsdlFiles";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findWsdlFiles";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContextConfigurationParam";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getWsdlFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

