/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.classFilter;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.ClassFilterEditorAddDialog;
import com.intellij.ui.table.JBTable;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFilterEditor
extends JPanel
implements ComponentWithEmptyText {
    private static final String IS_ACTIVE = "Is Active";
    private static final String INCLUDE_EXCLUDE = "Include/Exclude";
    protected JBTable myTable = null;
    protected FilterTableModel myTableModel = null;
    protected final Project myProject;
    private final com.intellij.ide.util.ClassFilter myChooserFilter;
    @Nullable
    private final String myPatternsHelpId;
    private final boolean myExcludeAllowed;
    private String classDelimiter = "$";

    public ClassFilterEditor(Project project) {
        this(project, null);
    }

    public ClassFilterEditor(Project project, com.intellij.ide.util.ClassFilter classFilter) {
        this(project, classFilter, null);
    }

    public ClassFilterEditor(Project project, com.intellij.ide.util.ClassFilter classFilter, @Nullable String patternsHelpId) {
        this(project, classFilter, patternsHelpId, false);
    }

    public ClassFilterEditor(Project project, com.intellij.ide.util.ClassFilter classFilter, @Nullable String patternsHelpId, boolean excludeAllowed) {
        super(new BorderLayout());
        int preferredWidth;
        this.myPatternsHelpId = patternsHelpId;
        this.myExcludeAllowed = excludeAllowed;
        this.myTable = new JBTable();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable).addExtraAction(new AnActionButton(this.getAddButtonText(), this.getAddButtonIcon()){

            public void actionPerformed(AnActionEvent e) {
                ClassFilterEditor.this.addClassFilter();
            }

            public void updateButton(AnActionEvent e) {
                super.updateButton(e);
                this.setEnabled(!ClassFilterEditor.this.myProject.isDefault());
            }
        });
        if (this.addPatternButtonVisible()) {
            decorator.addExtraAction(new AnActionButton(this.getAddPatternButtonText(), this.getAddPatternButtonIcon()){

                public void actionPerformed(AnActionEvent e) {
                    ClassFilterEditor.this.addPatternFilter();
                }

                public void updateButton(AnActionEvent e) {
                    super.updateButton(e);
                    this.setEnabled(!ClassFilterEditor.this.myProject.isDefault());
                }
            });
        }
        this.add((Component)decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)ClassFilterEditor.this.myTable);
            }
        }).setButtonComparator(new String[]{this.getAddButtonText(), this.getAddPatternButtonText(), "Remove"}).disableUpDownActions().createPanel(), "Center");
        this.myChooserFilter = classFilter;
        this.myProject = project;
        this.myTableModel = new FilterTableModel();
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(200, this.myTable.getRowHeight() * 7));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        if (!excludeAllowed) {
            this.myTable.setTableHeader(null);
            preferredWidth = 0;
        } else {
            JTableHeader tableHeader = this.myTable.getTableHeader();
            FontMetrics fontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
            preferredWidth = fontMetrics.stringWidth(IS_ACTIVE) + 20;
            TableColumn includeColumn = columnModel.getColumn(2);
            includeColumn.setCellRenderer(new EnabledCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
            TableUtil.setupCheckboxColumn((TableColumn)includeColumn, (int)(fontMetrics.stringWidth(INCLUDE_EXCLUDE) + 20));
        }
        TableUtil.setupCheckboxColumn((TableColumn)column, (int)preferredWidth);
        column.setCellRenderer(new EnabledCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
        columnModel.getColumn(1).setCellRenderer(new FilterCellRenderer());
        this.getEmptyText().setText(UIBundle.message((String)"no.patterns", (Object[])new Object[0]));
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            ClassFilterEditor.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    protected String getAddButtonText() {
        return UIBundle.message((String)"button.add.class", (Object[])new Object[0]);
    }

    protected String getAddPatternButtonText() {
        return UIBundle.message((String)"button.add.pattern", (Object[])new Object[0]);
    }

    protected Icon getAddButtonIcon() {
        return IconUtil.getAddClassIcon();
    }

    protected Icon getAddPatternButtonIcon() {
        return IconUtil.getAddPatternIcon();
    }

    protected boolean addPatternButtonVisible() {
        return true;
    }

    public void setFilters(ClassFilter[] filters) {
        this.myTableModel.setFilters(filters);
    }

    public ClassFilter[] getFilters() {
        return this.myTableModel.getFilters();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myTable.setEnabled(enabled);
        this.myTable.setRowSelectionAllowed(enabled);
        this.myTableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    @NotNull
    protected ClassFilter createFilter(String pattern) {
        ClassFilter classFilter = new ClassFilter(pattern);
        if (classFilter == null) {
            ClassFilterEditor.$$$reportNull$$$0(1);
        }
        return classFilter;
    }

    protected void addPatternFilter() {
        String pattern;
        ClassFilterEditorAddDialog dialog = new ClassFilterEditorAddDialog(this.myProject, this.myPatternsHelpId);
        if (dialog.showAndGet() && (pattern = dialog.getPattern()) != null) {
            ClassFilter filter2 = this.createFilter(pattern);
            this.myTableModel.addRow(filter2);
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
        }
    }

    protected void addClassFilter() {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance(this.myProject).createNoInnerClassesScopeChooser(UIBundle.message((String)"class.filter.editor.choose.class.title", (Object[])new Object[0]), GlobalSearchScope.allScope((Project)this.myProject), this.myChooserFilter, null);
        chooser.showDialog();
        PsiClass selectedClass = chooser.getSelected();
        if (selectedClass != null) {
            ClassFilter filter2 = this.createFilter(this.getJvmClassName(selectedClass));
            this.myTableModel.addRow(filter2);
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
        }
    }

    @Nullable
    private String getJvmClassName(PsiClass aClass) {
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parentClass != null) {
            String parentName = this.getJvmClassName(parentClass);
            if (parentName == null) {
                return null;
            }
            return parentName + this.classDelimiter + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    public void setClassDelimiter(String classDelimiter) {
        this.classDelimiter = classDelimiter;
    }

    public void addPattern(String pattern) {
        ClassFilter filter2 = this.createFilter(pattern);
        this.myTableModel.addRow(filter2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/classFilter/ClassFilterEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EnabledCellRenderer
    extends DefaultTableCellRenderer {
        private final TableCellRenderer myDelegate;

        public EnabledCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setEnabled(ClassFilterEditor.this.isEnabled());
            return component;
        }
    }

    private class FilterCellRenderer
    extends DefaultTableCellRenderer {
        private FilterCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = UIUtil.getTableFocusCellBackground();
            UIManager.put("Table.focusCellBackground", table.getSelectionBackground());
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                ((JLabel)component).setBorder(noFocusBorder);
            }
            UIManager.put("Table.focusCellBackground", color);
            ClassFilter filter2 = (ClassFilter)table.getValueAt(row, 1);
            component.setEnabled(isSelected || ClassFilterEditor.this.isEnabled() && filter2.isEnabled());
            return component;
        }
    }

    protected final class FilterTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final List<ClassFilter> myFilters = new LinkedList<ClassFilter>();
        public static final int CHECK_MARK = 0;
        public static final int FILTER = 1;
        public static final int INCLUDE_MARK = 2;

        protected FilterTableModel() {
        }

        public final void setFilters(ClassFilter[] filters) {
            this.myFilters.clear();
            if (filters != null) {
                ContainerUtil.addAll(this.myFilters, (Object[])filters);
            }
            this.fireTableDataChanged();
        }

        public ClassFilter[] getFilters() {
            Iterator<ClassFilter> it = this.myFilters.iterator();
            while (it.hasNext()) {
                ClassFilter filter2 = it.next();
                String pattern = filter2.getPattern();
                if (pattern != null && !"".equals(pattern)) continue;
                it.remove();
            }
            return this.myFilters.toArray(ClassFilter.EMPTY_ARRAY);
        }

        public ClassFilter getFilterAt(int index) {
            return this.myFilters.get(index);
        }

        public int getFilterIndex(ClassFilter filter2) {
            return this.myFilters.indexOf(filter2);
        }

        public void addRow(ClassFilter filter2) {
            this.myFilters.add(filter2);
            int row = this.myFilters.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public int getRowCount() {
            return this.myFilters.size();
        }

        @Override
        public int getColumnCount() {
            if (ClassFilterEditor.this.myExcludeAllowed) {
                return 3;
            }
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 1) {
                return "Pattern";
            }
            if (column == 2) {
                return ClassFilterEditor.INCLUDE_EXCLUDE;
            }
            return ClassFilterEditor.IS_ACTIVE;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ClassFilter filter2 = this.myFilters.get(rowIndex);
            if (columnIndex == 1) {
                return filter2;
            }
            if (columnIndex == 0) {
                return filter2.isEnabled();
            }
            if (columnIndex == 2) {
                return filter2.isInclude();
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ClassFilter filter2 = this.myFilters.get(rowIndex);
            if (columnIndex == 1) {
                filter2.setPattern(aValue != null ? aValue.toString() : "");
            } else if (columnIndex == 0) {
                filter2.setEnabled(aValue == null || (Boolean)aValue != false);
            } else if (columnIndex == 2) {
                filter2.setInclude(aValue == null || (Boolean)aValue != false);
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0 || columnIndex == 2) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return ClassFilterEditor.this.isEnabled();
        }

        public void removeRow(int idx) {
            this.myFilters.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }
    }
}

