/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.facet.nodes.ConfigFileNode;
import com.intellij.spring.facet.nodes.FileSetNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FilesetGroupNode
extends SimpleNode {
    private final Set<VirtualFilePointer> myChildren;
    private final FileSetNode myFilesetNode;

    protected FilesetGroupNode(@NotNull FileSetNode parent, @NotNull Set<VirtualFilePointer> children) {
        if (parent == null) {
            FilesetGroupNode.$$$reportNull$$$0(0);
        }
        if (children == null) {
            FilesetGroupNode.$$$reportNull$$$0(1);
        }
        super((SimpleNode)parent);
        this.myFilesetNode = parent;
        this.myChildren = children;
    }

    public SimpleNode[] getChildren() {
        ArrayList<ConfigFileNode> nodes = new ArrayList<ConfigFileNode>(this.myChildren.size());
        for (VirtualFilePointer file : this.myChildren) {
            nodes.add(this.createNode(file));
        }
        if (this.getFilesetNode().getConfigurationTabSettings().isSortAlpha()) {
            Collections.sort(nodes, FileSetNode.FILENAME_COMPARATOR);
        }
        return nodes.toArray(new SimpleNode[0]);
    }

    protected ConfigFileNode createNode(VirtualFilePointer virtualFilePointer) {
        return new ConfigFileNode(this.getFilesetNode().getConfigurationTabSettings(), this.getFilesetNode().getFileSet(), virtualFilePointer, this);
    }

    protected FileSetNode getFilesetNode() {
        return this.myFilesetNode;
    }

    public Set<VirtualFilePointer> getFilePointers() {
        return this.myChildren;
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setPresentableText(this.getGroupName());
        presentation.setIcon(this.getGroupNodeIcon());
    }

    protected abstract String getGroupName();

    protected abstract Icon getGroupNodeIcon();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "children";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/facet/nodes/FilesetGroupNode";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

