/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.facet.validation.SpringProgrammaticConfigurationCollector;
import com.intellij.spring.facet.validation.SpringUnmappedConfigurationFilesCollector;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import icons.SpringApiIcons;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringConfigurationCheckTask
extends Task.Backgroundable {
    private static final String NOTIFICATION_ID = "Spring Configuration Check";
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Spring Configuration Check", NotificationDisplayType.STICKY_BALLOON, true);
    private static final String CREATE_DEFAULT_CONTEXT_LABEL = "Create Default Context";
    private static final String USAGE_PREFIX = "spring.SpringConfigurationCheckTask.";
    private final DumbService dumbService = DumbService.getInstance((Project)this.getProject());
    private SpringUnmappedConfigurationFilesCollector myUnmappedCollector;
    private SpringProgrammaticConfigurationCollector myProgrammaticCollector;

    SpringConfigurationCheckTask(Project project) {
        super(project, NOTIFICATION_ID);
    }

    public void run(@NotNull ProgressIndicator indicator) {
        SensitiveProgressWrapper innerIndicator;
        boolean finished;
        if (indicator == null) {
            SpringConfigurationCheckTask.$$$reportNull$$$0(0);
        }
        while (!(finished = ProgressIndicatorUtils.runWithWriteActionPriority(() -> this.lambda$run$1(innerIndicator = SpringConfigurationCheckTask.createWrappingIndicator(indicator)), (ProgressIndicator)innerIndicator)) && !indicator.isCanceled()) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
    }

    private static SensitiveProgressWrapper createWrappingIndicator(final ProgressIndicator indicator) {
        return new SensitiveProgressWrapper(indicator){

            public void setText(String text) {
                indicator.setText(text);
            }

            public void setText2(String text) {
                indicator.setText2(text);
            }

            public void setFraction(double fraction) {
                indicator.setFraction(fraction);
            }

            public void setIndeterminate(boolean indeterminate) {
                indicator.setIndeterminate(indeterminate);
            }
        };
    }

    private void runCollectors(ProgressIndicator indicator) {
        if (this.isDisposed()) {
            return;
        }
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        if (modules.length == 0) {
            return;
        }
        this.myUnmappedCollector = new SpringUnmappedConfigurationFilesCollector(modules);
        if (this.myUnmappedCollector.isEnabledInProject()) {
            this.myUnmappedCollector.collect(indicator);
        }
        this.myProgrammaticCollector = new SpringProgrammaticConfigurationCollector(this.getProject());
        if (!ApplicationManager.getApplication().isInternal()) {
            return;
        }
        if (this.myProgrammaticCollector.isEnabledInProject()) {
            this.myProgrammaticCollector.collect(indicator);
        }
    }

    private boolean isDisposed() {
        return this.getProject().isDisposed();
    }

    public void onSuccess() {
        if (this.getProject().isDisposed()) {
            return;
        }
        if (this.myUnmappedCollector == null || this.myProgrammaticCollector == null) {
            return;
        }
        List<PsiElement> programmaticResults = this.myProgrammaticCollector.getResults();
        if (!this.myUnmappedCollector.hasResults() && programmaticResults.isEmpty()) {
            return;
        }
        MultiMap unmappedFilesCount = MultiMap.create();
        String notification = "";
        if (this.myUnmappedCollector.hasResults()) {
            Processor fileTypeCounterProcessor = psiFile -> {
                unmappedFilesCount.putValue((Object)psiFile.getFileType().getDefaultExtension(), psiFile);
                return true;
            };
            String unmappedFilesText = "";
            boolean atLeastOneModuleWithoutFacet = false;
            for (Pair<Module, Collection<PsiFile>> entry : this.myUnmappedCollector.getModulesWithUnmappedFiles()) {
                Module module = (Module)entry.getFirst();
                String moduleName = module.getName();
                Collection files = (Collection)entry.getSecond();
                int filesCount = files.size();
                unmappedFilesText = unmappedFilesText + "<a href=\"config#" + moduleName + "\">" + moduleName + "</a>";
                unmappedFilesText = unmappedFilesText + " (<a href=\"files#" + moduleName + "\">" + filesCount + " " + StringUtil.pluralize((String)"file", (int)filesCount) + "</a>)";
                SpringFacet springFacet = SpringFacet.getInstance(module);
                if (springFacet == null || springFacet.getFileSets().isEmpty()) {
                    unmappedFilesText = unmappedFilesText + "&nbsp;&nbsp;&nbsp;<a href=\"createDefault#" + moduleName + "\">" + CREATE_DEFAULT_CONTEXT_LABEL + "</a>";
                    atLeastOneModuleWithoutFacet = true;
                }
                unmappedFilesText = unmappedFilesText + "<br/>";
                ContainerUtil.process((Iterable)files, (Processor)fileTypeCounterProcessor);
            }
            String fixInstruction = atLeastOneModuleWithoutFacet ? "Please configure Spring facet or use 'Create Default Context' to add one including all unmapped files." : "Please configure Spring facet.";
            notification = notification + "Unmapped Spring configuration files found.<br/><br/>" + fixInstruction + "<br/><br/>" + unmappedFilesText;
        }
        if (!programmaticResults.isEmpty()) {
            notification = notification + (!notification.isEmpty() ? "<br/>" : "") + "Programmatic contexts found:<br/>";
            for (int i = 0; i < programmaticResults.size(); ++i) {
                PsiElement psiElement = programmaticResults.get(i);
                PsiFile psiFile2 = psiElement.getContainingFile();
                notification = notification + "<a href=\"psi#" + i + "\">" + psiFile2.getName() + "</a><br/>";
                unmappedFilesCount.putValue((Object)(psiFile2.getFileType().getDefaultExtension() + ".Programmatic"), (Object)psiFile2);
            }
        }
        for (Map.Entry entry : unmappedFilesCount.entrySet()) {
            String configFileTypeKey = (String)entry.getKey();
            for (int i = 0; i < ((Collection)entry.getValue()).size(); ++i) {
                UsageTrigger.trigger((String)("spring.SpringConfigurationCheck.FileCount." + configFileTypeKey));
            }
        }
        this.createNotification(notification, programmaticResults).addAction((AnAction)new NotificationAction("Show Help"){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                HelpManager.getInstance().invokeHelp("spring.managing.file.sets");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).addAction((AnAction)new NotificationAction("Disable..."){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                int result;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((result = Messages.showYesNoDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)"Detection will be disabled for whole project.\nNote that most Spring related features will not work if Spring facet configuration is not performed.\n\nProject Structure | Facets | Detection\ncan be used to exclude specific files/folders only and to re-enable.", (String)"Spring Config Detection", (String)"Disable Detection", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon())) == 0) {
                    DetectionExcludesConfiguration detectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)SpringConfigurationCheckTask.this.getProject());
                    detectionExcludesConfiguration.addExcludedFramework(SpringFrameworkDetector.SPRING_FRAMEWORK_TYPE);
                    notification.hideBalloon();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setIcon(SpringApiIcons.Spring).notify(this.getProject());
    }

    @NotNull
    private Notification createNotification(String notificationText, List<PsiElement> programmaticResults) {
        Notification notification = NOTIFICATION_GROUP.createNotification(NOTIFICATION_ID, notificationText, NotificationType.WARNING, (NotificationListener)new MyNotificationAdapter(programmaticResults));
        if (notification == null) {
            SpringConfigurationCheckTask.$$$reportNull$$$0(1);
        }
        return notification;
    }

    private /* synthetic */ void lambda$run$1(SensitiveProgressWrapper innerIndicator) {
        if (this.isDisposed()) {
            return;
        }
        this.dumbService.runReadActionInSmartMode(() -> this.runCollectors((ProgressIndicator)innerIndicator));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/validation/SpringConfigurationCheckTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/validation/SpringConfigurationCheckTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyNotificationAdapter
    extends NotificationListener.Adapter {
        private final List<PsiElement> myProgrammaticResults;

        private MyNotificationAdapter(List<PsiElement> programmaticResults) {
            this.myProgrammaticResults = programmaticResults;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                MyNotificationAdapter.$$$reportNull$$$0(0);
            }
            if (e == null) {
                MyNotificationAdapter.$$$reportNull$$$0(1);
            }
            if (SpringConfigurationCheckTask.this.getProject().isDisposed()) {
                return;
            }
            String description = e.getDescription();
            String navigationTarget = StringUtil.substringAfter((String)description, (String)"#");
            assert (navigationTarget != null);
            if (description.startsWith("config")) {
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                SpringFacet springFacet = SpringFacet.getInstance(module);
                if (springFacet != null) {
                    ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
                    UsageTrigger.trigger((String)"spring.SpringConfigurationCheckTask.ShowFacet");
                } else {
                    ModulesConfigurator.showDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)navigationTarget, null);
                    UsageTrigger.trigger((String)"spring.SpringConfigurationCheckTask.ShowModule");
                }
                this.updateNotification(notification);
            } else if (description.startsWith("createDefault")) {
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                DumbService dumbService = DumbService.getInstance((Project)SpringConfigurationCheckTask.this.getProject());
                if (dumbService.isDumb()) {
                    dumbService.showDumbModeNotification("'Create Default Context' is not available during index update");
                    return;
                }
                SpringFacet springFacet = SpringFacet.getInstance(module);
                if (springFacet == null) {
                    springFacet = (SpringFacet)FacetUtil.addFacet((Module)module, SpringFacet.getSpringFacetType());
                }
                UsageTrigger.trigger((String)"spring.SpringConfigurationCheckTask.CreateDefault");
                for (SpringModelProvider provider : (SpringModelProvider[])SpringModelProvider.EP_NAME.getExtensions()) {
                    if (provider.getFilesets(springFacet).isEmpty()) continue;
                    int result = Messages.showYesNoDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)("Autodetected context found for " + provider.getName() + ".\nPlease check and setup additional manual context (if required)."), (String)"Spring Configuration", (String)"Open Facet Configuration", (String)CommonBundle.getCloseButtonText(), (Icon)Messages.getInformationIcon());
                    if (result == 0) {
                        ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
                    }
                    this.updateNotification(notification);
                    return;
                }
                Set<SpringFileSet> existingFileSets = Collections.emptySet();
                String id = SpringFileSetService.getInstance().getUniqueId(existingFileSets);
                String name = SpringFileSetService.getInstance().getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), existingFileSets);
                SpringFileSet fileSet = springFacet.addFileSet(id, name);
                Collection<PsiFile> files = SpringConfigurationCheckTask.this.myUnmappedCollector.getUnmappedFilesFor(module);
                for (PsiFile file : files) {
                    fileSet.addFile(file.getVirtualFile());
                }
                this.updateNotification(notification);
            } else if (description.startsWith("files")) {
                UsageTrigger.trigger((String)"spring.SpringConfigurationCheckTask.ShowFiles");
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                Collection<PsiFile> files = SpringConfigurationCheckTask.this.myUnmappedCollector.getUnmappedFilesFor(module);
                if (files.isEmpty()) {
                    JBPopupFactory.getInstance().createMessage("No files found").showInFocusCenter();
                    return;
                }
                JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])ArrayUtil.toObjectArray(files, PsiFile.class)), (String)("Unmapped Spring Configuration Files in " + navigationTarget));
                Object event = e.getSource();
                if (event instanceof Component) {
                    popup.showInCenterOf((Component)event);
                } else {
                    popup.showInFocusCenter();
                }
            } else if (description.startsWith("psi")) {
                PsiElement element = this.myProgrammaticResults.get(Integer.parseInt(navigationTarget));
                NavigationUtil.activateFileWithPsiElement((PsiElement)element);
            }
        }

        private void updateNotification(@NotNull Notification notification) {
            if (notification == null) {
                MyNotificationAdapter.$$$reportNull$$$0(2);
            }
            notification.expire();
            ApplicationManager.getApplication().invokeLater(() -> new SpringConfigurationCheckTask(SpringConfigurationCheckTask.this.getProject()).queue(), SpringConfigurationCheckTask.this.getProject().getDisposed());
        }

        @Nullable
        private Module findModuleByName(String navigationTarget) {
            return ModuleManager.getInstance((Project)SpringConfigurationCheckTask.this.getProject()).findModuleByName(navigationTarget);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$MyNotificationAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateNotification";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

