/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringManagerImpl
extends SpringManager {
    private static final Key<CachedValue<Set<SpringModel>>> ALL_MODELS_MODULE_WITH_DEPS = Key.create((String)"ALL_MODELS_MODULE_WITH_DEPS");
    private final Project myProject;

    public SpringManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public Object[] getModelsDependencies(@NotNull Module module, Object ... additional) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList<Object> dependencies = new ArrayList<Object>(6);
        Collections.addAll(dependencies, additional);
        Object[] objectArray = SpringManagerImpl.addModuleModelsDependencies(module, dependencies).toArray();
        if (objectArray == null) {
            SpringManagerImpl.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    private static Collection<Object> addModuleModelsDependencies(@NotNull Module module, Collection<Object> dependencies) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(2);
        }
        Project project = module.getProject();
        SpringModificationTrackersManager modificationTrackersManager = SpringModificationTrackersManager.getInstance(project);
        dependencies.add(modificationTrackersManager.getProfilesModificationTracker());
        dependencies.add(modificationTrackersManager.getMultipleContextsModificationTracker());
        dependencies.add(ProjectRootManager.getInstance((Project)project));
        dependencies.add(FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
        SpringFacet facet = SpringFacet.getInstance(module);
        if (facet != null) {
            dependencies.add(facet.getConfiguration());
        }
        Collection<Object> collection = dependencies;
        if (collection == null) {
            SpringManagerImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<SpringModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(4);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, ALL_MODELS_MODULE_WITH_DEPS, () -> {
            if (module == null) {
                SpringManagerImpl.$$$reportNull$$$0(24);
            }
            Set<SpringModel> models = this.computeAllModels(module);
            Object[] dependencies = this.getModelsDependencies(module, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            return CachedValueProvider.Result.create(models, (Object[])dependencies);
        }, false);
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<SpringModel> getAllModelsWithoutDependencies(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(6);
        }
        if (module.isDisposed()) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringManagerImpl.$$$reportNull$$$0(7);
            }
            return set;
        }
        Project project = module.getProject();
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            SpringFacet facet;
            if (module == null) {
                SpringManagerImpl.$$$reportNull$$$0(23);
            }
            if ((facet = SpringFacet.getInstance(module)) == null) {
                if (this.isAllowAutoConfiguration()) {
                    return SpringAutoConfiguredModels.getAutoConfiguredModels(module);
                }
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)});
            }
            Set<SpringFileSet> fileSets = SpringFileSetService.getInstance().getAllSets(facet);
            if (fileSets.isEmpty() && this.isAllowAutoConfiguration()) {
                return SpringAutoConfiguredModels.getAutoConfiguredModels(module);
            }
            LinkedHashSet models = new LinkedHashSet(fileSets.size());
            for (SpringFileSet set : fileSets) {
                if (set.isRemoved()) continue;
                SpringModel model = SpringCombinedModelFactory.createModel(set, module);
                ContainerUtil.addIfNotNull(models, (Object)model);
            }
            return CachedValueProvider.Result.create(models, (Object[])this.getModelsDependencies(module, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        });
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    public boolean isAllowAutoConfiguration() {
        return SpringGeneralSettings.getInstance(this.myProject).isAllowAutoConfigurationMode();
    }

    @Override
    @NotNull
    public SpringModel getCombinedModel(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(9);
        }
        CombinedSpringModelImpl combinedSpringModelImpl = new CombinedSpringModelImpl(this.getAllModels(module), module);
        if (combinedSpringModelImpl == null) {
            SpringManagerImpl.$$$reportNull$$$0(10);
        }
        return combinedSpringModelImpl;
    }

    @Override
    @NotNull
    public Set<SpringModel> getSpringModelsByFile(@NotNull PsiFile file) {
        Module module;
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(11);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringManagerImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set<SpringModel> models = SpringCombinedModelFactory.findModelsInScope(file, module);
        if (!models.isEmpty()) {
            Set<SpringModel> set = models;
            if (set == null) {
                SpringManagerImpl.$$$reportNull$$$0(13);
            }
            return set;
        }
        SpringModel model = SpringCombinedModelFactory.createSingleModel(file, module);
        Set set = ContainerUtil.createMaybeSingletonSet((Object)model);
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(14);
        }
        return set;
    }

    @Override
    @Nullable
    public SpringModel getSpringModelByFile(@NotNull PsiFile file) {
        Module module;
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(15);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return null;
        }
        Set<SpringModel> allModels = this.getSpringModelsByFile(file);
        if (allModels.size() == 1) {
            return allModels.iterator().next();
        }
        SpringContextDescriptor descriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(file);
        if (descriptor.equals(SpringContextDescriptor.LOCAL_CONTEXT)) {
            return SpringCombinedModelFactory.createSingleModel(file, module);
        }
        if (descriptor.equals(SpringContextDescriptor.ALL_CONTEXTS)) {
            return new CombinedSpringModelImpl(allModels, module);
        }
        String descriptorId = descriptor.getId();
        Module descriptorModule = descriptor.getModule();
        if (descriptorModule != null) {
            for (SpringModel model : allModels) {
                SpringFileSet fileSet = model.getFileSet();
                if (fileSet == null || !descriptorId.equals(fileSet.getId()) || !descriptorModule.equals(model.getModule())) continue;
                return model;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public LocalXmlModel getLocalSpringModel(@NotNull XmlFile file) {
        Module module;
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(16);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null ? null : this.getLocalSpringModel(file, module);
    }

    @Override
    @Nullable
    public LocalXmlModel getLocalSpringModel(@NotNull XmlFile file, @NotNull Module module) {
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(17);
        }
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(18);
        }
        return SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(file, module, null);
    }

    @Override
    @Nullable
    public LocalAnnotationModel getLocalSpringModel(@NotNull PsiClass psiClass) {
        Module module;
        if (psiClass == null) {
            SpringManagerImpl.$$$reportNull$$$0(19);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) == null ? null : this.getLocalSpringModel(psiClass, module);
    }

    @Override
    @Nullable
    public LocalAnnotationModel getLocalSpringModel(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            SpringManagerImpl.$$$reportNull$$$0(20);
        }
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(21);
        }
        return SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
    }

    private Set<SpringModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(22);
        }
        LinkedHashSet<SpringModel> result = new LinkedHashSet<SpringModel>();
        ModuleUtilCore.ModuleVisitor visitor = visitModule -> {
            Set<SpringModel> models = this.getAllModelsWithoutDependencies(visitModule);
            result.addAll(models);
            return true;
        };
        ModuleUtilCore.visitMeAndDependentModules((Module)module, (ModuleUtilCore.ModuleVisitor)visitor);
        LinkedHashSet dependencies = new LinkedHashSet();
        ModuleUtilCore.getDependencies((Module)module, dependencies);
        dependencies.remove(module);
        for (Module dep : dependencies) {
            visitor.visit(dep);
        }
        SpringManagerImpl.processFileSetDependencies(result);
        return result;
    }

    private static void processFileSetDependencies(Set<SpringModel> models) {
        for (SpringModel model : models) {
            Set<SpringFileSet> dependencyFileSets;
            SpringFileSet fileSet = model.getFileSet();
            if (fileSet == null || (dependencyFileSets = fileSet.getDependencyFileSets()).isEmpty()) continue;
            LinkedHashSet dependencies = ContainerUtil.newLinkedHashSet();
            block1: for (SpringFileSet depend : dependencyFileSets) {
                for (SpringModel depModel : models) {
                    if (depModel == model || !depend.equals(depModel.getFileSet())) continue;
                    dependencies.add(depModel);
                    continue block1;
                }
            }
            model.setDependencies(dependencies);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringManagerImpl";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addModuleModelsDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModels";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModelsWithoutDependencies";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedModel";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModelsByFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModelsDependencies";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModuleModelsDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllModels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllModelsWithoutDependencies";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModelsByFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModelByFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSpringModel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "computeAllModels";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllModelsWithoutDependencies$1";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllModels$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

