/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.el.extensions.SpringELAliasedAttributeInjectionContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

public class SpringELCacheableContextVariables
extends SpringElContextsExtension {
    private static final List<String> CACHE_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.cache.annotation.Cacheable", "org.springframework.cache.annotation.CacheEvict", "org.springframework.cache.annotation.CachePut"});

    @Override
    @NotNull
    public Collection<PsiMethod> getRootMethods(@NotNull PsiElement context) {
        PsiAnnotation annotation;
        if (context == null) {
            SpringELCacheableContextVariables.$$$reportNull$$$0(0);
        }
        if ((annotation = SpringELCacheableContextVariables.getCacheableAnnotationContext(context)) == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                SpringELCacheableContextVariables.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiClass rootObjectClass = SpringELCacheableContextVariables.getRootObjectClass(annotation.getProject());
        if (rootObjectClass != null) {
            HashSet methods = ContainerUtil.newHashSet();
            for (PsiMethod psiMethod : rootObjectClass.getAllMethods()) {
                PsiClass containingClass;
                if (!psiMethod.hasModifierProperty("public") || psiMethod.isConstructor() || (containingClass = psiMethod.getContainingClass()) == null || "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
                methods.add(psiMethod);
            }
            HashSet hashSet = methods;
            if (hashSet == null) {
                SpringELCacheableContextVariables.$$$reportNull$$$0(2);
            }
            return hashSet;
        }
        Collection<PsiMethod> collection = super.getRootMethods(context);
        if (collection == null) {
            SpringELCacheableContextVariables.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement context) {
        PsiAnnotation annotation;
        if (context == null) {
            SpringELCacheableContextVariables.$$$reportNull$$$0(4);
        }
        if ((annotation = SpringELCacheableContextVariables.getCacheableAnnotationContext(context)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringELCacheableContextVariables.$$$reportNull$$$0(5);
            }
            return list;
        }
        List variables = ContainerUtil.newSmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
        if (method != null) {
            PsiType returnType = method.getReturnType();
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnType != null && returnTypeElement != null) {
                variables.add(new LightVariableBuilder("result", returnType, (PsiElement)returnTypeElement));
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType parameterType = parameter.getType();
                variables.add(parameter);
                variables.add(new LightVariableBuilder("a" + i, parameterType, (PsiElement)parameter));
                variables.add(new LightVariableBuilder("p" + i, parameterType, (PsiElement)parameter));
            }
        }
        ContainerUtil.addIfNotNull((Collection)variables, (Object)SpringELCacheableContextVariables.getCacheRootObject(context.getProject()));
        List list = variables;
        if (list == null) {
            SpringELCacheableContextVariables.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static PsiAnnotation getCacheableAnnotationContext(@NotNull PsiElement context) {
        PsiElement element;
        if (context == null) {
            SpringELCacheableContextVariables.$$$reportNull$$$0(7);
        }
        if ((element = context.getContext()) == null) {
            return null;
        }
        Pair annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)element));
        if (annotationEntry == null) {
            return null;
        }
        PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation);
        if (!SpringLibraryUtil.hasSpringLibrary(module)) {
            return null;
        }
        String annoFqn = annotation.getQualifiedName();
        return annoFqn != null && SpringELCacheableContextVariables.isCacheAnnotation(module, annoFqn) ? annotation : null;
    }

    private static boolean isCacheAnnotation(Module module, @NotNull String annoFqn) {
        if (annoFqn == null) {
            SpringELCacheableContextVariables.$$$reportNull$$$0(8);
        }
        if (CACHE_ANNOTATIONS.contains(annoFqn)) {
            return true;
        }
        for (String cacheAnnotation : CACHE_ANNOTATIONS) {
            if (!SpringELAliasedAttributeInjectionContext.isCustomAnnotation(module, annoFqn, cacheAnnotation)) continue;
            return true;
        }
        return false;
    }

    private static PsiVariable getCacheRootObject(@NotNull Project project) {
        if (project == null) {
            SpringELCacheableContextVariables.$$$reportNull$$$0(9);
        }
        return (PsiVariable)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            PsiClass rootObjectClass;
            if (project == null) {
                SpringELCacheableContextVariables.$$$reportNull$$$0(11);
            }
            if ((rootObjectClass = SpringELCacheableContextVariables.getRootObjectClass(project)) == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
            }
            PsiClassType type = PsiTypesUtil.getClassType((PsiClass)rootObjectClass);
            return CachedValueProvider.Result.create((Object)new LightVariableBuilder("root", (PsiType)type, (PsiElement)rootObjectClass), (Object[])new Object[]{rootObjectClass, ProjectRootManager.getInstance((Project)project)});
        });
    }

    @Nullable
    private static PsiClass getRootObjectClass(@NotNull Project project) {
        if (project == null) {
            SpringELCacheableContextVariables.$$$reportNull$$$0(10);
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.cache.interceptor.CacheExpressionRootObject", GlobalSearchScope.allScope((Project)project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoFqn";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/cacheable/el/SpringELCacheableContextVariables";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMethods";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootMethods";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCacheableAnnotationContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCacheAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCacheRootObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRootObjectClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCacheRootObject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

