/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCachePut;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheable;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachePut;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheable;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class SpringCacheableAndCachePutInspection
extends SpringUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod umethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (umethod == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(1);
        }
        if (this.isInSpringEnabledModule((UElement)umethod)) {
            List<SpringJamCacheableElement> cachePutElements;
            PsiMethod method = (PsiMethod)umethod.getJavaPsi();
            assert (method != null);
            PsiElement sourcePsi = umethod.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            List<SpringJamCacheableElement> cacheableElements = SpringCacheableAndCachePutInspection.getCacheableElements(method);
            if (cacheableElements.size() > 0 && (cachePutElements = SpringCacheableAndCachePutInspection.getCachePutElements(method)).size() > 0) {
                ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
                this.registerProblems(cacheableElements, holder);
                this.registerProblems(cachePutElements, holder);
                return holder.getResultsArray();
            }
        }
        return null;
    }

    private void registerProblems(List<SpringJamCacheableElement> cacheableElements, ProblemsHolder holder) {
        for (SpringJamCacheableElement element : cacheableElements) {
            PsiElement annotation = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)element.getAnnotation(), UAnnotation.class)));
            if (annotation == null) continue;
            holder.registerProblem(annotation, SpringBundle.message("cacheable.and.cache.put.on.the.same.method", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static List<SpringJamCacheableElement> getCacheableElements(@NotNull PsiMethod method) {
        if (method == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(2);
        }
        List elements = ContainerUtil.newSmartList();
        ContainerUtil.addAll((Collection)elements, (Iterable)SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCacheable.CACHEABLE_JAM_KEY, (PsiElement)method));
        ContainerUtil.addAll((Collection)elements, (Iterable)SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCustomCacheable.CUSTOM_CACHEABLE_JAM_KEY, (PsiElement)method));
        return elements;
    }

    private static List<SpringJamCacheableElement> getCachePutElements(@NotNull PsiMethod method) {
        if (method == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(3);
        }
        List elements = ContainerUtil.newSmartList();
        ContainerUtil.addAll((Collection)elements, (Iterable)SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, (PsiElement)method));
        ContainerUtil.addAll((Collection)elements, (Iterable)SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCustomCachePut.CUSTOM_CACHE_PUT_JAM_KEY, (PsiElement)method));
        return elements;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringCacheableAndCachePutInspection" == null) {
            SpringCacheableAndCachePutInspection.$$$reportNull$$$0(4);
        }
        return "SpringCacheableAndCachePutInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheableAndCachePutInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheableAndCachePutInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCacheableElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCachePutElements";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

