/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.converters.BeanPropertyConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.properties.PropertyReference;
import com.intellij.spring.model.properties.PropertyReferenceSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyConverterImpl
extends BeanPropertyConverter {
    public List<BeanProperty> fromString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        GenericAttributeValue value = (GenericAttributeValue)context.getInvocationElement();
        PropertyReference[] references = this.createReferences((GenericDomValue<List<BeanProperty>>)value, (PsiElement)value.getXmlAttributeValue(), context);
        if (references.length == 0) {
            return Collections.emptyList();
        }
        ResolveResult[] results = references[references.length - 1].multiResolve(false);
        ArrayList<BeanProperty> beanProperties = new ArrayList<BeanProperty>(results.length);
        for (ResolveResult result : results) {
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) continue;
            BeanProperty beanProperty = BeanProperty.createBeanProperty((PsiMethod)method);
            ContainerUtil.addIfNotNull(beanProperties, (Object)beanProperty);
        }
        return beanProperties;
    }

    public String toString(@Nullable List<BeanProperty> beanProperty, ConvertContext context) {
        return null;
    }

    @NotNull
    public PropertyReference[] createReferences(GenericDomValue<List<BeanProperty>> genericDomValue, PsiElement element, ConvertContext context) {
        if (element == null) {
            PropertyReference[] propertyReferenceArray = new PropertyReference[]{};
            if (propertyReferenceArray == null) {
                BeanPropertyConverterImpl.$$$reportNull$$$0(0);
            }
            return propertyReferenceArray;
        }
        CommonSpringBean springBean = SpringConverterUtil.getCurrentBeanCustomAware(context);
        assert (springBean != null);
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (this.isAbstractBeanTemplate(springBean, beanClass, context)) {
            PropertyReference[] propertyReferenceArray = new PropertyReference[]{};
            if (propertyReferenceArray == null) {
                BeanPropertyConverterImpl.$$$reportNull$$$0(1);
            }
            return propertyReferenceArray;
        }
        PropertyReference[] propertyReferenceArray = new PropertyReferenceSet(element, beanClass, genericDomValue, context, springBean).getPsiReferences();
        if (propertyReferenceArray == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(2);
        }
        return propertyReferenceArray;
    }

    public boolean isAbstractBeanTemplate(@NotNull CommonSpringBean springBean, @Nullable PsiClass beanClass, @NotNull ConvertContext context) {
        SpringModel model;
        boolean isAbstractBeanWithNoClass;
        if (springBean == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(3);
        }
        if (context == null) {
            BeanPropertyConverterImpl.$$$reportNull$$$0(4);
        }
        boolean bl = isAbstractBeanWithNoClass = beanClass == null && springBean instanceof SpringBean && ((SpringBean)springBean).isAbstract();
        return isAbstractBeanWithNoClass && (model = SpringConverterUtil.getSpringModel(context)) != null && model.getDescendants(BeanService.getInstance().createSpringBeanPointer(springBean)).size() == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/BeanPropertyConverterImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/BeanPropertyConverterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractBeanTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

