/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.annotator;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringEventModelUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public class SpringEventListenerAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<PublishEventPointDescriptor, Collection<? extends PsiElement>> PUBLISH_EVENT_CONVERTOR = descriptor -> ContainerUtil.createMaybeSingletonList((Object)descriptor.getNavigatableElement());
    private static final NotNullFunction<SpringEventListener, Collection<? extends PsiElement>> EVENT_LISTENER_CONVERTOR = descriptor -> ContainerUtil.createMaybeSingletonList((Object)descriptor.getPsiElement());

    public String getId() {
        return "SpringEventListenerAnnotator";
    }

    public String getName() {
        return "Application Events";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.Listener;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringCommonUtils.hasSpringFacets(psiElement.getProject()) || !SpringLibraryUtil.hasSpringLibrary(psiElement.getProject())) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (!SpringLibraryUtil.isAtLeastVersion(module, SpringLibraryUtil.SpringVersion.V_4_2)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UElement uElement;
        if (psiElement == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(3);
        }
        if (!((uElement = UastContextKt.toUElement((PsiElement)psiElement)) instanceof UMethod || uElement instanceof UCallExpression || uElement instanceof UQualifiedReferenceExpression)) {
            return;
        }
        if (uElement instanceof UMethod) {
            UMethod uMethod = (UMethod)uElement;
            PsiMethod psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class);
            if (psiMethod == null) {
                return;
            }
            if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor()) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            for (SpringEventListener eventListener : SemService.getSemService((Project)psiElement.getProject()).getSemElements(SpringEventListener.EVENT_LISTENER_ROOT_JAM_KEY, (PsiElement)psiMethod)) {
                PsiElement identifier;
                PsiType returnType;
                PsiAnnotation psiAnnotation = eventListener.getAnnotation();
                if (psiAnnotation != null) {
                    LinkedHashSet points = ContainerUtil.newLinkedHashSet();
                    for (PsiType handledType : SpringEventModelUtils.getEventListenerHandledType(eventListener)) {
                        points.addAll(SpringEventModelUtils.getPublishPoints(module, psiElement.getResolveScope(), handledType));
                    }
                    if (points.size() > 0) {
                        SpringEventListenerAnnotator.annotateEventListenerMethod(points, psiAnnotation, result);
                    }
                }
                if ((returnType = psiMethod.getReturnType()) == null || PsiType.VOID.equals((Object)returnType) || (identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) continue;
                SpringEventListenerAnnotator.annotatePublishPoints(module, result, returnType, identifier);
            }
        } else {
            UCallExpression callExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)psiElement, UCallExpression.class);
            if (callExpression != null && callExpression.getSourcePsi() == psiElement && SpringEventModelUtils.isPublishEventExpression(callExpression)) {
                SpringEventListenerAnnotator.annotateMethodCallExpression(callExpression, result);
            }
        }
    }

    private static void annotateEventListenerMethod(@NotNull Collection<PublishEventPointDescriptor> points, @NotNull PsiAnnotation psiAnnotation, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (points == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(4);
        }
        if (psiAnnotation == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(5);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(6);
        }
        SpringGutterIconBuilder<PublishEventPointDescriptor> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.Publisher, PUBLISH_EVENT_CONVERTOR, null);
        builder.setTargets(points).setPopupTitle(SpringBundle.message("spring.event.publisher.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.publisher.tooltip.text", new Object[0])).setCellRenderer((PsiElementListCellRenderer)SpringEventListenerAnnotator.getPublishEventRenderer());
        PsiElement identifier = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)psiAnnotation, UAnnotation.class)));
        if (identifier == null) {
            return;
        }
        result.add(builder.createSpringRelatedMergeableLineMarkerInfo(identifier));
    }

    @NotNull
    private static DefaultPsiElementCellRenderer getPublishEventRenderer() {
        DefaultPsiElementCellRenderer defaultPsiElementCellRenderer = new DefaultPsiElementCellRenderer(){

            protected Icon getIcon(PsiElement element) {
                if (element instanceof PsiMethodCallExpression) {
                    return SpringApiIcons.Gutter.Publisher;
                }
                return super.getIcon(element);
            }

            public String getContainerText(PsiElement element, String name) {
                PsiMethod psiMethod;
                if (element instanceof PsiMethodCallExpression && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null) {
                    PsiClass containingClass = psiMethod.getContainingClass();
                    StringBuilder sb = new StringBuilder();
                    if (containingClass != null) {
                        sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass)).append(".");
                        sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiMethod));
                        return sb.toString();
                    }
                }
                return super.getContainerText(element, name);
            }
        };
        if (defaultPsiElementCellRenderer == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(7);
        }
        return defaultPsiElementCellRenderer;
    }

    private static void annotateMethodCallExpression(@NotNull UCallExpression expression, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiType publishedType;
        List expressions;
        if (expression == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(8);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(9);
        }
        if ((expressions = expression.getValueArguments()).size() == 1 && (publishedType = ((UExpression)expressions.get(0)).getExpressionType()) != null) {
            PsiElement sourcePsi = expression.getSourcePsi();
            if (sourcePsi == null) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
            if (module == null) {
                return;
            }
            PsiElement identifier = UElementKt.getSourcePsiElement((UElement)expression.getMethodIdentifier());
            if (identifier != null) {
                SpringEventListenerAnnotator.annotatePublishPoints(module, result, publishedType, PsiTreeUtil.getDeepestFirst((PsiElement)identifier));
            }
        }
    }

    private static void annotatePublishPoints(@NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiType publishedType, @NotNull PsiElement element) {
        List<SpringEventListener> listeners;
        if (module == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(10);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(11);
        }
        if (publishedType == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(12);
        }
        if (element == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(13);
        }
        if (!(listeners = SpringEventModelUtils.getEventListeners(module, element.getResolveScope(), publishedType)).isEmpty()) {
            SpringGutterIconBuilder<SpringEventListener> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.Listener, EVENT_LISTENER_CONVERTOR, null);
            builder.setTargets(listeners).setPopupTitle(SpringBundle.message("spring.event.listener.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.listener.tooltip.text", new Object[0]));
            result.add(builder.createSpringRelatedMergeableLineMarkerInfo(element));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishedType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublishEventRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotateEventListenerMethod";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethodCallExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "annotatePublishPoints";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

