/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringRequiredAnnotationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(1);
        }
        if (!SpringLibraryUtil.hasSpringLibrary(manager.getProject())) {
            return null;
        }
        if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)method.getContainingFile())) {
            return null;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.beans.factory.annotation.Required", (int)0)) {
            return null;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return null;
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass);
        if (!info.isMapped()) {
            return null;
        }
        final String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method);
        final PsiType propertyType = PropertyUtilBase.getPropertyType((PsiMember)method);
        if (!info.getMappedProperties(propertyName).isEmpty() || info.isAutowired() || SpringRequiredAnnotationInspection.isAutowiredByDefault(method)) {
            return null;
        }
        List<DomSpringBeanPointer> list = info.getMappedDomBeans();
        final ArrayList<SpringBean> beans = new ArrayList<SpringBean>(list.size());
        for (DomSpringBeanPointer pointer : list) {
            DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
            if (!(springBean instanceof SpringBean) || ((SpringBean)springBean).isAbstract()) continue;
            beans.add((SpringBean)springBean);
        }
        if (beans.isEmpty()) {
            return null;
        }
        LocalQuickFix fix = new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SpringBundle.message("create.missing.mappings", propertyName);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("create.missing.mappings.family.name", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                HashSet<VirtualFile> files = new HashSet<VirtualFile>();
                for (SpringBean bean : beans) {
                    files.add(bean.getContainingFile().getVirtualFile());
                }
                if (!ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files).hasReadonlyFiles()) {
                    for (SpringBean bean : beans) {
                        SpringProperty springProperty = bean.addProperty();
                        springProperty.getName().setStringValue(propertyName);
                        SpringRequiredAnnotationInspection.this.setPropertyValue(project, bean, springProperty, propertyType);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringRequiredAnnotationInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringRequiredAnnotationInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        PsiIdentifier psiIdentifier = method.getNameIdentifier();
        assert (psiIdentifier != null);
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)psiIdentifier, SpringBundle.message("required.property.not.mapped", propertyName), fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
        return new ProblemDescriptor[]{descriptor};
    }

    public void setPropertyValue(@NotNull Project project, @NotNull SpringBean bean, @NotNull SpringProperty springProperty, @Nullable PsiType propertyType) {
        List<SpringBeanPointer> beansByType;
        SpringModel modelByFile;
        if (project == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(2);
        }
        if (bean == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(3);
        }
        if (springProperty == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(4);
        }
        if (propertyType != null && (modelByFile = SpringManager.getInstance(project).getSpringModelByFile(bean.getContainingFile())) != null && (beansByType = SpringBeanCoreUtils.getBeansByType(propertyType, modelByFile)).size() > 0) {
            springProperty.getRefAttr().setStringValue(beansByType.size() == 1 ? beansByType.get(0).getName() : "");
            return;
        }
        springProperty.getValueAttr().setStringValue("");
    }

    private static boolean isAutowiredByDefault(@NotNull PsiMethod method) {
        PsiType psiType;
        if (method == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(5);
        }
        return (psiType = PropertyUtilBase.getPropertyType((PsiMember)method)) != null && SpringAutowireUtil.isAutowiredByDefault(psiType);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringRequiredAnnotationInspection" == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(6);
        }
        return "SpringRequiredAnnotationInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springProperty";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringRequiredAnnotationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringRequiredAnnotationInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPropertyValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAutowiredByDefault";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

