/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringPublicFactoryMethodInspection
extends SpringBeanInspectionBase {
    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringPublicFactoryMethodInspection" == null) {
            SpringPublicFactoryMethodInspection.$$$reportNull$$$0(0);
        }
        return "SpringPublicFactoryMethodInspection";
    }

    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        GenericAttributeValue<PsiMethod> springBeanFactoryMethod;
        if (springBean == null) {
            SpringPublicFactoryMethodInspection.$$$reportNull$$$0(1);
        }
        if (beans == null) {
            SpringPublicFactoryMethodInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringPublicFactoryMethodInspection.$$$reportNull$$$0(3);
        }
        if (!DomUtil.hasXml(springBeanFactoryMethod = springBean.getFactoryMethod())) {
            return;
        }
        PsiMethod factoryMethod = (PsiMethod)springBeanFactoryMethod.getValue();
        if (factoryMethod != null && !factoryMethod.hasModifierProperty("public")) {
            holder.createProblem(springBeanFactoryMethod, HighlightSeverity.WARNING, SpringBundle.message("method.must.be.public", factoryMethod.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringPublicFactoryMethodInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringPublicFactoryMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkBean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

