/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.properties;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyFixes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.properties.PropertyReferenceSet;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference,
EmptyResolveMessageProvider,
LocalQuickFixProvider {
    private final PropertyReferenceSet myReferenceSet;
    private final int myIndex;

    public PropertyReference(PropertyReferenceSet set, TextRange range, int index) {
        super(set.getElement(), range, true);
        this.myReferenceSet = set;
        this.myIndex = index;
    }

    @Nullable
    private PsiClass getPsiClass() {
        PsiMethod method;
        PsiType type;
        if (this.isFirst()) {
            return this.myReferenceSet.getBeanClass();
        }
        Object[] results = ((PropertyReference)this.myReferenceSet.getReference(this.myIndex - 1)).multiResolve(false);
        if (results.length > 0 && (type = (method = PropertyReference.chooseMethod(ContainerUtil.map2List((Object[])results, (Function)((NullableFunction)resolveResult -> (PsiMethod)resolveResult.getElement())))).getReturnType()) instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        return null;
    }

    private Set<PsiMethod> getSharedProperties(@NotNull Collection<SpringBeanPointer> descendants) {
        if (descendants == null) {
            PropertyReference.$$$reportNull$$$0(0);
        }
        Set<PsiClass> beanClasses = PropertyReference.getUniqueBeanClasses(descendants);
        boolean acceptSetters = this.isLast();
        HashSet<PsiMethod> maps = new HashSet<PsiMethod>();
        String propertyName = this.getValue();
        for (PsiClass beanClass : beanClasses) {
            if (acceptSetters) {
                maps.addAll(PropertyUtilBase.getSetters((PsiClass)beanClass, (String)propertyName));
                continue;
            }
            maps.addAll(PropertyUtilBase.getGetters((PsiClass)beanClass, (String)propertyName));
        }
        return maps;
    }

    private static PsiMethod chooseMethod(List<PsiMethod> methods) {
        int methodsCount = methods.size();
        if (methodsCount == 1) {
            return methods.get(0);
        }
        PsiMethod chosenMethod = methods.get(0);
        for (int i = 1; i < methodsCount; ++i) {
            PsiMethod method = methods.get(i);
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)chosenMethod.getContainingClass(), (PsiClass)method.getContainingClass(), (boolean)true)) continue;
            chosenMethod = method;
        }
        return chosenMethod;
    }

    private Map<String, Set<PsiMethod>> getAllSharedProperties(@NotNull Collection<SpringBeanPointer> descendants) {
        if (descendants == null) {
            PropertyReference.$$$reportNull$$$0(1);
        }
        Set<PsiClass> beanClasses = PropertyReference.getUniqueBeanClasses(descendants);
        boolean acceptGetters = !this.isLast();
        ArrayList maps = new ArrayList();
        for (PsiClass beanClass : beanClasses) {
            maps.add(PropertyUtilBase.getAllProperties((PsiClass)beanClass, (boolean)true, (boolean)acceptGetters));
        }
        return PropertyReference.reduce(maps);
    }

    @Nullable
    public PsiMethod resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return (PsiMethod)(resolveResults.length == 1 ? resolveResults[0].getElement() : null);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String propertyName;
        PsiMethod method;
        if (this.isFirst()) {
            SpringModel model = SpringConverterUtil.getSpringModel(this.myReferenceSet.getContext());
            if (model == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    PropertyReference.$$$reportNull$$$0(2);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            Set<PsiMethod> methods = this.getSharedProperties(this.getInheritorBeansOrSelf(model));
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(methods);
            if (resolveResultArray == null) {
                PropertyReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null && (method = this.resolve(psiClass, propertyName = this.getValue())) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)method)};
            if (resolveResultArray == null) {
                PropertyReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            PropertyReference.$$$reportNull$$$0(5);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    private List<SpringBeanPointer> getInheritorBeansOrSelf(SpringModel model) {
        SpringBeanPointer pointer = BeanService.getInstance().createSpringBeanPointer(this.myReferenceSet.getBean());
        List<SpringBeanPointer> descendants = model.getDescendants(pointer);
        return descendants.isEmpty() ? Collections.singletonList(pointer) : descendants;
    }

    @Nullable
    private PsiMethod resolve(PsiClass psiClass, String propertyName) {
        boolean isLast = this.isLast();
        PsiMethod method = isLast ? PropertyUtilBase.findPropertySetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true) : PropertyUtilBase.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
        return method == null || !method.hasModifierProperty("public") ? null : method;
    }

    private boolean isLast() {
        return this.myReferenceSet.getReferences().size() - 1 == this.myIndex;
    }

    private boolean isFirst() {
        return this.myIndex == 0;
    }

    @NotNull
    public Object[] getVariants() {
        String propertyName;
        Map<String, PsiMethod> properties;
        SpringModel model = SpringConverterUtil.getSpringModel(this.myReferenceSet.getContext());
        if (model == null) {
            if (EMPTY_ARRAY == null) {
                PropertyReference.$$$reportNull$$$0(6);
            }
            return EMPTY_ARRAY;
        }
        CommonSpringBean bean = this.myReferenceSet.getBean();
        if (!this.isFirst()) {
            PsiClass psiClass = this.getPsiClass();
            if (psiClass == null) {
                if (EMPTY_ARRAY == null) {
                    PropertyReference.$$$reportNull$$$0(7);
                }
                return EMPTY_ARRAY;
            }
            properties = PropertyUtilBase.getAllProperties((PsiClass)psiClass, (boolean)true, (!this.isLast() ? 1 : 0) != 0);
        } else {
            List<SpringBeanPointer> descendants = this.getInheritorBeansOrSelf(model);
            if (!descendants.isEmpty()) {
                Map<String, Set<PsiMethod>> sharedProperties = this.getAllSharedProperties(descendants);
                properties = new HashMap();
                for (Map.Entry<String, Set<PsiMethod>> entry : sharedProperties.entrySet()) {
                    propertyName = entry.getKey();
                    PsiMethod firstMethod = entry.getValue().iterator().next();
                    properties.put(propertyName, firstMethod);
                }
            } else {
                PsiClass psiClass = this.getPsiClass();
                if (psiClass == null) {
                    if (EMPTY_ARRAY == null) {
                        PropertyReference.$$$reportNull$$$0(8);
                    }
                    return EMPTY_ARRAY;
                }
                properties = PropertyUtilBase.getAllProperties((PsiClass)psiClass, (boolean)true, (!this.isLast() ? 1 : 0) != 0);
            }
        }
        List<String> existingPropertyNames = PropertyReference.getExistingPropertyNames(bean);
        HashSet<LookupElementBuilder> variants = new HashSet<LookupElementBuilder>();
        for (Map.Entry<String, Set<Object>> entry : properties.entrySet()) {
            propertyName = entry.getKey();
            if (existingPropertyNames.contains(propertyName)) continue;
            PsiMethod psiMethod = (PsiMethod)entry.getValue();
            PsiType propertyType = PropertyUtilBase.getPropertyType((PsiMember)psiMethod);
            assert (propertyType != null);
            boolean isAutowired = AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"org.springframework.beans.factory.annotation.Autowired", (int)1);
            variants.add(LookupElementBuilder.create((Object)psiMethod, (String)propertyName).withIcon(SpringApiIcons.SpringProperty).withTailText(isAutowired ? " (@Autowired)" : "", true).withStrikeoutness(psiMethod.isDeprecated()).withTypeText(propertyType.getPresentableText()));
        }
        Object[] objectArray = variants.toArray(new LookupElementBuilder[0]);
        if (objectArray == null) {
            PropertyReference.$$$reportNull$$$0(9);
        }
        return objectArray;
    }

    @NotNull
    private static List<String> getExistingPropertyNames(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            PropertyReference.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.map(SpringPropertyUtils.getProperties(bean), SpringPropertyDefinition::getPropertyName);
        if (list == null) {
            PropertyReference.$$$reportNull$$$0(11);
        }
        return list;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name = PropertyUtilBase.getPropertyName((String)newElementName);
        return super.handleElementRename(name == null ? newElementName : name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String propertyName;
        if (element == null) {
            PropertyReference.$$$reportNull$$$0(12);
        }
        if (element instanceof PsiMethod && (propertyName = PropertyUtilBase.getPropertyName((PsiMember)((PsiMember)element))) != null) {
            return super.handleElementRename(propertyName);
        }
        return this.getElement();
    }

    @NotNull
    private static Set<PsiClass> getUniqueBeanClasses(@NotNull Collection<SpringBeanPointer> beans) {
        if (beans == null) {
            PropertyReference.$$$reportNull$$$0(13);
        }
        if (beans.isEmpty()) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                PropertyReference.$$$reportNull$$$0(14);
            }
            return set;
        }
        HashSet<PsiClass> classes = new HashSet<PsiClass>();
        for (SpringBeanPointer bean : beans) {
            PsiClass psiClass = bean.getBeanClass();
            if (psiClass == null) continue;
            classes.add(psiClass);
        }
        HashSet<PsiClass> hashSet = classes;
        if (hashSet == null) {
            PropertyReference.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    @NotNull
    private static <K, V> Map<K, Set<V>> reduce(@NotNull Collection<Map<K, V>> maps) {
        if (maps == null) {
            PropertyReference.$$$reportNull$$$0(16);
        }
        HashMap intersection = new HashMap();
        Iterator<Map<K, V>> i = maps.iterator();
        if (i.hasNext()) {
            Map<K, V> first = i.next();
            for (Map.Entry<K, V> entry : first.entrySet()) {
                HashSet<V> values = new HashSet<V>();
                values.add(entry.getValue());
                intersection.put(entry.getKey(), values);
            }
            while (i.hasNext()) {
                Map<K, V> map = i.next();
                intersection.keySet().retainAll(map.keySet());
                for (Map.Entry entry : intersection.entrySet()) {
                    ((Set)entry.getValue()).add(map.get(entry.getKey()));
                }
            }
        }
        HashMap hashMap = intersection;
        if (hashMap == null) {
            PropertyReference.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = SpringBundle.message("model.property.error.message", this.getValue());
        if (string == null) {
            PropertyReference.$$$reportNull$$$0(18);
        }
        return string;
    }

    public LocalQuickFix[] getQuickFixes() {
        PsiClass psiClass;
        String value = this.getValue();
        if (StringUtil.isNotEmpty((String)value) && (psiClass = this.getPsiClass()) != null) {
            SpringPropertyDefinition definition = (SpringPropertyDefinition)this.myReferenceSet.getGenericDomValue().getParent();
            assert (definition != null);
            PsiType type = definition.guessTypeByValue();
            return CreateBeanPropertyFixes.createFixes((String)value, (PsiClass)psiClass, (PsiType)type, (boolean)true);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/properties/PropertyReference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/properties/PropertyReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingPropertyNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueBeanClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "reduce";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSharedProperties";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllSharedProperties";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExistingPropertyNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueBeanClasses";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

