/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.PNamespaceRefValue;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.impl.SpringBeanImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringInlineHandler
implements InlineHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.refactoring.SpringInlineHandler");
    @NonNls
    private static final String PARENT_ATTR = "parent";

    public InlineHandler.Settings prepareInlineElement(@NotNull PsiElement element, Editor editor, boolean invokedOnReference) {
        if (element == null) {
            SpringInlineHandler.$$$reportNull$$$0(0);
        }
        return new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return false;
            }
        };
    }

    public void removeDefinition(@NotNull PsiElement element, @NotNull InlineHandler.Settings settings) {
        CommonSpringBean bean;
        if (element == null) {
            SpringInlineHandler.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            SpringInlineHandler.$$$reportNull$$$0(2);
        }
        if ((bean = SpringBeanUtils.getInstance().findBean(element)) instanceof DomSpringBean) {
            ((DomSpringBean)bean).undefine();
        }
    }

    public InlineHandler.Inliner createInliner(@NotNull PsiElement element, @NotNull InlineHandler.Settings settings) {
        if (element == null) {
            SpringInlineHandler.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            SpringInlineHandler.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PomTargetPsiElement)) {
            return null;
        }
        PomTarget pomTarget = ((PomTargetPsiElement)element).getTarget();
        if (!(pomTarget instanceof SpringBeanPsiTarget)) {
            return null;
        }
        SpringBeanPsiTarget target = (SpringBeanPsiTarget)pomTarget;
        if (!(target.getSpringBean() instanceof DomSpringBean)) {
            return null;
        }
        return new InlineHandler.Inliner(){

            public MultiMap<PsiElement, String> getConflicts(@NotNull PsiReference reference, @NotNull PsiElement referenced) {
                if (reference == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (referenced == null) {
                    2.$$$reportNull$$$0(1);
                }
                return null;
            }

            public void inlineUsage(@NotNull UsageInfo usage, @NotNull PsiElement referenced) {
                if (usage == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (referenced == null) {
                    2.$$$reportNull$$$0(3);
                }
                UsageTrigger.trigger((String)"spring.SpringInlineHandler");
                Project project = referenced.getProject();
                DomManager domManager = DomManager.getDomManager((Project)project);
                CommonSpringBean commonBean = SpringBeanUtils.getInstance().findBean(referenced);
                if (!(commonBean instanceof DomSpringBean)) {
                    return;
                }
                DomSpringBean bean = (DomSpringBean)commonBean;
                PsiElement psiElement = usage.getElement();
                if (!(psiElement instanceof XmlAttributeValue)) {
                    return;
                }
                XmlAttribute attribute = (XmlAttribute)psiElement.getParent();
                GenericAttributeValue value = domManager.getDomElement(attribute);
                assert (value != null);
                DomElement parent = value.getParent();
                assert (parent != null);
                if (parent instanceof DomSpringBean) {
                    String attrName = attribute.getName();
                    if (attrName.equals(SpringInlineHandler.PARENT_ATTR)) {
                        SpringInlineHandler.inlineParent(value, parent);
                    }
                    if (value instanceof PNamespaceRefValue && parent instanceof SpringBean) {
                        SpringBean springBean = (SpringBean)parent;
                        SpringProperty property = springBean.addProperty();
                        property.getName().setStringValue(((PNamespaceRefValue)value).getPropertyName());
                        SpringInlineHandler.copyBean(bean, property);
                        value.undefine();
                        SpringInlineHandler.reformat(parent);
                    }
                    return;
                }
                if (parent instanceof SpringElementsHolder) {
                    SpringInlineHandler.copyBean(bean, parent);
                    value.undefine();
                    SpringInlineHandler.reformat(parent);
                    return;
                }
                DomElement grandParent = parent.getParent();
                if (grandParent instanceof SpringElementsHolder || grandParent instanceof CollectionElements) {
                    SpringInlineHandler.copyBean(bean, grandParent);
                    parent.undefine();
                    SpringInlineHandler.reformat(grandParent);
                    return;
                }
                LOG.error("Cannot inline " + attribute);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenced";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/refactoring/SpringInlineHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getConflicts";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inlineUsage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void inlineParent(GenericAttributeValue value, DomElement parent) {
        SpringBean thisBean = (SpringBean)parent;
        SpringInlineHandler.mergeValue(thisBean, thisBean.getScope());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getLazyInit());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getAutowireCandidate());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getAutowire());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getDependencyCheck());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getDependsOn());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getFactoryBean());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getFactoryMethod());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getInitMethod());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getDestroyMethod());
        SpringInlineHandler.mergeValue(thisBean, thisBean.getDescription());
        SpringInlineHandler.mergeList(thisBean, SpringBeanImpl.CTOR_ARGS_GETTER, SpringBean::addConstructorArg);
        SpringInlineHandler.mergeList(thisBean, SpringBeanImpl.PROPERTIES_GETTER, SpringBean::addProperty);
        SpringInlineHandler.mergeList(thisBean, SpringBean::getReplacedMethods, SpringBean::addReplacedMethod);
        value.undefine();
        SpringInlineHandler.reformat(parent);
    }

    private static <T extends GenericDomValue<?>> void mergeValue(SpringBean springBean, T value) {
        T mergedValue = SpringBeanCoreUtils.getMergedValue(springBean, value);
        if (mergedValue != value) {
            value.setStringValue(mergedValue.getStringValue());
        }
    }

    public static <T extends DomElement> void mergeList(SpringBean springBean, Function<SpringBean, Collection<T>> getter, Function<SpringBean, T> adder) {
        Set<DomElement> merged = SpringBeanCoreUtils.getMergedSet(springBean, getter);
        Collection existing = (Collection)getter.fun((Object)springBean);
        for (DomElement t : existing) {
            if (!merged.contains(t)) {
                t.undefine();
                continue;
            }
            merged.remove(t);
        }
        for (DomElement t : merged) {
            DomElement newElement = (DomElement)adder.fun((Object)springBean);
            newElement.copyFrom(t);
        }
    }

    private static void reformat(DomElement domElement) {
        try {
            CodeStyleManager.getInstance((Project)domElement.getManager().getProject()).reformat((PsiElement)domElement.getXmlTag());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void copyBean(DomSpringBean from, DomElement parent) {
        XmlAttribute name;
        XmlTag newTag = (XmlTag)parent.getXmlTag().add((PsiElement)from.getXmlTag());
        XmlAttribute id = newTag.getAttribute("id");
        if (id != null) {
            id.delete();
        }
        if ((name = newTag.getAttribute("name")) != null) {
            name.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/refactoring/SpringInlineHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareInlineElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDefinition";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createInliner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

