/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.winp.WinpException;

class Native {
    public static final String DLL_NAME = "64".equals(System.getProperty("sun.arch.data.model")) ? "winp.x64" : "winp";
    private static final Logger LOGGER = Logger.getLogger(Native.class.getName());
    private static final String DLL_TARGET = "winp.folder.preferred";
    private static final String UNPACK_DLL_TO_PARENT_DIR = "winp.unpack.dll.to.parent.dir";

    Native() {
    }

    static native boolean kill(int var0, boolean var1);

    static native boolean isCriticalProcess(int var0);

    static native int setPriority(int var0, int var1);

    static native int getProcessId(int var0);

    static native boolean exitWindowsEx(int var0, int var1);

    static native String getCmdLineAndEnvVars(int var0);

    static native String getCmdLine(int var0) throws WinpException;

    static native int enumProcesses(int[] var0);

    static native void enableDebugPrivilege();

    static native void noop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String md5(URL res) {
        String string;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        InputStream in = res.openStream();
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) >= 0) {
                md5.update(buf, 0, len);
            }
            string = Native.toHex32(md5.digest());
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
            catch (IOException e) {
                throw new Error("failed to checksum " + res + ": " + e, e);
            }
        }
        in.close();
        return string;
    }

    private static void load() {
        URL res = Native.class.getClassLoader().getResource(DLL_NAME + ".dll");
        try {
            if (res != null) {
                Native.loadByUrl(res);
            } else {
                System.loadLibrary(DLL_NAME);
            }
        }
        catch (Throwable cause) {
            UnsatisfiedLinkError error = new UnsatisfiedLinkError("Unable to load " + DLL_NAME + ".dll");
            error.initCause(cause);
            throw error;
        }
    }

    private static void loadByUrl(URL res) throws IOException {
        String url = res.toExternalForm();
        if (url.startsWith("file:")) {
            File f;
            try {
                f = new File(res.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(res.getPath());
            }
            Native.loadDll(f);
            return;
        }
        try {
            File dllFile = Native.extractToStaticLocation(res);
            Native.loadDll(dllFile);
            return;
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to load DLL from static location", e);
            File dllFile = Native.extractToTmpLocation(res);
            Native.loadDll(dllFile);
            return;
        }
    }

    private static File extractToStaticLocation(URL url) throws IOException {
        File jarFile = Native.getJarFile(url);
        if (jarFile == null) {
            throw new RuntimeException("Failed to locate JAR file by URL " + url);
        }
        String preferred = System.getProperty(DLL_TARGET);
        File destFile = new File(preferred != null ? new File(preferred) : jarFile.getParentFile(), DLL_NAME + '.' + Native.md5(url) + ".dll");
        if (!destFile.exists()) {
            Native.copyStream(url.openStream(), new FileOutputStream(destFile));
        }
        return destFile;
    }

    private static File extractToTmpLocation(URL res) throws IOException {
        File tmpFile = File.createTempFile(DLL_NAME, ".dll");
        tmpFile.deleteOnExit();
        Native.copyStream(res.openStream(), new FileOutputStream(tmpFile));
        return tmpFile;
    }

    private static File getJarFile(URL res) {
        String url = res.toExternalForm();
        if (!url.startsWith("jar:") && !url.startsWith("wsjar:")) {
            return null;
        }
        int idx = url.lastIndexOf(33);
        String filePortion = url.substring(url.indexOf(58) + 1, idx);
        while (filePortion.startsWith("/")) {
            filePortion = filePortion.substring(1);
        }
        if (!filePortion.startsWith("file:")) {
            return null;
        }
        if ((filePortion = filePortion.substring(5)).startsWith("///")) {
            filePortion = filePortion.substring(2);
        } else if (filePortion.startsWith("//")) {
            // empty if block
        }
        filePortion = URLDecoder.decode(filePortion);
        return new File(filePortion.replace('/', File.separatorChar));
    }

    @SuppressFBWarnings(value={"DM_GC"}, justification="Fallback in the case of linkage errors, see details in the code")
    private static void loadDll(File dllFile) {
        try {
            System.load(dllFile.getPath());
        }
        catch (LinkageError e) {
            for (int i = 0; i < 5; ++i) {
                try {
                    System.gc();
                    System.gc();
                    Thread.sleep(1000L);
                    System.load(dllFile.getPath());
                    return;
                }
                catch (InterruptedException x) {
                    throw e;
                }
                catch (LinkageError linkageError) {
                    continue;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static String toHex32(byte[] b) {
        return String.format("%032X", new BigInteger(1, b));
    }

    static {
        Native.load();
    }
}

