/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.project.CustomProjectTypeImporter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;

public class ImportApkAction
extends DumbAwareAction {
    @NonNls
    private static final String LAST_IMPORTED_LOCATION = "last.apk.imported.location";

    public ImportApkAction() {
        super("Profile or debug APK", null, AllIcons.Css.Import);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)ApkDebugging.SYSTEM_ID);
        assert (manager != null);
        FileChooserDialogImpl chooser = new FileChooserDialogImpl(manager.getExternalProjectDescriptor(), (Project)null);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(null, new VirtualFile[]{toSelect})).length == 0) {
            return;
        }
        VirtualFile file = files[0];
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        CustomProjectTypeImporter.getMain().importFileAsProject(file);
    }

    public void update(AnActionEvent e) {
        boolean enabled = ApkDebugging.isEnabled();
        e.getPresentation().setEnabledAndVisible(enabled);
    }
}

