/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.error.IssueModel;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.util.IconUtil;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IssueNotificationAction
extends AnAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)AndroidIcons.Issue.Error);
    private final DesignSurface mySurface;

    public IssueNotificationAction(@NotNull DesignSurface surface) {
        if (surface == null) {
            IssueNotificationAction.$$$reportNull$$$0(0);
        }
        super(NO_ISSUE, NO_ISSUE, null);
        this.mySurface = surface;
        this.setDefaultIcon(false);
        this.getTemplatePresentation().setIcon(IssueNotificationAction.getIssueTypeIcon(this.mySurface.getIssueModel()));
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            IssueNotificationAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        IssueModel issueModel = this.mySurface.getIssueModel();
        int markerCount = issueModel.getIssueCount();
        presentation.setText(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
        presentation.setDescription(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
        presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            IssueNotificationAction.$$$reportNull$$$0(2);
        }
        NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.SHOW_LINT_MESSAGES);
        this.mySurface.setShowIssuePanel(true);
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel) {
        if (issueModel == null) {
            IssueNotificationAction.$$$reportNull$$$0(3);
        }
        Icon icon = issueModel.getErrorCount() > 0 ? AndroidIcons.Issue.Error : (issueModel.getWarningCount() > 0 ? AndroidIcons.Issue.Warning : (issueModel.getIssueCount() > 0 ? AndroidIcons.Issue.Info : DISABLED_ICON));
        Icon icon2 = icon;
        if (icon2 == null) {
            IssueNotificationAction.$$$reportNull$$$0(4);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueTypeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIssueTypeIcon";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

