/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.psi.PsiElement;
import icons.AndroidIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintAnnotationsModel {
    @Nullable
    private ListMultimap<NlComponent, IssueData> myIssues;
    private List<IssueData> myIssueList;

    @NotNull
    public Collection<NlComponent> getComponentsWithIssues() {
        Collection<NlComponent> collection = this.myIssues == null ? Collections.emptyList() : this.myIssues.keySet();
        if (collection == null) {
            LintAnnotationsModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Nullable
    public Icon getIssueIcon(@NotNull NlComponent component2) {
        if (component2 == null) {
            LintAnnotationsModel.$$$reportNull$$$0(1);
        }
        return this.getIssueIcon(component2, true, false);
    }

    @Nullable
    public Icon getIssueIcon(@NotNull NlComponent component2, boolean smallSize, boolean selected) {
        if (component2 == null) {
            LintAnnotationsModel.$$$reportNull$$$0(2);
        }
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component2);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        IssueData max = LintAnnotationsModel.findHighestSeverityIssue(issueData);
        boolean isError = HighlightDisplayLevel.ERROR.equals(max.level);
        if (smallSize) {
            return isError ? AndroidIcons.Issue.ErrorBadge : AndroidIcons.Issue.WarningBadge;
        }
        if (selected) {
            return isError ? AndroidIcons.Issue.ErrorSelected : AndroidIcons.Issue.WarningSelected;
        }
        return isError ? AndroidIcons.Issue.Error : AndroidIcons.Issue.Warning;
    }

    @Nullable
    public String getIssueMessage(@NotNull NlComponent component2) {
        if (component2 == null) {
            LintAnnotationsModel.$$$reportNull$$$0(3);
        }
        return this.getIssueMessage(component2, true);
    }

    @Nullable
    public String getIssueMessage(@NotNull NlComponent component2, boolean includeStaticDescription) {
        if (component2 == null) {
            LintAnnotationsModel.$$$reportNull$$$0(4);
        }
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component2);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        IssueData max = LintAnnotationsModel.findHighestSeverityIssue(issueData);
        if (includeStaticDescription) {
            return max.message + "<br><br>\n" + max.inspection.getStaticDescription();
        }
        return max.message;
    }

    private static IssueData findHighestSeverityIssue(List<IssueData> issueData) {
        return Collections.max(issueData);
    }

    public void addIssue(@NotNull NlComponent component2, @NotNull Issue issue2, @NotNull String message, @NotNull AndroidLintInspectionBase inspection, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @Nullable LintFix quickfixData) {
        if (component2 == null) {
            LintAnnotationsModel.$$$reportNull$$$0(5);
        }
        if (issue2 == null) {
            LintAnnotationsModel.$$$reportNull$$$0(6);
        }
        if (message == null) {
            LintAnnotationsModel.$$$reportNull$$$0(7);
        }
        if (inspection == null) {
            LintAnnotationsModel.$$$reportNull$$$0(8);
        }
        if (level == null) {
            LintAnnotationsModel.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            LintAnnotationsModel.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            LintAnnotationsModel.$$$reportNull$$$0(11);
        }
        if (issue2 == RtlDetector.COMPAT) {
            return;
        }
        if (this.myIssues == null) {
            this.myIssues = ArrayListMultimap.create();
            this.myIssueList = Lists.newArrayList();
        }
        IssueData data = new IssueData(component2, inspection, issue2, message, level, startElement, endElement, quickfixData);
        this.myIssues.put((Object)component2, (Object)data);
        this.myIssueList.add(data);
    }

    public int getIssueCount() {
        return this.myIssueList == null ? 0 : this.myIssueList.size();
    }

    @NotNull
    public List<IssueData> getIssues() {
        List<IssueData> list = this.myIssueList != null ? this.myIssueList : Collections.emptyList();
        if (list == null) {
            LintAnnotationsModel.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/lint/LintAnnotationsModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentsWithIssues";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/lint/LintAnnotationsModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIssueIcon";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIssueMessage";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addIssue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IssueData
    implements Comparable<IssueData> {
        @NotNull
        public final AndroidLintInspectionBase inspection;
        @NotNull
        public final HighlightDisplayLevel level;
        @NotNull
        public final String message;
        @NotNull
        public final Issue issue;
        @NotNull
        public final PsiElement endElement;
        @NotNull
        public final PsiElement startElement;
        @NotNull
        public final NlComponent component;
        @Nullable
        public final LintFix quickfixData;

        private IssueData(@NotNull NlComponent component2, @NotNull AndroidLintInspectionBase inspection, @NotNull Issue issue2, @NotNull String message, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @Nullable LintFix quickfixData) {
            if (component2 == null) {
                IssueData.$$$reportNull$$$0(0);
            }
            if (inspection == null) {
                IssueData.$$$reportNull$$$0(1);
            }
            if (issue2 == null) {
                IssueData.$$$reportNull$$$0(2);
            }
            if (message == null) {
                IssueData.$$$reportNull$$$0(3);
            }
            if (level == null) {
                IssueData.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                IssueData.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                IssueData.$$$reportNull$$$0(6);
            }
            this.component = component2;
            this.inspection = inspection;
            this.issue = issue2;
            this.message = message;
            this.level = level;
            this.startElement = startElement;
            this.endElement = endElement;
            this.quickfixData = quickfixData;
        }

        @Override
        public int compareTo(@NotNull IssueData o) {
            if (o == null) {
                IssueData.$$$reportNull$$$0(7);
            }
            return ComparisonChain.start().compare((Comparable)this.level.getSeverity(), (Comparable)o.level.getSeverity()).compare(this.issue.getPriority(), o.issue.getPriority()).compare((Comparable)o.issue.getDefaultSeverity(), (Comparable)this.issue.getDefaultSeverity()).result();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "issue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/common/lint/LintAnnotationsModel$IssueData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

