/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Coordinates {
    public static final float DEFAULT_DENSITY = 160.0f;

    public static int getSwingX(@NotNull SceneView view, int androidX) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(0);
        }
        return view.getX() + view.getContentTranslationX() + (int)(view.getScale() * (double)androidX);
    }

    public static int getSwingY(@NotNull SceneView view, int androidY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(1);
        }
        return view.getY() + view.getContentTranslationY() + (int)(view.getScale() * (double)androidY);
    }

    public static int getSwingDimension(@NotNull SceneView view, int androidDimension) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(2);
        }
        return (int)(view.getScale() * (double)androidDimension);
    }

    public static int getSwingDimension(@NotNull DesignSurface surface, int androidDimension) {
        if (surface == null) {
            Coordinates.$$$reportNull$$$0(3);
        }
        return (int)(surface.getScale() * (double)androidDimension);
    }

    public static int dpToPx(@NotNull SceneView view, int androidDp) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(4);
        }
        Configuration configuration = view.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidDp * ((float)dpiValue / 160.0f));
    }

    public static int dpToPx(@NotNull NlModel model, float androidDp) {
        if (model == null) {
            Coordinates.$$$reportNull$$$0(5);
        }
        Configuration configuration = model.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round(androidDp * ((float)dpiValue / 160.0f));
    }

    public static int pxToDp(@NotNull NlModel model, int androidPx) {
        if (model == null) {
            Coordinates.$$$reportNull$$$0(6);
        }
        Configuration configuration = model.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidPx * (160.0f / (float)dpiValue));
    }

    public static int dpToPx(@NotNull SceneView view, float androidDp) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(7);
        }
        return Coordinates.dpToPx(view.getModel(), androidDp);
    }

    public static int pxToDp(@NotNull SceneView view, int androidPx) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(8);
        }
        return Coordinates.pxToDp(view.getModel(), androidPx);
    }

    public static int getSwingXDip(@NotNull SceneView view, int androidDpX) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(9);
        }
        return Coordinates.getSwingX(view, Coordinates.dpToPx(view, androidDpX));
    }

    public static int getSwingYDip(@NotNull SceneView view, int androidDpY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(10);
        }
        return Coordinates.getSwingY(view, Coordinates.dpToPx(view, androidDpY));
    }

    public static int getSwingDimensionDip(@NotNull SceneView view, int androidDpDimension) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(11);
        }
        return Coordinates.getSwingDimension(view, Coordinates.dpToPx(view, androidDpDimension));
    }

    public static Rectangle getSwingRectDip(@NotNull SceneContext context, @NotNull Rectangle rect) {
        if (context == null) {
            Coordinates.$$$reportNull$$$0(12);
        }
        if (rect == null) {
            Coordinates.$$$reportNull$$$0(13);
        }
        return new Rectangle(context.getSwingX(rect.x), context.getSwingY(rect.y), context.getSwingDimension(rect.width), context.getSwingDimension(rect.height));
    }

    public static Rectangle getSwingRectDip(@NotNull SceneView view, @NotNull Rectangle rect) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(14);
        }
        if (rect == null) {
            Coordinates.$$$reportNull$$$0(15);
        }
        return new Rectangle(Coordinates.getSwingX(view, rect.x), Coordinates.getSwingY(view, rect.y), Coordinates.getSwingDimension(view, rect.width), Coordinates.getSwingDimension(view, rect.height));
    }

    public static int getAndroidX(@NotNull SceneView view, int swingX) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(16);
        }
        return (int)((double)(swingX - view.getX() - view.getContentTranslationX()) / view.getScale());
    }

    public static int getAndroidXDip(@NotNull SceneView view, int swingX) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(17);
        }
        return Coordinates.pxToDp(view, Coordinates.getAndroidX(view, swingX));
    }

    public static int getAndroidY(@NotNull SceneView view, int swingY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(18);
        }
        return (int)((double)(swingY - view.getY() - view.getContentTranslationY()) / view.getScale());
    }

    public static int getAndroidYDip(@NotNull SceneView view, int swingY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(19);
        }
        return Coordinates.pxToDp(view, Coordinates.getAndroidY(view, swingY));
    }

    @NotNull
    public static Point getAndroidCoordinate(@NotNull SceneView view, @NotNull Point coord) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(20);
        }
        if (coord == null) {
            Coordinates.$$$reportNull$$$0(21);
        }
        Point point = new Point(Coordinates.getAndroidX(view, coord.x), Coordinates.getAndroidY(view, coord.y));
        if (point == null) {
            Coordinates.$$$reportNull$$$0(22);
        }
        return point;
    }

    public static int getAndroidDimension(@NotNull SceneView view, int swingDimension) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(23);
        }
        return (int)((double)swingDimension / view.getScale());
    }

    public static int getAndroidDimension(@NotNull DesignSurface surface, int swingDimension) {
        if (surface == null) {
            Coordinates.$$$reportNull$$$0(24);
        }
        return (int)((double)swingDimension / surface.getScale());
    }

    public static int getAndroidDimensionDip(@NotNull SceneView view, int swingDimension) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(25);
        }
        return Coordinates.pxToDp(view, Coordinates.getSwingDimension(view, swingDimension));
    }

    public static int getAndroidDimensionDip(@NotNull DesignSurface surface, int swingDimension) {
        if (surface == null) {
            Coordinates.$$$reportNull$$$0(26);
        }
        return Coordinates.pxToDp(surface.getModel(), Coordinates.getAndroidDimension(surface, swingDimension));
    }

    @Deprecated
    @Nullable
    public static NlComponent findComponent(@NotNull SceneView view, int swingX, int swingY) {
        SceneComponent sceneComponent;
        if (view == null) {
            Coordinates.$$$reportNull$$$0(27);
        }
        return (sceneComponent = view.getScene().findComponent(SceneContext.get(view), Coordinates.getAndroidXDip(view, swingX), Coordinates.getAndroidYDip(view, swingY))) != null ? sceneComponent.getNlComponent() : null;
    }

    public static void transformGraphics(@NotNull SceneView view, @NotNull Graphics2D gc) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(28);
        }
        if (gc == null) {
            Coordinates.$$$reportNull$$$0(29);
        }
        gc.translate(view.getX(), view.getY());
        gc.scale(view.getScale(), view.getScale());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coord";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/Coordinates";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/Coordinates";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidCoordinate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSwingX";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSwingY";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSwingDimension";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dpToPx";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pxToDp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSwingXDip";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSwingYDip";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSwingDimensionDip";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSwingRectDip";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidX";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidXDip";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidY";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidYDip";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidCoordinate";
                break;
            }
            case 22: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidDimension";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidDimensionDip";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "transformGraphics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

